/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.exceptions;

import com.ibm.smarts.core.i18n.CoreMessages;
import com.ibm.smarts.core.i18n.NLS;

public abstract class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = -7309096392150305831L;
    public final int httpStatus;
    public final NLS.Message msg;
    public final Object[] params;

    protected ServiceException(Throwable cause, int httpStatus, NLS.Message msg, Object ... params) {
        super(ServiceException.buildSimpleMessage(cause, httpStatus, msg, params), cause);
        this.httpStatus = httpStatus;
        this.msg = msg;
        this.params = params;
    }

    protected ServiceException(Throwable cause, int httpStatus, String message, Object ... params) {
        super(message, cause);
        this.httpStatus = httpStatus;
        this.msg = ServiceException.messages(CoreMessages.class).internalError;
        this.params = params;
    }

    protected ServiceException(Throwable cause, String message, Object ... params) {
        this(cause, 500, message, params);
    }

    protected String getRawMessage() {
        return super.getMessage();
    }

    public String getClientMessage() {
        String ret = this.msg.bind(this.params);
        return ret;
    }

    @Override
    public String getMessage() {
        return this.getClientMessage();
    }

    protected static <T extends NLS> T messages(Class<T> clazz) {
        Object ret = NLS.get(clazz, "en");
        return ret;
    }

    private static String buildSimpleMessage(Throwable cause, int httpStatus, NLS.Message msg, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(httpStatus > 0 ? " " + httpStatus : "");
        sb.append(" msg=" + msg.bind(params));
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }
}

