/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.util.AbstractMetrics;
import com.ibm.smarts.core.util.Timer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class OperationMetrics
extends AbstractMetrics<OperationMetrics> {
    private final Map<String, OpGroupMetrics> groups;

    public OperationMetrics() {
        this(new ConcurrentHashMap<String, OpGroupMetrics>());
    }

    public OperationMetrics(Map<String, OpGroupMetrics> groups) {
        this.groups = groups;
    }

    public OpGroupMetrics group(String name) {
        OpGroupMetrics ret = this.groups.computeIfAbsent(name, n -> new OpGroupMetrics(name));
        return ret;
    }

    @Override
    public boolean isTouched() {
        return OperationMetrics.isTouched(this.groups.values());
    }

    @Override
    public long firstTouchNanos() {
        return OperationMetrics.firstTouchNanos(this.groups.values());
    }

    @Override
    public long lastTouchNanos() {
        return OperationMetrics.lastTouchNanos(this.groups.values());
    }

    @Override
    public String toString(boolean pretty, int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("[OperationMetrics");
        if (this.groups.size() > 0) {
            String[] names;
            sb.append(" groups=[");
            for (String name : names = OperationMetrics.sortedStrings(this.groups.keySet())) {
                sb.append(OperationMetrics.linePrefix(pretty, indent) + this.groups.get(name).toString(pretty, indent + 1));
            }
            sb.append("]");
        }
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public OperationMetrics combine(OperationMetrics other) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.groups.keySet());
        names.addAll(other.groups.keySet());
        ConcurrentHashMap<String, OpGroupMetrics> map = new ConcurrentHashMap<String, OpGroupMetrics>();
        for (String name : names) {
            OpGroupMetrics thisMetrics = this.groups.get(name);
            OpGroupMetrics otherMetrics = other.groups.get(name);
            OpGroupMetrics om = OperationMetrics.maybeCombine(thisMetrics, otherMetrics);
            map.put(name, om);
        }
        return new OperationMetrics(map);
    }

    private static OpGroupMetrics maybeCombine(OpGroupMetrics left, OpGroupMetrics right) {
        if (left != null && right != null) {
            return left.combine(right);
        }
        if (left == null) {
            return right.combine(new OpGroupMetrics(right.name));
        }
        return left.combine(new OpGroupMetrics(left.name));
    }

    public static class OpGroupMetrics
    extends AbstractMetrics<OpGroupMetrics> {
        public final String name;
        private final OpMetrics overall;
        private final Map<String, OpMetrics> metrics;

        public OpGroupMetrics(String name) {
            this(name, new OpMetrics(null, null), new ConcurrentHashMap<String, OpMetrics>());
        }

        private OpGroupMetrics(String name, OpMetrics overall, Map<String, OpMetrics> metrics) {
            this.name = name;
            this.overall = overall;
            this.metrics = metrics;
        }

        @Override
        public boolean isTouched() {
            return OpGroupMetrics.isTouched(this.metrics.values());
        }

        @Override
        public long firstTouchNanos() {
            return OpGroupMetrics.firstTouchNanos(this.metrics.values());
        }

        @Override
        public long lastTouchNanos() {
            return OpGroupMetrics.lastTouchNanos(this.metrics.values());
        }

        public OpMetrics metrics(String name) {
            OpMetrics ret = this.metrics.computeIfAbsent(name, n -> new OpMetrics(name, this.overall));
            return ret;
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[OpGroupMetrics name=" + this.name);
            if (this.metrics.size() > 0) {
                String[] names;
                sb.append(" metrics=[");
                for (String name : names = OpGroupMetrics.sortedStrings(this.metrics.keySet())) {
                    sb.append(OpGroupMetrics.linePrefix(pretty, indent) + this.metrics.get(name).toString(pretty, indent + 1));
                }
                sb.append("]");
            }
            sb.append(OpGroupMetrics.linePrefix(pretty, indent) + "overall=" + this.overall.toString(pretty, indent + 1));
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }

        public OpGroupMetrics combine(OpGroupMetrics other) {
            OpMetrics newOverall = this.overall.combine(null, other.overall);
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.metrics.keySet());
            names.addAll(other.metrics.keySet());
            ConcurrentHashMap<String, OpMetrics> map = new ConcurrentHashMap<String, OpMetrics>();
            for (String name : names) {
                OpMetrics thisMetrics = this.metrics.get(name);
                OpMetrics otherMetrics = other.metrics.get(name);
                OpMetrics om = OpGroupMetrics.maybeCombine(newOverall, thisMetrics, otherMetrics);
                map.put(name, om);
            }
            return new OpGroupMetrics(this.name, newOverall, map);
        }

        private static OpMetrics maybeCombine(OpMetrics overall, OpMetrics left, OpMetrics right) {
            if (left != null && right != null) {
                return left.combine(overall, right);
            }
            if (left == null) {
                return right.combine(overall, new OpMetrics(right.name, overall));
            }
            return left.combine(overall, new OpMetrics(left.name, overall));
        }
    }

    public static class OpMetrics
    extends AbstractMetrics<OpMetrics> {
        public final String name;
        public final OpMetrics parent;
        public final AsyncMetrics asyncMetrics;
        private final Map<String, AtomicLong> counters;
        private long firstTouchNanos = 0L;
        private long lastTouchNanos = 0L;

        public OpMetrics(String name, OpMetrics parent) {
            this(name, parent, null, new ConcurrentHashMap<String, AtomicLong>());
        }

        public OpMetrics(String name, OpMetrics parent, AsyncMetrics asyncMetrics, Map<String, AtomicLong> counters) {
            this.name = name;
            this.parent = parent;
            this.asyncMetrics = asyncMetrics != null ? asyncMetrics : new AsyncMetrics(parent != null ? parent.asyncMetrics : null);
            this.counters = counters;
        }

        public Timer.Stopwatch working() {
            return this.asyncMetrics.working();
        }

        private AtomicLong getCounter(String name) {
            AtomicLong value = this.counters.computeIfAbsent(name, n -> new AtomicLong(0L));
            return value;
        }

        private void touchNow() {
            long t = System.nanoTime();
            if (this.firstTouchNanos == 0L) {
                this.firstTouchNanos = t;
            }
            this.lastTouchNanos = t;
        }

        public void incrCounter(String name) {
            this.incrCounter(name, 1L);
        }

        public void incrCounter(String name, long amount) {
            if (this.parent != null) {
                this.parent.incrCounter(name, amount);
            }
            this.touchNow();
            this.getCounter(name).addAndGet(amount);
        }

        public void decrCounter(String name) {
            if (this.parent != null) {
                this.parent.decrCounter(name);
            }
            this.touchNow();
            this.getCounter(name).decrementAndGet();
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[OpMetrics");
            if (this.name != null) {
                sb.append(" name=" + this.name);
            }
            if (this.asyncMetrics.isTouched()) {
                sb.append(" metrics=" + this.asyncMetrics.toString(pretty, indent + 1));
            }
            if (this.counters.size() > 0) {
                String[] names = OpMetrics.sortedStrings(this.counters.keySet());
                String prefix = this.asyncMetrics.isTouched() ? OpMetrics.linePrefix(pretty, indent + 1) : " ";
                sb.append(prefix + "counters=[");
                if (this.counters.size() == 1) {
                    String name = names[0];
                    sb.append(name + ": " + this.getCounter(name).get());
                    sb.append("]");
                } else {
                    for (String name : names) {
                        sb.append(OpMetrics.linePrefix(pretty, indent + 2) + name + ": " + this.getCounter(name).get());
                    }
                    sb.append(OpMetrics.linePrefix(pretty, indent + 1) + "]");
                }
            }
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }

        @Override
        public boolean isTouched() {
            return this.asyncMetrics.isTouched() || this.firstTouchNanos != 0L;
        }

        @Override
        public long firstTouchNanos() {
            return OpMetrics.minNonZero(this.asyncMetrics.firstTouchNanos(), this.firstTouchNanos);
        }

        @Override
        public long lastTouchNanos() {
            return OpMetrics.max(this.asyncMetrics.lastTouchNanos(), this.lastTouchNanos);
        }

        public OpMetrics combine(OpMetrics newParent, OpMetrics other) {
            return new OpMetrics(this.name, newParent, this.asyncMetrics.combine(newParent != null ? newParent.asyncMetrics : null, other.asyncMetrics), this.combineCounters(this.counters, other.counters));
        }

        private Map<String, AtomicLong> combineCounters(Map<String, AtomicLong> left, Map<String, AtomicLong> right) {
            HashSet<String> names = new HashSet<String>();
            names.addAll(left.keySet());
            names.addAll(right.keySet());
            ConcurrentHashMap<String, AtomicLong> map = new ConcurrentHashMap<String, AtomicLong>();
            for (String name : names) {
                AtomicLong leftValue = left.computeIfAbsent(name, n -> new AtomicLong(0L));
                AtomicLong rightValue = right.computeIfAbsent(name, n -> new AtomicLong(0L));
                AtomicLong combinedValue = new AtomicLong(leftValue.get() + rightValue.get());
                map.put(name, combinedValue);
            }
            return map;
        }
    }
}

