/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.util.AbstractMetrics;
import com.ibm.smarts.core.util.MetricsHelper;
import com.ibm.smarts.core.util.Tuple2;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;

public class Timer {
    private static String durationString(long nanos) {
        return MetricsHelper.stringForNanosToMillis(nanos);
    }

    public static class Stopwatch
    implements Closeable {
        private final long startNanos;
        private final DurationTally counters;

        public Stopwatch(DurationTally counters) {
            this.startNanos = counters.durationStart();
            this.counters = counters;
        }

        @Override
        public void close() {
            this.counters.durationEndNow(this.startNanos);
        }
    }

    public static class DurationTally
    extends AbstractMetrics<DurationTally> {
        public final DurationTally parent;
        private final AtomicLong maxNanos;
        private final AtomicLong totalNanos;
        private final CountTally count;

        public DurationTally() {
            this(null);
        }

        public DurationTally(DurationTally parent) {
            this(parent, 0L, 0L, null);
        }

        private DurationTally(DurationTally parent, long maxNanos, long totalNanos, CountTally count) {
            this.parent = parent;
            this.maxNanos = new AtomicLong(maxNanos);
            this.totalNanos = new AtomicLong(totalNanos);
            this.count = count != null ? count : new CountTally(parent != null ? parent.count : null);
        }

        public DurationTally combine(DurationTally newParent, DurationTally other) {
            return new DurationTally(newParent, Math.max(this.getMaxNanos(), other.getMaxNanos()), this.getTotalNanos() + other.getTotalNanos(), this.count.combine(newParent != null ? newParent.count : null, other.count));
        }

        @Override
        public boolean isTouched() {
            return this.getCount() > 0L;
        }

        @Override
        public long firstTouchNanos() {
            return this.count.firstTouchNanos();
        }

        @Override
        public long lastTouchNanos() {
            return this.count.lastTouchNanos();
        }

        public long getCount() {
            return this.count.total();
        }

        public long getTotalNanos() {
            return this.totalNanos.get();
        }

        public long getAverageNanos() {
            if (this.getCount() == 0L) {
                return 0L;
            }
            return this.getTotalNanos() / this.getCount();
        }

        public long getMaxNanos() {
            return this.maxNanos.get();
        }

        public long durationStart() {
            long nowNanos = System.nanoTime();
            return this.durationStart(nowNanos);
        }

        public long durationStart(long nowNanos) {
            this.count.increment(nowNanos);
            return nowNanos;
        }

        public long durationEndNow() {
            return this.durationEnd(System.nanoTime());
        }

        private long durationEnd(long nowNanos) {
            this.count.decrement(nowNanos);
            return nowNanos;
        }

        public long durationEndNow(long startNanos) {
            long nowNanos = System.nanoTime();
            return this.durationEnd(startNanos, nowNanos);
        }

        public long durationEnd(long startNanos, long endNanos) {
            this.durationEnd(endNanos);
            long durationNanos = endNanos - startNanos;
            this.addDuration(durationNanos);
            return endNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDuration(long durationNanos) {
            if (this.parent != null) {
                this.parent.addDuration(durationNanos);
            }
            this.totalNanos.addAndGet(durationNanos);
            long maxOrig = this.maxNanos.get();
            if (maxOrig < durationNanos) {
                DurationTally durationTally = this;
                synchronized (durationTally) {
                    long maxNow = this.maxNanos.get();
                    if (maxNow < durationNanos) {
                        this.maxNanos.set(durationNanos);
                    }
                }
            }
        }

        public double getAverage() {
            return this.count.getAverage();
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            long c = this.count.total();
            String durationStr = Timer.durationString(this.totalNanos.get());
            if (c > 1L) {
                sb.append("[count=" + this.count);
                sb.append(" duration=[");
                sb.append("totalMs=" + durationStr);
                sb.append(" maxMs=" + Timer.durationString(this.getMaxNanos()));
                sb.append(" avgMs=" + Timer.durationString(this.getAverageNanos()));
                sb.append("]");
            } else {
                sb.append("[count=" + c);
                sb.append(" durationMs=" + durationStr);
            }
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }
    }

    public static class CountTally
    extends AbstractMetrics<CountTally> {
        public final CountTally parent;
        private final AtomicLong total;
        private final AtomicLong current;
        private final AtomicLong maxCurrent;
        private long countNanos = 0L;
        private long firstChangeTimeNanos = 0L;
        private long lastChangeTimeNanos = 0L;
        private long trackedDurationNanos = 0L;

        public CountTally() {
            this(null, 0L, 0L, 0L);
        }

        public CountTally(CountTally parent) {
            this(parent, 0L, 0L, 0L);
        }

        public CountTally(CountTally parent, long total, long current, long maxCurrent) {
            this(parent, total, current, maxCurrent, 0L, -1L, -1L, -1L);
        }

        public CountTally(CountTally parent, long total, long current, long maxCurrent, long countNanos, long firstChangeTimeNanos, long lastChangeTimeNanos, long trackedDurationNanos) {
            this.parent = parent;
            this.total = new AtomicLong(total);
            this.current = new AtomicLong(current);
            this.maxCurrent = new AtomicLong(maxCurrent);
            this.countNanos = countNanos;
            this.firstChangeTimeNanos = firstChangeTimeNanos > -1L ? firstChangeTimeNanos : 0L;
            this.lastChangeTimeNanos = lastChangeTimeNanos > -1L ? lastChangeTimeNanos : 0L;
            this.trackedDurationNanos = trackedDurationNanos > -1L ? trackedDurationNanos : 0L;
        }

        @Override
        public boolean isTouched() {
            return this.total() > 0L;
        }

        @Override
        public long firstTouchNanos() {
            return this.firstChangeTimeNanos;
        }

        @Override
        public long lastTouchNanos() {
            long ret = this.lastChangeTimeNanos > 0L ? this.lastChangeTimeNanos : this.firstChangeTimeNanos;
            return ret;
        }

        public long total() {
            return this.total.get();
        }

        public long maxCurrent() {
            return this.maxCurrent.get();
        }

        public long increment() {
            return this.increment(System.nanoTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long increment(long nowNanos) {
            long max;
            long prev;
            long c;
            if (nowNanos == 0L) {
                String string = "what";
            }
            if (this.parent != null) {
                this.parent.increment(nowNanos);
            }
            this.total.incrementAndGet();
            CountTally countTally = this;
            synchronized (countTally) {
                if (this.firstChangeTimeNanos == 0L) {
                    this.firstChangeTimeNanos = nowNanos;
                }
                c = this.current.incrementAndGet();
                prev = c - 1L;
                max = this.maxCurrent.get();
                this.recordAvgCount(prev, this.lastChangeTimeNanos, nowNanos);
                this.lastChangeTimeNanos = nowNanos;
            }
            if (c > max) {
                countTally = this;
                synchronized (countTally) {
                    long realCurrent = this.current.get();
                    long realMax = this.maxCurrent.get();
                    if (realCurrent > realMax) {
                        this.maxCurrent.set(realCurrent);
                    }
                }
            }
            return prev;
        }

        public long decrement() {
            return this.decrement(System.nanoTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long decrement(long nowNanos) {
            long prev;
            if (nowNanos == 0L) {
                String string = "what";
            }
            if (this.parent != null) {
                this.parent.decrement(nowNanos);
            }
            CountTally countTally = this;
            synchronized (countTally) {
                prev = this.current.getAndDecrement();
                this.recordAvgCount(prev, this.lastChangeTimeNanos, nowNanos);
                if (nowNanos > this.lastChangeTimeNanos) {
                    this.lastChangeTimeNanos = nowNanos;
                }
            }
            return prev;
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[CountTally");
            sb.append(" total=" + this.total.get());
            if (this.current.get() > 0L) {
                sb.append(" current=" + this.current.get());
            }
            sb.append(" maxConcurrent=" + this.maxCurrent.get());
            sb.append(" avgConcurrent=" + MetricsHelper.string(this.getAverage()));
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }

        public CountTally combine(CountTally newParent, CountTally other) {
            long newFirstChangeNanos = this.getNonZeroMin(this.firstChangeTimeNanos, other.firstChangeTimeNanos);
            long newLastChangeNanos = this.getMax(this.lastChangeTimeNanos, other.lastChangeTimeNanos);
            return new CountTally(newParent, this.total() + other.total(), this.current.get() + other.current.get(), Math.max(this.maxCurrent(), other.maxCurrent()), this.countNanos + other.countNanos, newFirstChangeNanos, newLastChangeNanos, this.getEstimatedTrackedDuration(newFirstChangeNanos, newLastChangeNanos, this, other));
        }

        private long getNonZeroMin(long ... ls) {
            long ret = Long.MAX_VALUE;
            for (long l : ls) {
                if (l <= 0L || l >= ret) continue;
                ret = l;
            }
            if (ret == Long.MAX_VALUE) {
                ret = 0L;
            }
            return ret;
        }

        private long getMax(long ... ls) {
            long ret = 0L;
            for (long l : ls) {
                if (l <= ret) continue;
                ret = l;
            }
            return ret;
        }

        private long getEstimatedTrackedDuration(long firstChange, long lastChange, CountTally left, CountTally right) {
            long ret;
            Tuple2<Long, Long> leftSpan = left.activeSpanNanos();
            Tuple2<Long, Long> rightSpan = right.activeSpanNanos();
            if ((Long)leftSpan._1 <= (Long)rightSpan._2 || (Long)rightSpan._1 <= (Long)leftSpan._2) {
                ret = left.trackedDurationNanos + right.trackedDurationNanos;
            } else {
                long newStart = Math.min((Long)leftSpan._1, (Long)rightSpan._1);
                long newEnd = Math.max((Long)leftSpan._2, (Long)rightSpan._2);
                ret = newEnd - newStart;
            }
            return ret;
        }

        private void recordAvgCount(long prevCount, long prevChangeNanos, long nowNanos) {
            if (prevCount > 0L) {
                long currentDuration = nowNanos - prevChangeNanos;
                this.trackedDurationNanos += currentDuration;
                long thisCountNanos = prevCount * currentDuration;
                this.countNanos += thisCountNanos;
            }
        }

        public double getAverage() {
            if (this.trackedDurationNanos == 0L) {
                return 0.0;
            }
            if (this.countNanos == 0L) {
                return 0.0;
            }
            double ret = (double)this.countNanos / (double)this.trackedDurationNanos;
            if (ret < 0.001) {
                String string = "?";
            }
            return ret;
        }
    }
}

