/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.internal.ontology.api;

import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.internal.ontology.api.ConceptClassifier;
import com.ibm.smarts.internal.ontology.api.KnowledgeDiscoveryClient;
import com.ibm.smarts.internal.ontology.api.function.OntologySmartsModuleTasks;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeDiscoveryClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnowledgeDiscoveryClientFactory.class);
    private static KnowledgeDiscoveryClientFactory instance = null;
    private static boolean isInitialized = false;
    private final ConceptClassifier<SmartsModule, SmartsModule> classifier;

    private KnowledgeDiscoveryClientFactory(ConceptClassifier<SmartsModule, SmartsModule> classifier) {
        this.classifier = classifier;
    }

    public static KnowledgeDiscoveryClientFactory getInstance() {
        if (null == instance) {
            throw new IllegalStateException("OntologyClientFactory was not initialized.");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(IStoreProvider storeProvider, MessageQueueingSystem messageSystem, ConceptClassifier<SmartsModule, SmartsModule> classifier) {
        if (instance != null) {
            throw new IllegalStateException("OntologyClientFactory was already initialized.");
        }
        Class<KnowledgeDiscoveryClientFactory> clazz = KnowledgeDiscoveryClientFactory.class;
        synchronized (KnowledgeDiscoveryClientFactory.class) {
            if (instance == null) {
                instance = new KnowledgeDiscoveryClientFactory(classifier);
                isInitialized = true;
                LOGGER.info("OntologyClientFactory initialized");
                new OntologySmartsModuleTasks(storeProvider, messageSystem).configure();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (instance == null) {
            return;
        }
        Class<KnowledgeDiscoveryClientFactory> clazz = KnowledgeDiscoveryClientFactory.class;
        synchronized (KnowledgeDiscoveryClientFactory.class) {
            if (instance != null) {
                instance.destory();
                instance = null;
                isInitialized = false;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public KnowledgeDiscoveryClient getOntologyClient() {
        KnowledgeDiscoveryClient client = new KnowledgeDiscoveryClient();
        client.setConceptClassifier(this.classifier);
        return client;
    }

    void destory() {
        LOGGER.info("OntologyClientFactory destroyed");
    }
}

