/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.value.BooleanValue;
import com.ibm.smarts.model.value.ByteValue;
import com.ibm.smarts.model.value.DateValue;
import com.ibm.smarts.model.value.DecimalValue;
import com.ibm.smarts.model.value.DoubleValue;
import com.ibm.smarts.model.value.FloatValue;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.model.value.LongValue;
import com.ibm.smarts.model.value.StringValue;
import com.ibm.smarts.model.value.TimeValue;
import com.ibm.smarts.model.value.TimestampValue;
import com.ibm.smarts.model.value.UnknownValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueStatus;
import java.io.IOException;
import java.math.BigDecimal;

public class ValueDeserializer
extends StdDeserializer<Value> {
    private static final long serialVersionUID = 1567928548150398987L;

    public ValueDeserializer() {
        super(Value.class);
    }

    protected ValueDeserializer(Class<?> vc) {
        super(vc);
    }

    public Value deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String type = node.get("type").asText();
        BaseDataType dataType = BaseDataType.UNKNOWN;
        try {
            dataType = BaseDataType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        ValueStatus status = ValueStatus.OK;
        if (node.get("status") != null) {
            String statusString = node.get("status").asText().toUpperCase();
            try {
                status = ValueStatus.valueOf(statusString);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        switch (dataType) {
            case BOOLEAN: {
                boolean booleanVal = false;
                if (node.get("booleanValue") != null) {
                    booleanVal = node.get("booleanValue").asBoolean();
                }
                return new BooleanValue(booleanVal, status);
            }
            case BYTE: {
                byte val = 0;
                if (node.get("byteValue") != null) {
                    val = node.get("byteValue").numberValue().byteValue();
                }
                return new ByteValue(val, status);
            }
            case SHORT: {
                int val = 0;
                if (node.get("shortValue") != null) {
                    val = node.get("shortValue").numberValue().shortValue();
                }
                return new IntegerValue(val, status);
            }
            case INTEGER: {
                int val = 0;
                if (node.get("integerValue") != null) {
                    val = node.get("integerValue").numberValue().intValue();
                }
                return new IntegerValue(val, status);
            }
            case LONG: {
                long val = 0L;
                if (node.get("longValue") != null) {
                    val = node.get("longValue").numberValue().longValue();
                }
                return new LongValue(val, status);
            }
            case FLOAT: {
                float val = 0.0f;
                if (node.get("floatValue") != null) {
                    val = node.get("floatValue").floatValue();
                }
                return new FloatValue(val, status);
            }
            case DOUBLE: {
                double val = 0.0;
                if (node.get("doubleValue") != null) {
                    val = node.get("doubleValue").asDouble();
                }
                return new DoubleValue(val, status);
            }
            case DECIMAL: {
                BigDecimal val = new BigDecimal(0);
                if (node.get("decimalValue") != null) {
                    val = node.get("decimalValue").decimalValue();
                }
                DecimalValue value = new DecimalValue(val);
                value.setStatus(status);
                return value;
            }
            case DATE: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(node.get("timeInMillis").asLong());
                DateValue value = new DateValue((Calendar)cal);
                value.setStatus(status);
                return value;
            }
            case TIMESTAMP: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(node.get("timeInMillis").asLong());
                TimestampValue value = new TimestampValue((Calendar)cal);
                value.setStatus(status);
                return value;
            }
            case TIME: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(node.get("timeInMillis").asLong());
                TimeValue value = new TimeValue((Calendar)cal);
                value.setStatus(status);
                return value;
            }
            case STRING: {
                return new StringValue(node.get("stringValue").asText(), status);
            }
            case UNKNOWN: {
                return new UnknownValue(node.get("stringValue").asText(), status);
            }
        }
        return new UnknownValue();
    }

    public Value deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(jp, ctxt);
    }
}

