/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.schema.DatasetValue;
import org.apache.commons.lang3.StringUtils;

public class DatasetValueUtil {
    private static String PIPE = "|";

    private DatasetValueUtil() {
    }

    public static String generateDatasetValueID(DatasetValue datasetValue) {
        String value = datasetValue.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("value must not be blank");
        }
        String valueUC = datasetValue.getValueUC();
        if (StringUtils.isBlank((CharSequence)valueUC)) {
            throw new IllegalArgumentException("valueUC must not be blank");
        }
        String column = datasetValue.getColumn();
        if (StringUtils.isBlank((CharSequence)column)) {
            throw new IllegalArgumentException("column must not be blank");
        }
        String columnUC = datasetValue.getColumnUC();
        if (StringUtils.isBlank((CharSequence)columnUC)) {
            throw new IllegalArgumentException("columnUC must not be blank");
        }
        String datasetRef = datasetValue.getDatasetRef();
        if (StringUtils.isBlank((CharSequence)datasetRef)) {
            throw new IllegalArgumentException("datasetRef must not be blank");
        }
        String smartsModuleRef = datasetValue.getSmartsModuleRef();
        if (StringUtils.isBlank((CharSequence)smartsModuleRef)) {
            throw new IllegalArgumentException("smartsModuleRef must not be blank");
        }
        String tenantID = datasetValue.getTenantID();
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw new IllegalArgumentException("tenantID must not be blank");
        }
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(Integer.toHexString(value.hashCode()));
        DatasetValueUtil.appendHexString(idBuilder, valueUC);
        DatasetValueUtil.appendHexString(idBuilder, column);
        DatasetValueUtil.appendHexString(idBuilder, columnUC);
        DatasetValueUtil.appendHexString(idBuilder, datasetRef);
        DatasetValueUtil.appendHexString(idBuilder, smartsModuleRef);
        DatasetValueUtil.appendHexString(idBuilder, tenantID);
        return idBuilder.toString();
    }

    private static void appendHexString(StringBuilder idBuilder, String value) {
        idBuilder.append(PIPE);
        idBuilder.append(Integer.toHexString(value.hashCode()));
    }
}

