/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.util;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.types.TypedString;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientManager.class);
    protected final RequestContext requestContext;
    protected final Map<RestClientType, RestClient> clients = new HashMap<RestClientType, RestClient>();
    protected final RestClient.RestCallContextFactory restCallContextFactory;

    public static <T> T getClientManager(RequestContext requestContext, Class<T> clazz, String clientManagerRequestAttributeName) {
        Object clientManagerObject;
        ObjectCreator creator = (ObjectCreator)requestContext.getRequestAttribute(clientManagerRequestAttributeName);
        if (creator != null) {
            clientManagerObject = creator.create(requestContext);
            if (clientManagerObject == null) {
                throw new InternalException("failed to create client manager from request context ", new Object[]{clazz, creator});
            }
        } else {
            throw new InternalException("missing client manager creator in request context", new Object[]{requestContext});
        }
        return (T)clientManagerObject;
    }

    public RestClientManager(RequestContext requestContext) {
        this.requestContext = requestContext;
        this.restCallContextFactory = (RestClient.RestCallContextFactory)requestContext.getAttribute("com.ibm.smarts.rest.restCallContextFactory");
    }

    protected synchronized <T extends RestClient> T getClient(RestClientType type, String baseUri, Supplier<T> supplier) {
        RestClient client = this.clients.get((Object)type);
        if (client == null) {
            client = (RestClient)supplier.get();
            this.clients.put(type, client);
        }
        return (T)client;
    }

    public Map<RestClientType, RestClient> getSmartsClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    @Override
    public synchronized void close() throws IOException {
        this.clients.forEach((clientType, client) -> {
            try {
                client.close();
            }
            catch (IOException e) {
                LOGGER.error("failed to close REST client of type " + (Object)clientType, (Throwable)e);
            }
        });
        this.clients.clear();
    }

    public static class RestClientType
    extends TypedString {
        public RestClientType(String value) {
            super(value);
        }
    }

    public static class ClientManagerCreator
    implements ObjectCreator<RestClientManager> {
        public static ClientManagerCreator from(RestClientManager clientManager) {
            return new ClientManagerCreator();
        }

        public RestClientManager create(RequestContext requestContext) {
            return new RestClientManager(requestContext);
        }
    }
}

