/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class URIUtil {
    private static final Set<Character> reserved = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('&'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('$'), Character.valueOf(',')));
    private static final Set<Character> mark = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')')));

    public static int getLocalNameIndex(String uri) {
        int separatorIdx = uri.indexOf(35);
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(47);
        }
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(58);
        }
        if (separatorIdx < 0) {
            throw new IllegalArgumentException("No separator character founds in URI: " + uri);
        }
        return separatorIdx + 1;
    }

    public static boolean isCorrectURISplit(String namespace, String localName) {
        assert (namespace != null) : "namespace must not be null";
        assert (localName != null) : "localName must not be null";
        if (namespace.length() == 0) {
            return false;
        }
        int nsLength = namespace.length();
        char lastNsChar = namespace.charAt(nsLength - 1);
        if (lastNsChar == '#') {
            return namespace.lastIndexOf(35, nsLength - 2) == -1;
        }
        if (lastNsChar == '/') {
            return localName.indexOf(47) == -1 && localName.indexOf(35) == -1 && namespace.indexOf(35) == -1;
        }
        if (lastNsChar == ':') {
            return localName.indexOf(58) == -1 && localName.indexOf(35) == -1 && localName.indexOf(47) == -1 && namespace.indexOf(35) == -1 && namespace.indexOf(47) == -1;
        }
        return false;
    }

    public static boolean isValidURIReference(String uriRef) {
        boolean valid;
        boolean bl = valid = !uriRef.matches("[\u0000-\u001f\u007f-\u009f]");
        if (valid) {
            String escaped = URIUtil.escapeExcludedChars(uriRef);
            try {
                URI uri = new URI(escaped);
                valid = uri.isAbsolute();
            }
            catch (URISyntaxException e) {
                valid = false;
            }
        }
        return valid;
    }

    private static String escapeExcludedChars(String unescaped) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < unescaped.length(); ++i) {
            char c = unescaped.charAt(i);
            if (!URIUtil.isUnreserved(c) && !reserved.contains(Character.valueOf(c))) {
                escaped.append("%" + Integer.toHexString(c));
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private static boolean isUnreserved(char c) {
        boolean unreserved;
        char n = c;
        boolean bl = unreserved = '/' < n && n < ':' || '`' < n && n < '{' || '@' < n && n < '[';
        if (!unreserved) {
            unreserved = mark.contains(Character.valueOf(c));
        }
        return unreserved;
    }
}

