/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.DatasetSpec;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.IDatasetReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvDatasetReader
implements IDatasetReader {
    private static final long serialVersionUID = -6287657497804176339L;
    private List<List<String>> dataset = new ArrayList<List<String>>();
    private DatasetSpec spec;

    @Override
    public void readDataset(String datasetFile, String specFile) throws IOException {
        if (datasetFile == null) {
            throw new IllegalArgumentException("Invalid Dataset path");
        }
        if (specFile == null) {
            throw new IllegalArgumentException("Invalid SpecFile path");
        }
        File data = new File(datasetFile);
        if (!data.exists()) {
            throw new IOException("Dataset does not exist - " + datasetFile);
        }
        File specs = new File(specFile);
        if (!specs.exists()) {
            throw new IOException("Dataset does not exist - " + datasetFile);
        }
        CSVParser parser = CSVParser.parse((File)data, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT);
        for (CSVRecord rec : parser.getRecords()) {
            ArrayList row = new ArrayList();
            rec.forEach(row::add);
            this.dataset.add(row);
        }
        BufferedInputStream bf = new BufferedInputStream(new FileInputStream(specs));
        this.spec = (DatasetSpec)JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)bf), DatasetSpec.class);
    }

    @Override
    public void readDataset(InputStream dataStream, InputStream specStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException("Invalid Dataset stream");
        }
        if (specStream == null) {
            throw new IllegalArgumentException("Invalid Dataset stream");
        }
        String csvString = new BufferedReader(new InputStreamReader(dataStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        CSVParser parser = CSVParser.parse((String)csvString, (CSVFormat)CSVFormat.DEFAULT);
        for (CSVRecord rec : parser.getRecords()) {
            ArrayList row = new ArrayList();
            rec.forEach(row::add);
            this.dataset.add(row);
        }
        BufferedInputStream bf = new BufferedInputStream(specStream);
        this.spec = (DatasetSpec)JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)bf), DatasetSpec.class);
    }

    @Override
    public List<List<String>> getDataset() {
        return this.dataset;
    }

    @Override
    public DatasetSpec getSpec() {
        return this.spec;
    }
}

