/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline;

import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression.ITransformer;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline.ValueNotInTrainingDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OneHotEncoder
implements ITransformer {
    private static final long serialVersionUID = 4462785078031801897L;
    final String name;
    final int column;
    private Map<String, Integer> values = new HashMap<String, Integer>();
    int size;

    public OneHotEncoder(String name, int column) {
        this.name = name;
        this.column = column;
    }

    public OneHotEncoder(String name, int column, Map<String, Integer> values, int size) {
        this(name, column);
        this.values = new HashMap<String, Integer>(values);
        this.size = size;
    }

    @Override
    public void transform(List<List<String>> in, List<List<Double>> out) {
        int i;
        if (in == null || out == null) {
            throw new IllegalArgumentException("Invalid vector lists");
        }
        for (i = 0; i < in.size(); ++i) {
            List<String> vector = in.get(i);
            String category = vector.get(this.column).trim();
            this.values.computeIfAbsent(category, k -> this.size++);
        }
        for (i = 0; i < in.size(); ++i) {
            ArrayList<Double> oneHotEncoded = new ArrayList<Double>(Collections.nCopies(this.size, 0.0));
            List<String> vector = in.get(i);
            String category = vector.get(this.column).trim();
            int value = this.values.get(category);
            oneHotEncoded.set(value, 1.0);
            List<Double> outVector = out.get(i);
            outVector.addAll(oneHotEncoded);
        }
    }

    @Override
    public void transformVector(List<String> in, List<Double> out) throws ValueNotInTrainingDataException {
        ArrayList<Double> oneHotEncoded = new ArrayList<Double>(Collections.nCopies(this.size, 0.0));
        String category = in.get(this.column).trim();
        int value = this.values.getOrDefault(category, -1);
        if (value == -1) {
            throw new ValueNotInTrainingDataException("CATEGORICAL_NONORDINAL value: " + category + ", Does not exist in training data for the module.\nTraining data must contain at least one example using the value: " + category + "for feature: " + this.column);
        }
        oneHotEncoded.set(value, 1.0);
        out.addAll(oneHotEncoded);
    }
}

