/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline;

import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression.ITransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StandardScaler
implements ITransformer {
    private static final long serialVersionUID = -1698856936245569736L;
    private List<Double> mean;
    private List<Double> variance;
    private List<Double> max;

    public StandardScaler() {
    }

    private void buildModel(List<List<Double>> in) {
        int nrSamples = in.size();
        int nrFeatures = in.get(0).size();
        this.mean = new ArrayList<Double>(Collections.nCopies(nrFeatures, 0.0));
        this.variance = new ArrayList<Double>(Collections.nCopies(nrFeatures, 0.0));
        this.max = new ArrayList<Double>(Collections.nCopies(nrFeatures, 0.0));
        for (int feature = 1; feature < nrFeatures; ++feature) {
            double fmean = this.mean.get(feature);
            double fsumOfSqValues = this.variance.get(feature);
            double maxValue = Double.NEGATIVE_INFINITY;
            for (List<Double> v : in) {
                double value = v.get(feature);
                fmean += value / (double)nrSamples;
                fsumOfSqValues += value * value / (double)nrSamples;
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
            this.max.set(feature, maxValue);
            this.mean.set(feature, fmean);
            this.variance.set(feature, fsumOfSqValues - fmean * fmean);
        }
    }

    public StandardScaler(List<Double> mean, List<Double> variance, List<Double> max) {
        this.mean = mean;
        this.variance = variance;
        this.max = max;
    }

    @Override
    public void transform(List<List<String>> in, List<List<Double>> out) {
        this.buildModel(out);
        int size = out.get(0).size();
        for (int feature = 1; feature < size; ++feature) {
            double fmean = this.mean.get(feature);
            double fvariance = this.variance.get(feature) < 1.0E-9 ? 1.0E-9 : this.variance.get(feature);
            for (int v = 0; v < in.size(); ++v) {
                List<Double> outVector = out.get(v);
                if (this.max.get(feature) == 0.0) continue;
                outVector.set(feature, (outVector.get(feature) - fmean) / Math.sqrt(fvariance));
            }
        }
    }

    @Override
    public void transformVector(List<String> in, List<Double> out) {
        for (int feature = 1; feature < in.size(); ++feature) {
            double fvariance;
            double fmean = this.mean.get(feature);
            double d = fvariance = this.variance.get(feature) < 1.0E-9 ? 1.0E-9 : this.variance.get(feature);
            if (this.max.get(feature) == 0.0) continue;
            out.set(feature, (out.get(feature) - fmean) / Math.sqrt(fvariance));
        }
    }
}

