/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.interpretation;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PostProcessor;
import com.ibm.smarts.qa.api.SemanticAnnotation;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InterpretationUnit {
    private PhraseInfo phraseInfo;
    private List<SemanticAnnotation> semanticAnnotations;

    public InterpretationUnit(PhraseInfo info) {
        this.phraseInfo = info;
        if (this.requireSemanticAnalysis()) {
            this.semanticAnnotations = new ArrayList<SemanticAnnotation>();
            if (this.phraseInfo.getTokens().size() > 1 && this.allNouns(this.phraseInfo)) {
                this.phraseInfo.getTokens().forEach(t -> {
                    PhraseInfo p = new PhraseInfo();
                    p.setText(t.getText());
                    p.getTokens().add(t);
                    SemanticAnnotation sa = new SemanticAnnotation(p);
                    this.semanticAnnotations.add(sa);
                });
            } else {
                SemanticAnnotation sa = new SemanticAnnotation(this.phraseInfo);
                this.semanticAnnotations.add(sa);
            }
        }
    }

    private boolean allNouns(PhraseInfo phrase) {
        return phrase.getTokens().stream().allMatch(t -> PostProcessor.POS_NOUN.contains(t.getPOSlocal()));
    }

    public InterpretationUnit(InterpretationUnit copy) {
        this.phraseInfo = copy.phraseInfo;
        this.semanticAnnotations = copy.semanticAnnotations;
    }

    public int getStartIndex() {
        if (this.phraseInfo != null && !this.phraseInfo.getTokens().isEmpty()) {
            return ((TokenInfo)this.phraseInfo.getTokens().get(0)).getPositionInPhrase();
        }
        return -1;
    }

    public int getEndIndex() {
        if (this.phraseInfo != null && !this.phraseInfo.getTokens().isEmpty()) {
            List tokens = this.phraseInfo.getTokens();
            return ((TokenInfo)tokens.get(tokens.size() - 1)).getPositionInPhrase();
        }
        return -1;
    }

    public boolean detectOverlap(InterpretationUnit aIU) {
        if (this.getUnit() == null) {
            return false;
        }
        return this.getStartIndex() == aIU.getStartIndex();
    }

    public int size() {
        if (this.getUnit() == null) {
            return 0;
        }
        return 1;
    }

    public PhraseInfo getUnit() {
        return this.phraseInfo;
    }

    public String getText() {
        return this.phraseInfo.getText();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.getText());
        try {
            sb.append(JAXBHelper.marshalToJSON((Object)this.getUnit()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.hasSemanticAnnotation()) {
            sb.append(this.getSemanticAnnotations());
        }
        sb.append(")");
        return sb.toString();
    }

    public InterpretationUnit copy() {
        InterpretationUnit copy = new InterpretationUnit(this.phraseInfo);
        return copy;
    }

    public boolean isStopWord() {
        return this.phraseInfo.getTokens().size() == 1 && ((TokenInfo)this.phraseInfo.getTokens().get(0)).getSignificance() <= Significance.LOW;
    }

    public boolean isDidit() {
        return this.phraseInfo.getTokens().size() == 1 && PartOfSpeech.CD.name().equals(((TokenInfo)this.phraseInfo.getTokens().get(0)).getPOSlocal());
    }

    public boolean isKeyword() {
        return false;
    }

    public List<SemanticAnnotation> getSemanticAnnotations() {
        return this.semanticAnnotations;
    }

    public void setSemanticAnnotations(List<SemanticAnnotation> semanticAnnotations) {
        this.semanticAnnotations = semanticAnnotations;
    }

    public boolean hasSemanticAnnotation() {
        return null == this.semanticAnnotations;
    }

    public boolean requireSemanticAnalysis() {
        return !this.isStopWord() && !this.isDidit();
    }

    public boolean hasSingleSemanticAnnotation() {
        return this.hasSemanticAnnotation() && this.semanticAnnotations.size() == 1;
    }

    public TextInfo toTextInfo(String language) {
        TextInfo ti = new TextInfo();
        ti.setLanguage(language);
        this.getSemanticAnnotations().forEach(sa -> ti.getPhrases().add(sa.getPhraseInfo()));
        return ti;
    }
}

