/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.model.common.util.ModuleUtil;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.model.common.util.SmartsModuleBuilder;
import com.ibm.smarts.model.overwrites.OverwriteMap;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.DatasetType;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.ObjectFactory;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.smartsmodule.builder.internal.CommonUtil;
import com.ibm.smarts.smartsmodule.builder.internal.IndexedSmartsModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeltaProcessor.class);
    private final ObjectFactory mFactory = new ObjectFactory();
    private SmartsModuleBuilder builder = null;
    private boolean acceptOverwrites;

    public DeltaProcessor(boolean acceptOverwrites) {
        this.acceptOverwrites = acceptOverwrites;
    }

    public void execute(SmartsModule smartsModule, Module module, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        if (smartsModule == null || module == null || deltaAnalysisMap == null) {
            throw new InternalException("No null parameters allowed in DeltaProcessor", new Object[0]);
        }
        if (smartsModule.getDatasets().isEmpty()) {
            this.setSmartsModuleProperties(smartsModule, module);
        }
        IndexedSmartsModule indexedSM = new IndexedSmartsModule(smartsModule);
        this.builder = new SmartsModuleBuilder(true);
        Map columnKeyTypeMap = this.builder.getColumnKeyTypeMap(module);
        this.handleDeletedDatasets(module, smartsModule);
        for (QuerySubject qs : module.getQuerySubject()) {
            DatasetInfo ds = indexedSM.getDatasetInfo(qs.getIdentifier());
            if (ds == null) {
                this.handleDeltaInserts(module, qs, columnKeyTypeMap, deltaAnalysisMap, smartsModule);
                continue;
            }
            this.updateDatasetProperties(qs, ds, deltaAnalysisMap);
            this.updateColumnInfoProperties(qs, ds, deltaAnalysisMap, indexedSM, columnKeyTypeMap);
        }
        this.handleGlobalCalcs(module, indexedSM, deltaAnalysisMap);
        this.handleNamedSets(module, indexedSM, deltaAnalysisMap);
    }

    private void handleDeletedDatasets(Module module, SmartsModule sm) {
        Set querySubjects = module.getQuerySubject().stream().map(ObjectType::getIdentifier).collect(Collectors.toSet());
        Iterator iterator = sm.getDatasets().iterator();
        while (iterator.hasNext()) {
            DatasetInfo datset = (DatasetInfo)iterator.next();
            if (datset.getType().equals((Object)DatasetType.CALCULATIONS)) {
                if (!module.getCalculation().isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (datset.getType().equals((Object)DatasetType.NAMED_SETS)) {
                if (!module.getNamedSet().isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (querySubjects.contains(datset.getId())) continue;
            iterator.remove();
        }
    }

    private void handleGlobalCalcs(Module module, IndexedSmartsModule indexedSM, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        if (module.getCalculation() != null) {
            DatasetInfo targetDS = this.globalDataset(indexedSM.getSmartsModule(), DatasetType.CALCULATIONS);
            if (targetDS == null) {
                this.addGlobalCalcs(module.getCalculation(), indexedSM.getSmartsModule(), deltaAnalysisMap);
            } else {
                this.updateGlobalCalcProperties(module.getCalculation(), targetDS, deltaAnalysisMap, indexedSM);
            }
        }
    }

    private void handleNamedSets(Module module, IndexedSmartsModule indexedSM, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        if (module.basicGetNamedSet() != null) {
            DatasetInfo targetDS = this.globalDataset(indexedSM.getSmartsModule(), DatasetType.NAMED_SETS);
            if (targetDS == null) {
                this.addNamedSets(module.getNamedSet(), indexedSM.getSmartsModule(), deltaAnalysisMap);
            } else {
                this.updateNamedSetProperties(module.getNamedSet(), targetDS, deltaAnalysisMap, indexedSM);
            }
        }
    }

    private DatasetInfo globalDataset(SmartsModule module, DatasetType type) {
        return module.getDatasets().stream().filter(d -> d.getType() == type).findFirst().orElse(null);
    }

    private void addGlobalCalcs(List<Calculation> globalCalcs, SmartsModule smartsModule, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        DatasetInfo globalCalcsDataset = this.builder.createDatasetInfo("_global_calculations", DatasetType.CALCULATIONS, globalCalcs);
        if (!globalCalcsDataset.getItem().isEmpty()) {
            this.replaceOrAddDataset(smartsModule, globalCalcsDataset, DatasetType.CALCULATIONS);
            this.addDeltaAnalysisNewDataset(deltaAnalysisMap, globalCalcsDataset.getId());
        }
    }

    private void addNamedSets(List<NamedSet> namedSets, SmartsModule smartsModule, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        DatasetInfo namedSetDataset = this.builder.createDatasetInfo("_global_namedSets", DatasetType.NAMED_SETS, namedSets);
        if (!namedSetDataset.getItem().isEmpty()) {
            this.replaceOrAddDataset(smartsModule, namedSetDataset, DatasetType.NAMED_SETS);
            this.addDeltaAnalysisNewDataset(deltaAnalysisMap, namedSetDataset.getId());
        }
    }

    private void replaceOrAddDataset(SmartsModule module, DatasetInfo dataset, DatasetType type) {
        List datasets = module.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            if (((DatasetInfo)datasets.get(i)).getType() != type) continue;
            datasets.set(i, dataset);
            return;
        }
        datasets.add(dataset);
    }

    private void updateDatasetProperties(QuerySubject sourceQS, DatasetInfo targetDS, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        if (!DeltaProcessor.equals(targetDS.getName(), sourceQS.getLabel())) {
            targetDS.setName(sourceQS.getLabel());
            this.addPropertyChange(deltaAnalysisMap, targetDS.getId(), DeltaAnalysisScope.ModifiableProperty.NAME, DeltaAnalysisScope.ScopedTask.TOKENIZE, Optional.empty());
        }
        if (!DeltaProcessor.equals(targetDS.getDescription(), sourceQS.getDescription())) {
            targetDS.setDescription(sourceQS.getDescription());
            this.addPropertyChange(deltaAnalysisMap, targetDS.getId(), DeltaAnalysisScope.ModifiableProperty.DESCRIPTION, DeltaAnalysisScope.ScopedTask.TOKENIZE, Optional.empty());
        }
        if (!DeltaProcessor.equals(targetDS.getComment(), sourceQS.getComment())) {
            targetDS.setComment(sourceQS.getComment());
            this.addPropertyChange(deltaAnalysisMap, targetDS.getId(), DeltaAnalysisScope.ModifiableProperty.COMMENT, DeltaAnalysisScope.ScopedTask.TOKENIZE, Optional.empty());
        }
    }

    private void updateColumnInfoProperties(QuerySubject sourceQS, DatasetInfo targetDS, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, IndexedSmartsModule indexedSM, Map<String, Map<String, String>> columnKeyTypeMap) {
        Map<String, ColumnInfo> columnInfos = indexedSM.getColumnInfos(targetDS.getId());
        Map<String, ItemType.Folder> folders = indexedSM.getFolders(targetDS.getId());
        HashSet<String> queryItemsEncountered = new HashSet<String>();
        this.processItems(queryItemsEncountered, sourceQS.getIdentifier(), targetDS, columnInfos, folders, sourceQS.getItem(), null, columnKeyTypeMap, deltaAnalysisMap);
        this.handleDeletedColumns(queryItemsEncountered, columnInfos, targetDS);
    }

    private void processItems(Set<String> queryItemsEncountered, String tableId, DatasetInfo targetDS, Map<String, ColumnInfo> columnInfos, Map<String, ItemType.Folder> folders, List<com.ibm.bi.platform.moser.common.generated.metadata.ItemType> items, BaseItemObject parent, Map<String, Map<String, String>> columnKeyTypeMap, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        for (com.ibm.bi.platform.moser.common.generated.metadata.ItemType item : items) {
            QueryItem queryItem = item.getQueryItem();
            if (queryItem != null && QuerySubjectUtil.isVisible((BaseQueryItemType)queryItem, (boolean)false)) {
                String expression = queryItem.basicGetIdForExpression();
                queryItemsEncountered.add(expression);
                if (this.compareColumnItemWithQueryItem(queryItemsEncountered, tableId, targetDS, columnInfos, folders, (BaseQueryItemType)queryItem, parent, columnKeyTypeMap, deltaAnalysisMap)) continue;
                this.processItems(queryItemsEncountered, tableId, targetDS, columnInfos, folders, queryItem.getItem(), (BaseItemObject)columnInfos.get(expression), columnKeyTypeMap, deltaAnalysisMap);
                continue;
            }
            ItemType.Folder f = item.getFolder();
            if (f == null || f.isHidden() != null && f.isHidden().booleanValue() || this.compareFolderItemWithFolder(queryItemsEncountered, tableId, targetDS, columnInfos, folders, f, parent, columnKeyTypeMap, deltaAnalysisMap)) continue;
            String expression = f.basicGetIdForExpression();
            this.processItems(queryItemsEncountered, tableId, targetDS, columnInfos, folders, f.getItem(), (BaseItemObject)folders.get(expression), columnKeyTypeMap, deltaAnalysisMap);
        }
    }

    private void updateGlobalCalcProperties(List<Calculation> calculations, DatasetInfo targetDS, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, IndexedSmartsModule indexedSM) {
        Map<String, ColumnInfo> columnInfos = indexedSM.getColumnInfos(targetDS.getId());
        Map<String, ItemType.Folder> folders = indexedSM.getFolders(targetDS.getId());
        HashSet<String> queryItemsEncountered = new HashSet<String>();
        for (Calculation calc : calculations) {
            queryItemsEncountered.add(calc.basicGetIdForExpression());
            this.compareColumnItemWithQueryItem(queryItemsEncountered, targetDS.getId(), targetDS, columnInfos, folders, (BaseQueryItemType)calc, null, Collections.emptyMap(), deltaAnalysisMap);
        }
        this.handleDeletedColumns(queryItemsEncountered, columnInfos, targetDS);
    }

    private void handleDeletedColumns(Set<String> queryItemsEncountered, Map<String, ColumnInfo> columnInfos, DatasetInfo targetDS) {
        for (Map.Entry<String, ColumnInfo> mapEntry : columnInfos.entrySet()) {
            if (queryItemsEncountered.contains(mapEntry.getKey())) continue;
            this.deleteColumn(targetDS, mapEntry.getValue());
        }
    }

    private void updateNamedSetProperties(List<NamedSet> namedSets, DatasetInfo targetDS, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, IndexedSmartsModule indexedSM) {
        Map<String, ColumnInfo> columnInfos = indexedSM.getColumnInfos(targetDS.getId());
        Map<String, ItemType.Folder> folders = indexedSM.getFolders(targetDS.getId());
        HashSet<String> queryItemsEncountered = new HashSet<String>();
        for (NamedSet namedSet : namedSets) {
            queryItemsEncountered.add(namedSet.basicGetIdForExpression());
            this.compareColumnItemWithQueryItem(queryItemsEncountered, targetDS.getId(), targetDS, columnInfos, folders, (BaseQueryItemType)namedSet, null, Collections.emptyMap(), deltaAnalysisMap);
        }
        this.handleDeletedColumns(queryItemsEncountered, columnInfos, targetDS);
    }

    private boolean compareColumnItemWithQueryItem(Set<String> queryItemsEncountered, String tableId, DatasetInfo targetDS, Map<String, ColumnInfo> columnInfos, Map<String, ItemType.Folder> folders, BaseQueryItemType queryItem, BaseItemObject parent, Map<String, Map<String, String>> columnKeyTypeMap, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        boolean isNew = false;
        ColumnInfo ci = columnInfos.get(queryItem.getIdForExpression());
        if (ci == null) {
            isNew = true;
            ColumnInfo col = this.builder.createColumnInfo(queryItem, columnKeyTypeMap.get(tableId));
            this.handleOverwrites(col);
            ItemType item2 = this.mFactory.createItemType();
            item2.setColumn(col);
            List items = targetDS.getItem();
            if (parent != null) {
                items = parent.getItem();
            }
            items.add(item2);
            String expression = col.getIdForExpression();
            columnInfos.put(expression, col);
            this.addDeltaAnalysisNewColumn(deltaAnalysisMap, tableId, expression);
            this.addToColumnInfosAndFolders(deltaAnalysisMap, tableId, targetDS, queryItemsEncountered, columnInfos, folders, col.getItem());
        } else {
            Optional<ItemType> col;
            if (parent != null && !(col = parent.getItem().stream().filter(item -> item.getColumn() != null && item.getColumn().getIdForExpression().equals(ci.getIdForExpression())).findFirst()).isPresent()) {
                this.deleteColumn(targetDS, ci);
                ItemType item3 = new ItemType();
                item3.setColumn(ci);
                parent.getItem().add(item3);
            }
            this.applyColumnModifications(queryItem, tableId, ci, deltaAnalysisMap);
        }
        return isNew;
    }

    private void addToColumnInfosAndFolders(Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, String tableId, DatasetInfo targetDS, Set<String> queryItemsEncountered, Map<String, ColumnInfo> columnInfos, Map<String, ItemType.Folder> folders, List<ItemType> items) {
        items.forEach(item -> {
            ColumnInfo c = item.getColumn();
            if (c != null) {
                String expression = c.getIdForExpression();
                if (columnInfos.containsKey(expression)) {
                    this.deleteColumn(targetDS, c);
                } else {
                    columnInfos.put(expression, c);
                    this.addDeltaAnalysisNewColumn(deltaAnalysisMap, tableId, expression);
                }
                queryItemsEncountered.add(expression);
                this.addToColumnInfosAndFolders(deltaAnalysisMap, tableId, targetDS, queryItemsEncountered, columnInfos, folders, c.getItem());
            } else {
                ItemType.Folder f = item.getFolder();
                if (f != null) {
                    folders.put(f.getIdForExpression(), f);
                    this.addToColumnInfosAndFolders(deltaAnalysisMap, tableId, targetDS, queryItemsEncountered, columnInfos, folders, f.getItem());
                }
            }
        });
    }

    private boolean compareFolderItemWithFolder(Set<String> queryItemsEncountered, String tableId, DatasetInfo targetDS, Map<String, ColumnInfo> columnInfos, Map<String, ItemType.Folder> folders, ItemType.Folder folder, BaseItemObject parent, Map<String, Map<String, String>> columnKeyTypeMap, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        boolean isNew = false;
        ItemType.Folder f = folders.get(folder.getIdForExpression());
        if (f == null) {
            isNew = true;
            f = this.builder.createFolder(folder, columnKeyTypeMap.get(tableId));
            this.handleOverwrites(f.getItem());
            ItemType item = this.mFactory.createItemType();
            item.setFolder(f);
            List items = targetDS.getItem();
            if (parent != null) {
                items = parent.getItem();
            }
            items.add(item);
            folders.put(f.getIdForExpression(), f);
            this.addToColumnInfosAndFolders(deltaAnalysisMap, tableId, targetDS, queryItemsEncountered, columnInfos, folders, f.getItem());
        }
        return isNew;
    }

    private void deleteColumn(DatasetInfo targetDS, ColumnInfo ciToDelete) {
        SmartsModuleUtil.deleteItemWithColumn((List)targetDS.getItem(), (String)ciToDelete.getIdForExpression());
        DeltaProcessor.cleanupBivariates(targetDS, ciToDelete.getId());
        CommonUtil.cleanupLogicalGroups(targetDS, ciToDelete.getId());
    }

    public static void cleanupBivariates(DatasetInfo ds, String columnId) {
        List bivariates = ds.getBivariateStatistics();
        ListIterator itr = bivariates.listIterator();
        while (itr.hasNext()) {
            BivariateStatistics bi = (BivariateStatistics)itr.next();
            if (!bi.getColumn1().equals(columnId) && !bi.getColumn2().equals(columnId)) continue;
            itr.remove();
        }
    }

    private void applyColumnModifications(BaseQueryItemType qi, String dsId, ColumnInfo colInfo, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap) {
        com.ibm.smarts.schema.UsageType usageType;
        if (!DeltaProcessor.equals(colInfo.getName(), qi.getLabel())) {
            colInfo.setName(qi.getLabel());
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.NAME, DeltaAnalysisScope.ScopedTask.TOKENIZE, Optional.of(colInfo.getIdForExpression()));
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.NAME, DeltaAnalysisScope.ScopedTask.CLASSIFY, Optional.of(colInfo.getIdForExpression()));
        }
        if (!DeltaProcessor.equals(colInfo.getDescription(), qi.getDescription())) {
            colInfo.setDescription(qi.getDescription());
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.DESCRIPTION, DeltaAnalysisScope.ScopedTask.TOKENIZE, Optional.of(colInfo.getIdForExpression()));
        }
        if (!DeltaProcessor.equals(colInfo.getComment(), qi.getComment())) {
            colInfo.setComment(qi.getComment());
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.COMMENT, DeltaAnalysisScope.ScopedTask.TOKENIZE, Optional.of(colInfo.getIdForExpression()));
        }
        AggregationType desiredAggregation = SmartsModuleBuilder.reMapAggregation((RegularAggregateType)qi.getRegularAggregate());
        if (colInfo.getDefaultAggregation() != null && !colInfo.getDefaultAggregation().equals((Object)desiredAggregation) || colInfo.getDefaultAggregation() == null && desiredAggregation != null) {
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.AGGREGATION, DeltaAnalysisScope.ScopedTask.CLASSIFY, Optional.of(colInfo.getIdForExpression()));
            this.handleOverwrite(colInfo, DeltaAnalysisScope.ModifiableProperty.AGGREGATION, desiredAggregation);
        }
        if ((usageType = SmartsModuleBuilder.reMapUsageType((UsageType)qi.getUsage())) != null && (colInfo.getUsage() != null && !colInfo.getUsage().equals((Object)usageType) || colInfo.getUsage() == null)) {
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.USAGE, DeltaAnalysisScope.ScopedTask.CLASSIFY, Optional.of(colInfo.getIdForExpression()));
            this.handleOverwrite(colInfo, DeltaAnalysisScope.ModifiableProperty.USAGE, usageType);
            if (desiredAggregation != null) {
                colInfo.getSemanticInfo().setDefaultAggregation(desiredAggregation);
                this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.AGGREGATION, DeltaAnalysisScope.ScopedTask.CLASSIFY, Optional.of(colInfo.getIdForExpression()));
                this.handleOverwrite(colInfo, DeltaAnalysisScope.ModifiableProperty.AGGREGATION, desiredAggregation);
            }
        }
        ArrayList<ConceptInfo> taxonomyConcepts = new ArrayList<ConceptInfo>();
        SmartsModuleBuilder.reMapTaxonomyToConcepts((List)qi.getTaxonomy(), taxonomyConcepts);
        if (this.conceptChangeDetected(taxonomyConcepts, colInfo.getSemanticInfo().getConcepts())) {
            this.addPropertyChange(deltaAnalysisMap, dsId, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ScopedTask.CLASSIFY, Optional.of(colInfo.getIdForExpression()));
            this.handleOverwrite(colInfo, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, taxonomyConcepts);
        }
    }

    private void handleOverwrite(ColumnInfo colInfo, DeltaAnalysisScope.ModifiableProperty property, Object newValue) {
        if (newValue == null) {
            return;
        }
        if (colInfo.getSemanticInfo().getOverwrites() == null) {
            colInfo.getSemanticInfo().setOverwrites(new OverwriteMap());
        }
        try {
            if (property.equals((Object)DeltaAnalysisScope.ModifiableProperty.USAGE)) {
                colInfo.getSemanticInfo().setUsage((com.ibm.smarts.schema.UsageType)newValue);
                String usageJSON = JAXBHelper.marshalToJSON((Object)newValue);
                colInfo.getSemanticInfo().getOverwrites().put((Object)DeltaAnalysisScope.ModifiableProperty.USAGE.name(), (Object)usageJSON);
            } else if (property.equals((Object)DeltaAnalysisScope.ModifiableProperty.AGGREGATION)) {
                colInfo.getSemanticInfo().setDefaultAggregation((AggregationType)newValue);
                String aggrJSON = JAXBHelper.marshalToJSON((Object)newValue);
                colInfo.getSemanticInfo().getOverwrites().put((Object)DeltaAnalysisScope.ModifiableProperty.AGGREGATION.name(), (Object)aggrJSON);
            } else if (property.equals((Object)DeltaAnalysisScope.ModifiableProperty.CONCEPTS)) {
                List concepts = (List)newValue;
                String conceptsJSON = JAXBHelper.marshalToJSON(concepts.stream().filter(c -> !c.getConceptID().equals("owl:Nothing")).collect(Collectors.toList()));
                colInfo.getSemanticInfo().getOverwrites().put((Object)DeltaAnalysisScope.ModifiableProperty.CONCEPTS.name(), (Object)conceptsJSON);
            }
        }
        catch (IOException e) {
            LOGGER.error("handle overwrite IOException", (Throwable)e);
        }
    }

    private boolean conceptChangeDetected(List<ConceptInfo> newList, List<ConceptInfo> oldList) {
        if (newList.isEmpty()) {
            return false;
        }
        for (ConceptInfo newConcept : newList) {
            for (ConceptInfo oldConcept : oldList) {
                if (!ConceptsUtil.getConceptName((ConceptInfo)oldConcept).equals(ConceptsUtil.getConceptName((ConceptInfo)newConcept))) continue;
                return false;
            }
        }
        return true;
    }

    private DeltaAnalysisScope addPropertyChange(Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, String dsId, DeltaAnalysisScope.ModifiableProperty property, DeltaAnalysisScope.ScopedTask task, Optional<String> columnIdForExpression) {
        DeltaAnalysisScope scope = null;
        if (!deltaAnalysisMap.containsKey(dsId)) {
            scope = new DeltaAnalysisScope(dsId, task, columnIdForExpression, property);
            ArrayList<DeltaAnalysisScope> scopeList = new ArrayList<DeltaAnalysisScope>();
            scopeList.add(scope);
            deltaAnalysisMap.put(dsId, scopeList);
        } else {
            List<DeltaAnalysisScope> scopeList = deltaAnalysisMap.get(dsId);
            for (DeltaAnalysisScope existingScope : scopeList) {
                if (!existingScope.getScopedTask().equals((Object)task)) continue;
                scope = existingScope;
                scope.addPropertyChange(task, columnIdForExpression, property);
                break;
            }
            if (scope == null) {
                scope = new DeltaAnalysisScope(dsId, task, columnIdForExpression, property);
                scopeList.add(scope);
            }
        }
        return scope;
    }

    private static boolean equals(String oldName, String newName) {
        return oldName != null && oldName.equals(newName) || StringUtils.isBlank((CharSequence)newName) && StringUtils.isBlank((CharSequence)oldName);
    }

    private void handleDeltaInserts(Module module, QuerySubject qs, Map<String, Map<String, String>> columnKeyTypeMap, Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, SmartsModule smartsModule) {
        if (SmartsModuleBuilder.isQuerySubjectVisible((Module)module, (QuerySubject)qs)) {
            Map keyTypeMap = columnKeyTypeMap.getOrDefault(qs.getIdentifier(), Collections.emptyMap());
            DatasetInfo ds = this.builder.createDatasetInfo(qs, keyTypeMap);
            smartsModule.getDatasets().add(ds);
            this.handleOverwrites(ds);
            this.addDeltaAnalysisNewDataset(deltaAnalysisMap, qs.getIdentifier());
        }
    }

    private void handleOverwrites(DatasetInfo ds) {
        List colInfos = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
        for (ColumnInfo ci : colInfos) {
            this.handleOverwrites(ci);
            ci.getSemanticInfo().getConcepts().removeIf(c -> c.getConceptID().equals("owl:Nothing"));
        }
    }

    private void handleOverwrites(ColumnInfo ci) {
        if (this.acceptOverwrites) {
            this.handleOverwrite(ci, DeltaAnalysisScope.ModifiableProperty.AGGREGATION, ci.getDefaultAggregation());
            this.handleOverwrite(ci, DeltaAnalysisScope.ModifiableProperty.USAGE, ci.getUsage());
            if (!ci.getSemanticInfo().getConcepts().isEmpty()) {
                this.handleOverwrite(ci, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, ci.getSemanticInfo().getConcepts());
            }
            this.handleOverwrites(ci.getItem());
        }
    }

    private void handleOverwrites(List<ItemType> items) {
        if (this.acceptOverwrites && items != null) {
            items.stream().forEach(item -> {
                if (item.getColumn() != null) {
                    this.handleOverwrites(item.getColumn());
                } else if (item.getFolder() != null) {
                    this.handleOverwrites(item.getFolder().getItem());
                }
            });
        }
    }

    private void addDeltaAnalysisNewDataset(Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, String datasetId) {
        DeltaAnalysisScope deltaAnalysisScope = new DeltaAnalysisScope(datasetId, DeltaAnalysisScope.ScopedTask.ALL, DeltaAnalysisScope.ScopedColumns.ALL);
        ArrayList<DeltaAnalysisScope> newList = new ArrayList<DeltaAnalysisScope>();
        newList.add(deltaAnalysisScope);
        deltaAnalysisMap.put(datasetId, newList);
    }

    private void addDeltaAnalysisNewColumn(Map<String, List<DeltaAnalysisScope>> deltaAnalysisMap, String datasetId, String columnIdForExpression) {
        for (DeltaAnalysisScope.ScopedTask taskEnum : DeltaAnalysisScope.ScopedTask.values()) {
            if (taskEnum.equals((Object)DeltaAnalysisScope.ScopedTask.ALL)) continue;
            this.addPropertyChange(deltaAnalysisMap, datasetId, DeltaAnalysisScope.ModifiableProperty.ALL, taskEnum, Optional.of(columnIdForExpression));
        }
    }

    private void setSmartsModuleProperties(SmartsModule smartsModule, Module module) {
        if (ModuleUtil.isFMPackageModule((Module)module)) {
            smartsModule.setType("package");
        }
        if (module.getLabel() != null) {
            smartsModule.setName(module.getLabel());
        }
        if (module.getDescription() != null) {
            smartsModule.setDescription(module.getDescription());
        }
        if (module.getComment() != null) {
            smartsModule.setComment(module.getComment());
        }
    }
}

