/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.core.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.store.api.config.TypeName;
import com.ibm.smarts.store.core.types.Type;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Registry {
    private static final String PACKAGE = "/com/ibm/smarts/store/";
    private final Map<TypeName, Type> repoTypesMap;
    public static final String TYPES_FILE = "/com/ibm/smarts/store/types.txt";

    public Registry(String typesPath) {
        block33: {
            this.repoTypesMap = new HashMap<TypeName, Type>();
            if (typesPath == null) {
                throw new InternalException("No Types File Path is provided to Registry", new Object[0]);
            }
            InputStream is = this.getClass().getResourceAsStream(typesPath);
            if (is == null) {
                throw new InternalException("Type File  with Path " + typesPath + " could not be found.", new Object[0]);
            }
            String line = "";
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                Throwable throwable = null;
                while (true) {
                    try {
                        line = reader.readLine();
                        if (line == null) break block33;
                        String filepath = PACKAGE + line;
                        try {
                            InputStream typeIs = this.getClass().getResourceAsStream(filepath);
                            Throwable throwable2 = null;
                            try {
                                if (typeIs == null) {
                                    throw new InternalException("File " + filepath + "  is not found", new Object[0]);
                                }
                                try {
                                    JsonNode jn = JsonParserHelper.getJsonFromStream((InputStream)typeIs);
                                    Type t = (Type)JsonParserHelper.parseJson((JsonNode)jn, Type.class);
                                    this.repoTypesMap.put(t.getTypeName(), t);
                                }
                                catch (IOException e) {
                                    throw new InternalException((Throwable)e, "Failed to read from file " + filepath, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new InternalException((Throwable)e, "Json exception in file " + filepath, new Object[0]);
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (typeIs == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        typeIs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                typeIs.close();
                            }
                        }
                        catch (IOException e) {
                            throw new InternalException((Throwable)e, "Failed to read from file " + filepath, new Object[0]);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e, "Failed to read from file " + typesPath, new Object[0]);
            }
        }
    }

    public Type getRepo(TypeName typeName) {
        Type t = this.repoTypesMap.get(typeName);
        if (t == null) {
            throw new InternalException("Type {0} does not exist in registry", new Object[]{typeName});
        }
        return t;
    }

    public Map<TypeName, Type> getRepos() {
        return this.repoTypesMap;
    }
}

