/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq.progress;

import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.message.SmartsModuleStatus;
import com.ibm.smarts.common.mq.progress.SmartsModuleCancel;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgress;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressConsumer;
import com.ibm.smarts.common.mq.progress.SmartsModuleTaskProgress;
import com.ibm.smarts.core.mq.ExchangeId;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.mq.QueueId;
import com.ibm.smarts.core.mq.TypedMessageConsumer;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.AnalysisTask;
import com.ibm.smarts.schema.AnalysisTaskStatus;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.AnalysisPhaseUtil;
import com.ibm.smarts.store.api.exceptions.RecordNotFoundException;
import com.ibm.smarts.store.api.multirec.MRTRecord;
import com.ibm.smarts.store.api.multirec.MultiRecordTrigger;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IMRTStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleProgressUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleProgressUtil.class);
    public static final String PROGRESS_TYPE = "smarts.module.task.progress";

    private SmartsModuleProgressUtil() {
    }

    public static SmartsModule stripPrivateSmartsModuleFields(SmartsModule smarts) {
        smarts.getDatasets().stream().forEach(dataset -> dataset.getBivariateStatistics().clear());
        return smarts;
    }

    public static void trackProgressForTask(IStoreProvider storeProvider, MessageQueueingSystem messageSystem, SmartsModuleTask task) {
        SmartsModuleProgressConsumer progressConsumer = new SmartsModuleProgressConsumer(storeProvider, task);
        for (String e : task.outgoingExchanges) {
            messageSystem.setConsumer(new QueueId(new ExchangeId(e), task.id), (TypedMessageConsumer)progressConsumer);
        }
    }

    public static boolean deleteProgress(IStoreProvider storeProvider, String smartsModuleId) {
        String progressRecordId = MultiRecordTrigger.getRecordId((String)PROGRESS_TYPE, (String)smartsModuleId);
        IMRTStore store = storeProvider.getMRTStore();
        StoreStatus status = store.deleteById(progressRecordId);
        if (!status.isSuccess()) {
            LOGGER.error("failed to delete progress record for \"" + smartsModuleId + "\"");
        }
        return status.isSuccess();
    }

    public static SmartsModuleProgress applyProgress(IStoreProvider storeProvider, SmartsModuleTask task, String smartsModuleId, String progressKey, SmartsModuleStatus status) {
        List<SmartsModuleTask> tasks = SmartsModuleMessageGroup.getSmartsModuleTasks(storeProvider);
        SmartsModuleProgress result = new SmartsModuleProgress(tasks);
        String progressRecordId = MultiRecordTrigger.getRecordId((String)PROGRESS_TYPE, (String)smartsModuleId);
        IMRTStore store = storeProvider.getMRTStore();
        store.apply(progressRecordId, progressRecord -> {
            result.progress.clear();
            SmartsModuleTaskProgress taskProgress = null;
            Iterator recordIterator = progressRecord.records.iterator();
            while (recordIterator.hasNext()) {
                String json = (String)recordIterator.next();
                SmartsModuleTaskProgress rec = (SmartsModuleTaskProgress)JsonParserHelper.fromJson((String)json, SmartsModuleTaskProgress.class);
                if (rec.taskId.equals(task.id)) {
                    taskProgress = rec;
                    recordIterator.remove();
                }
                result.add(rec);
            }
            if (taskProgress != null) {
                taskProgress.addStatus(progressKey, status);
                String progressJson = JsonParserHelper.toJson((Object)taskProgress);
                progressRecord.records.add(progressJson);
                LOGGER.trace("updating progress record for (" + smartsModuleId + ", " + progressKey + ") to " + progressJson);
            } else {
                LOGGER.error("missing progress record for \"" + smartsModuleId + "\"," + task.id + ": ");
            }
            return progressRecord;
        });
        return result;
    }

    public static boolean createProgressRecord(IStoreProvider storeProvider, String smartsModuleId, int datasetCount) {
        String progressRecordId = MultiRecordTrigger.getRecordId((String)PROGRESS_TYPE, (String)smartsModuleId);
        IMRTStore store = storeProvider.getMRTStore();
        MRTRecord progressRecord = new MRTRecord();
        progressRecord.type = PROGRESS_TYPE;
        progressRecord.key = smartsModuleId;
        progressRecord.records = new ArrayList();
        List<SmartsModuleTask> tasks = SmartsModuleMessageGroup.getSmartsModuleTasks(storeProvider);
        tasks.forEach(task -> {
            SmartsModuleTaskProgress taskProgress = new SmartsModuleTaskProgress(task.id, smartsModuleId, task.getOutgoingMessageCount(datasetCount));
            String progressJson = JsonParserHelper.toJson((Object)taskProgress);
            progressRecord.records.add(progressJson);
            LOGGER.trace("creating progress record for \"" + smartsModuleId + "\"," + task.id + ": " + progressJson);
        });
        StoreStatus status = store.store(IRecord.create((Object)progressRecord, (String)progressRecordId));
        if (!status.isSuccess()) {
            LOGGER.error("failed to store progress records for \"" + smartsModuleId + "\"");
        }
        return status.isSuccess();
    }

    public static SmartsModuleProgress getSmartsModuleProgress(IStoreProvider storeProvider, String smartsModuleId) {
        String progressRecordId = MultiRecordTrigger.getRecordId((String)PROGRESS_TYPE, (String)smartsModuleId);
        IMRTStore store = storeProvider.getMRTStore();
        MRTRecord record = store.getById(progressRecordId);
        if (record != null) {
            List<SmartsModuleTask> tasks = SmartsModuleMessageGroup.getSmartsModuleTasks(storeProvider).stream().filter(task -> !task.hiddenTask).collect(Collectors.toList());
            SmartsModuleProgress result = new SmartsModuleProgress(tasks);
            Set taskIds = tasks.stream().map(task -> task.id).collect(Collectors.toSet());
            record.records.forEach(json -> {
                SmartsModuleTaskProgress rec = (SmartsModuleTaskProgress)JsonParserHelper.fromJson((String)json, SmartsModuleTaskProgress.class);
                if (taskIds.contains(rec.taskId)) {
                    result.add(rec);
                }
            });
            return result;
        }
        return null;
    }

    public static AnalysisPhase getInitialAnalysisPhaseProgress(IStoreProvider storeProvider, String smartsModuleId, String datasetId, AnalysisStateType analysisState) {
        SmartsModuleProgress progress = SmartsModuleProgressUtil.getSmartsModuleProgress(storeProvider, smartsModuleId);
        AnalysisPhase phase = AnalysisPhaseUtil.createInitialAnalysisPhase((AnalysisStateType)analysisState);
        if (progress != null) {
            List completedTasks = phase.getCompletedTasks();
            Map<SmartsModuleTask, SmartsModuleStatus> taskProgress = progress.completedTasks(datasetId);
            taskProgress.entrySet().forEach(e -> {
                List<String> dataSourceExceptions;
                List<String> warnings;
                SmartsModuleTask task = (SmartsModuleTask)e.getKey();
                SmartsModuleStatus status = (SmartsModuleStatus)e.getValue();
                AnalysisTask analysisTask = new AnalysisTask();
                analysisTask.setId(task.id);
                analysisTask.setName(task.name);
                analysisTask.setDescription(task.description);
                AnalysisTaskStatus analysisStatus = new AnalysisTaskStatus();
                analysisStatus.setSuccess(status.isSuccess());
                List<String> errors = status.getErrors();
                if (errors != null && !errors.isEmpty()) {
                    analysisStatus.getErrors().addAll(errors);
                }
                if ((warnings = status.getWarnings()) != null && !warnings.isEmpty()) {
                    analysisStatus.getWarnings().addAll(warnings);
                }
                if ((dataSourceExceptions = status.getDataSourceException()) != null && !dataSourceExceptions.isEmpty()) {
                    analysisStatus.getDataSourceException().addAll(dataSourceExceptions);
                }
                analysisTask.setStatus(analysisStatus);
                completedTasks.add(analysisTask);
            });
        }
        return phase;
    }

    public static SmartsModuleProgress getSmartsModuleProgress(IStoreProvider storeProvider, SmartsModule smartsModule) {
        List datasets = smartsModule.getDatasets();
        HashMap<String, SmartsModuleTaskProgress> taskProgressMap = new HashMap<String, SmartsModuleTaskProgress>();
        HashMap<String, SmartsModuleTask> tasksMap = new HashMap<String, SmartsModuleTask>();
        List<SmartsModuleTask> tasks = SmartsModuleMessageGroup.getSmartsModuleTasks(storeProvider);
        ArrayList<SmartsModuleTask> trackedTasks = new ArrayList<SmartsModuleTask>();
        for (SmartsModuleTask task : tasks) {
            tasksMap.put(task.id, task);
        }
        for (int i = 0; i < datasets.size(); ++i) {
            DatasetInfo dataset = (DatasetInfo)datasets.get(i);
            List phases = dataset.getAnalysisPhases();
            if (phases.isEmpty()) continue;
            AnalysisPhase phase = (AnalysisPhase)phases.get(0);
            for (AnalysisTask analysisTask : phase.getCompletedTasks()) {
                SmartsModuleTask moduleTask = (SmartsModuleTask)tasksMap.get(analysisTask.getId());
                if (moduleTask == null) continue;
                SmartsModuleStatus status = !analysisTask.getStatus().isSuccess() ? new SmartsModuleStatus(false, analysisTask.getStatus().getErrors(), analysisTask.getStatus().getWarnings(), analysisTask.getStatus().getDataSourceException()) : new SmartsModuleStatus(true, null, null, null);
                SmartsModuleTaskProgress taskProgress = (SmartsModuleTaskProgress)taskProgressMap.get(moduleTask.id);
                if (taskProgress == null) {
                    taskProgress = new SmartsModuleTaskProgress(moduleTask.id, smartsModule.getId(), moduleTask.getOutgoingMessageCount(datasets.size()));
                    taskProgressMap.put(moduleTask.id, taskProgress);
                    trackedTasks.add(moduleTask);
                }
                taskProgress.addStatus(dataset.getId(), status);
            }
        }
        SmartsModuleProgress progress = new SmartsModuleProgress(trackedTasks, taskProgressMap);
        if (progress.isDone()) {
            progress.setCompletedSmartsModule(SmartsModuleProgressUtil.stripPrivateSmartsModuleFields(smartsModule));
        }
        return progress;
    }

    public static SmartsModuleCancel cancelSmartsModule(RequestContext context, IStoreProvider storeProvider, String smartsModuleId, CancelOption cancelOption) {
        boolean success = false;
        String errorMessage = "";
        try {
            IInMemoryModuleStore store = storeProvider.getModuleStore(context);
            StoreStatus status = store.apply(smartsModuleId, smartsModule -> {
                smartsModule.setCancelOption(cancelOption);
                return smartsModule;
            });
            success = status.isSuccess();
            if (!success) {
                errorMessage = "Error cancelling smarts module " + smartsModuleId;
            }
        }
        catch (RecordNotFoundException e) {
            LOGGER.error("Error cancelling smarts module " + smartsModuleId, (Throwable)e);
            return null;
        }
        return new SmartsModuleCancel(success, errorMessage);
    }

    public static CancelOption getCancelOption(RequestContext context, IStoreProvider storeProvider, String smartsModuleId) {
        IInMemoryModuleStore store = storeProvider.getModuleStore(context);
        SmartsModule smartsModule = store.getById(smartsModuleId);
        if (smartsModule != null) {
            return smartsModule.getCancelOption();
        }
        return null;
    }

    public static boolean isCancelled(RequestContext context, IStoreProvider storeProvider, String smartsModuleId) {
        CancelOption cancelOption = SmartsModuleProgressUtil.getCancelOption(context, storeProvider, smartsModuleId);
        return cancelOption != null;
    }
}

