/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class EquivalentConceptClassification
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    EquivalentConceptClassification(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().stream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return false;
        }
        return inScopeColPkgs.stream().filter(columnPkg -> {
            if (this.shouldExecute((SmartsModuleClassificationPkg.ColumnClassificationPkg)columnPkg, dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME, DeltaAnalysisScope.ModifiableProperty.CONCEPTS)) {
                return !this.shouldExecute((SmartsModuleClassificationPkg.ColumnClassificationPkg)columnPkg, dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.CONCEPTS) || columnPkg.getColumnInfo().getSemanticInfo() == null || !columnPkg.getColumnInfo().getSemanticInfo().getConcepts().stream().anyMatch(this::isApplicatoinConcept);
            }
            return false;
        }).map(this::classify).reduce(Boolean::logicalOr).orElse(false);
    }

    private boolean classify(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        return this.mOntologies.stream().map(o -> this.classifyEquivalentConcept(columnPkg, (Ontology<OWLOntology>)o)).reduce(Boolean::logicalOr).orElse(false);
    }

    private boolean classifyEquivalentConcept(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        int candidatesCount = columnPkg.getCandidates().size();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        columnPkg.getConcepts().stream().forEach(c -> {
            OWLClass cClass = factory.getOWLClass(IRI.create((String)c.getConceptID()));
            reasoner.getEquivalentClasses((OWLClassExpression)cClass).getEntitiesMinusTop().stream().filter(e -> !e.getIRI().getNamespace().startsWith("http://www.ibm.com/ontologies/waca/application")).forEach(e -> {
                float relevanceScore;
                float dataHintScore = c.getConfidence();
                float f = relevanceScore = this.isIndexable(e.getIRI(), (OWLOntology)ontology.getValue()) ? 1.0f : 0.01f;
                if (e.getIRI().equals((Object)MEASURE_ROOT_IRI)) {
                    relevanceScore = 0.0115f;
                }
                if (!columnPkg.getConcepts().stream().anyMatch(ec -> IRI.create((String)ec.getConceptID()).equals((Object)e.getIRI()))) {
                    SmartsModuleClassificationPkg.Candidate cn = new SmartsModuleClassificationPkg.Candidate(e.getIRI());
                    int pos = columnPkg.getCandidates().indexOf(cn);
                    if (pos < 0) {
                        columnPkg.addCandidate(Optional.of(cn.setRelevance(relevanceScore).setDataHintRelevance(dataHintScore).setDataValueRelevance(1.0f)));
                    } else {
                        cn = columnPkg.getCandidates().get(pos);
                        cn.setRelevance(Math.min(1.0f, relevanceScore + cn.getRelevance())).setDataHintRelevance(dataHintScore).setDataValueRelevance(1.0f);
                    }
                }
            });
        });
        return candidatesCount != columnPkg.getCandidates().size();
    }

    private boolean isIndexable(IRI c, OWLOntology ontology) {
        boolean notIndexable;
        IRI entity = c;
        Set axiom = ontology.getAxioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)entity, Imports.INCLUDED, Navigation.IN_SUB_POSITION);
        boolean bl = notIndexable = !axiom.isEmpty() && axiom.stream().anyMatch(a -> a.getProperty().getIRI().equals((Object)NOT_INDEXABLE_CLASS_PROPERTY_IRI) && ((OWLLiteral)a.getValue().asLiteral().get()).isBoolean() && ((OWLLiteral)a.getValue().asLiteral().get()).parseBoolean());
        if (notIndexable) {
            LOGGER.debug("{} is not indexable", (Object)c.getShortForm());
        }
        return !notIndexable;
    }
}

