/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.text;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.SemanticAnalysisHelper;
import com.ibm.smarts.ontology.classifier.text.AbstractTextSemanticAnalysisStep;
import com.ibm.smarts.ontology.classifier.text.TextSemanticAnalysisPkg;
import com.ibm.smarts.schema.ClueHit;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class CandidateElection
extends AbstractTextSemanticAnalysisStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    protected CandidateElection(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(TextSemanticAnalysisPkg txtPkg) {
        if (!this.isExecParallel()) {
            ArrayList collectDurations = new ArrayList();
            txtPkg.getPhraseSemanticAnalysisPkgs().forEach(pPkg -> this.collectCandidates((TextSemanticAnalysisPkg.PhraseSemanticAnalysisPkg)pPkg, collectDurations));
            LOGGER.warn(String.format("==> Search clues sequentially in CandidateElection step took [%s]ms", collectDurations.stream().mapToLong(Duration::toMillis).sum()));
        } else {
            this.executeAsync(txtPkg);
        }
    }

    public void executeAsync(TextSemanticAnalysisPkg txtPkg) {
        Instant before = Instant.now();
        ArrayList fs = new ArrayList();
        txtPkg.getPhraseSemanticAnalysisPkgs().forEach(pPkg -> fs.add(this.collectCandidatesAsync((TextSemanticAnalysisPkg.PhraseSemanticAnalysisPkg)pPkg)));
        LOGGER.warn("Waiting for " + fs.size() + " futures to complete...");
        CompletableFuture.allOf(fs.toArray(new CompletableFuture[fs.size()])).join();
        LOGGER.warn(String.format("==> Search clues async in CandidateElection step took [%s]ms ", Duration.between(before, Instant.now()).toMillis()));
    }

    private void collectCandidates(TextSemanticAnalysisPkg.PhraseSemanticAnalysisPkg phrasePkg, List<Duration> collectDurations) {
        HashMap<String, List<ClueHit>> groups = new HashMap<String, List<ClueHit>>();
        groups.putAll(SemanticAnalysisHelper.collectHits(phrasePkg.getPhrase(), collectDurations, this.currentReqCtx, this.mOntologies));
        this.collectCandidates(phrasePkg, groups);
    }

    private CompletableFuture<Void> collectCandidatesAsync(TextSemanticAnalysisPkg.PhraseSemanticAnalysisPkg phrasePkg) {
        CompletableFuture<Map<String, List<ClueHit>>> hitsF = SemanticAnalysisHelper.collectHitsAsync(phrasePkg.getPhrase(), this.currentReqCtx, this.mOntologies);
        CompletionStage ret = hitsF.thenAccept(hits -> {
            HashMap<String, List<ClueHit>> groups = new HashMap<String, List<ClueHit>>();
            groups.putAll((Map<String, List<ClueHit>>)hits);
            this.collectCandidates(phrasePkg, groups);
        });
        return ret;
    }

    private void collectCandidates(TextSemanticAnalysisPkg.PhraseSemanticAnalysisPkg phrasePkg, Map<String, List<ClueHit>> groups) {
        Collection<ClueHit> results = SemanticAnalysisHelper.computeCandidates(phrasePkg.getPhrase(), groups);
        Optional.ofNullable(results).ifPresent(rs -> rs.stream().sorted(Comparator.comparing(ClueHit::getScore).reversed()).forEach(r -> {
            TextSemanticAnalysisPkg.PhraseSemanticAnalysisPkg phraseSemanticAnalysisPkg = phrasePkg;
            synchronized (phraseSemanticAnalysisPkg) {
                phrasePkg.addCandidate(Optional.of(this.createCandidate((ClueHit)r)));
            }
        }));
        LOGGER.warn("Elected candidates for [{}]", (Object)phrasePkg.getPhrase().getText());
        phrasePkg.getCandidates().forEach(c -> LOGGER.warn(c.toString()));
    }

    private TextSemanticAnalysisPkg.Candidate createCandidate(ClueHit r) {
        float normalizedScore = (float)(1.0 - Math.exp(-r.getScore()));
        TextSemanticAnalysisPkg.Candidate c = new TextSemanticAnalysisPkg.Candidate(IRI.create((String)r.getClue().getConceptID().trim())).setRelevance(r.getScore()).setConfidence(normalizedScore);
        LOGGER.debug("Original = {}, Normalized = {}", (Object)Float.valueOf(r.getScore()), (Object)Float.valueOf(c.getConfidence()));
        return c;
    }
}

