/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.ontologymanager;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.internal.ontology.api.DomainOWLOntologyManager;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.exceptions.InitializationException;
import com.ibm.smarts.ontology.ontologymanager.AbstractOWLOntologyManagerImpl;
import com.ibm.smarts.ontology.reasoner.ReasonerWrapper;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.ontology.util.LRUCache;
import com.ibm.smarts.schema.ConceptInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.StringUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainOWLOntologyManagerImpl
extends AbstractOWLOntologyManagerImpl
implements DomainOWLOntologyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainOWLOntologyManagerImpl.class);
    private static final String SPLITTER = "#";
    private static final String COL_NAME = "columnName";
    private static final String CONCEPT_IRI = "conceptIRI";
    private Map<String, Map<String, ConceptInfo>> domainDefaultConceptMappings = new HashMap<String, Map<String, ConceptInfo>>();
    private LRUCache<String, ReasonerWrapper> reasonerPool = new LRUCache(10);

    DomainOWLOntologyManagerImpl(Properties config, ClueManager<OWLOntology> clueManager) {
        super(config, clueManager);
        this.getOntologies().stream().forEach(o -> this.getReasoner((Ontology<OWLOntology>)o));
    }

    @Override
    String getResourceLoc(Properties config) {
        return config.getProperty("smarts.ontology.resource.settings");
    }

    public void addOntology(String tenant, Ontology<?> ontology) {
    }

    public void updateOntology(String tenant, String ontologyID, Ontology<?> ontology) {
    }

    public void removeOntology(String tenant, String ontologyID) {
    }

    public boolean validateOntology(Ontology<?> ontology) {
        return false;
    }

    public OWLReasoner getReasoner(Ontology<OWLOntology> ontology) {
        ReasonerWrapper reasonerWrapper = this.reasonerPool.get(ontology.getOntologyID());
        if (reasonerWrapper == null) {
            reasonerWrapper = new ReasonerWrapper((OWLOntology)ontology.getValue());
            this.reasonerPool.put(ontology.getOntologyID(), reasonerWrapper);
        }
        return reasonerWrapper.getReasoner();
    }

    @Override
    public void distroy() {
        super.distroy();
        this.domainDefaultConceptMappings.values().forEach(m -> m.clear());
        this.domainDefaultConceptMappings.clear();
        this.reasonerPool.getAll().forEach(wrapper -> {
            try {
                wrapper.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.reasonerPool.clear();
        LOGGER.info("destroyed DomainOWLOntologyManagerImpl");
    }

    @Override
    protected void additionalInit(OWLOntology ontology, RequestContext requestContext) throws Exception {
        Object isServiceOwner = requestContext.getAttribute("serviceInitOwner");
        if (isServiceOwner == null || isServiceOwner.equals(Boolean.TRUE)) {
            if (null == this.clueManager) {
                throw new InitializationException("Clue Manager is not initialized");
            }
            this.clueManager.updateClues((Object)ontology, requestContext);
        }
        this.initializeDefaultConceptMapping(ontology);
    }

    private void initializeDefaultConceptMapping(OWLOntology ontology) {
        String mappingPath = this.config.getProperty(((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString());
        if (mappingPath != null) {
            try (InputStream in = KnowledgeDiscoveryHelper.loadFromClasspath(mappingPath);){
                if (in == null) {
                    throw new InitializationException(mappingPath + " not found on the classpath");
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                    List mappings = CSVFormat.TDF.withHeader(new String[]{COL_NAME, CONCEPT_IRI}).withSkipHeaderRecord().parse((Reader)br).getRecords();
                    LOGGER.info("There are [{}] of default concepts in Ontology {}", (Object)mappings.size(), (Object)ontology.getOntologyID().toString());
                    HashMap conceptMappings = new HashMap(mappings.size());
                    mappings.forEach(record -> {
                        String colName = StringUtils.trim((String)record.get(COL_NAME));
                        String conceptID = StringUtils.trim((String)record.get(CONCEPT_IRI));
                        String[] cInfo = conceptID.split(SPLITTER);
                        if (StringUtils.isNotBlank((CharSequence)colName) && cInfo.length == 2) {
                            ConceptInfo concept = new ConceptInfo();
                            concept.setConfidence(1.0f);
                            concept.setConceptID(conceptID);
                            conceptMappings.put(colName, concept);
                        }
                    });
                    if (!conceptMappings.isEmpty()) {
                        this.domainDefaultConceptMappings.put(((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString(), conceptMappings);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to close input stream for " + mappingPath, (Throwable)e);
            }
        }
    }

    public Map<String, Map<String, ConceptInfo>> getDomainDefaultConceptMappings() {
        return Collections.unmodifiableMap(this.domainDefaultConceptMappings);
    }
}

