/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.reasoner.DataEvaluator;
import com.ibm.smarts.ontology.reasoner.DataHintEvaluator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorExAdapter;

public class ClassesEvaluator
extends OWLClassExpressionVisitorExAdapter<Float> {
    private final Map<OWLClass, Optional<Float>> m_processedClasses = new ConcurrentHashMap<OWLClass, Optional<Float>>();
    private Map<IRI, List<OWLLiteral>> m_propertyValues = null;
    private List<String> m_samples = null;
    private OWLOntology m_ontology = null;
    private RequestContext m_currentReqCtx = null;

    public ClassesEvaluator(OWLOntology ontology, Map<IRI, List<OWLLiteral>> propertyValues, List<String> samples, RequestContext currentReqCtx) {
        super((Object)Float.valueOf(0.0f));
        this.m_propertyValues = propertyValues;
        this.m_samples = samples;
        this.m_ontology = ontology;
        this.m_currentReqCtx = currentReqCtx;
    }

    private float evaluateOWLQuantifiedObjectRestriction(OWLQuantifiedObjectRestriction ce, long threshold) {
        IRI property = ce.getProperty().asOWLObjectProperty().getIRI();
        if (property.equals((Object)DataHintEvaluator.HAS_DATA_INSTANCE_IRI)) {
            return DataHintEvaluator.evaluateHasDataInstance(ce, threshold, this.m_samples, this.m_ontology, this.m_currentReqCtx);
        }
        return 0.0f;
    }

    public Float visit(OWLClass ce) {
        Optional<Float> result = this.m_processedClasses.getOrDefault(ce, Optional.empty());
        if (!result.isPresent()) {
            Set axioms = this.m_ontology.getAxioms(ce, Imports.INCLUDED);
            Set exprSet = axioms.stream().filter(a -> a instanceof OWLEquivalentClassesAxiom).map(e -> (OWLClassExpression)((OWLEquivalentClassesAxiom)e).getClassExpressionsAsList().get(1)).collect(Collectors.toSet());
            result = Optional.of(exprSet.stream().map(e -> (Float)e.accept((OWLClassExpressionVisitorEx)this)).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())));
            this.m_processedClasses.put(ce, result);
        }
        return result.orElse(Float.valueOf(0.0f));
    }

    public Float visit(OWLObjectIntersectionOf ce) {
        return ce.getOperandsAsList().stream().map(p -> (Float)p.accept((OWLClassExpressionVisitorEx)this)).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue()));
    }

    public Float visit(OWLObjectUnionOf ce) {
        return ce.getOperandsAsList().stream().map(p -> (Float)p.accept((OWLClassExpressionVisitorEx)this)).reduce(Float.valueOf(0.0f), (a, b) -> Float.valueOf(Float.compare(a.floatValue() + b.floatValue(), 1.0f) > 0 ? 1.0f : a.floatValue() + b.floatValue()));
    }

    public Float visit(OWLObjectComplementOf ce) {
        return Float.valueOf(((Float)ce.getOperand().accept((OWLClassExpressionVisitorEx)this)).floatValue() > 0.0f ? 0.0f : 1.0f);
    }

    public Float visit(OWLObjectSomeValuesFrom ce) {
        return Float.valueOf(this.evaluateOWLQuantifiedObjectRestriction((OWLQuantifiedObjectRestriction)ce, 1L));
    }

    public Float visit(OWLObjectAllValuesFrom ce) {
        return Float.valueOf(this.evaluateOWLQuantifiedObjectRestriction((OWLQuantifiedObjectRestriction)ce, this.m_samples.size()));
    }

    public Float visit(OWLObjectMinCardinality ce) {
        return Float.valueOf(this.evaluateOWLQuantifiedObjectRestriction((OWLQuantifiedObjectRestriction)ce, ce.getCardinality()));
    }

    public Float visit(OWLDataSomeValuesFrom ce) {
        List<OWLLiteral> values = this.m_propertyValues.get(ce.getProperty().asOWLDataProperty().getIRI());
        if (values == null) {
            return Float.valueOf(0.0f);
        }
        DataEvaluator dataRangeEvaluator = new DataEvaluator(values, ce.getProperty().asOWLDataProperty().getIRI());
        return (Float)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)dataRangeEvaluator);
    }

    public Float visit(OWLDataHasValue ce) {
        List<OWLLiteral> values = this.m_propertyValues.get(ce.getProperty().asOWLDataProperty().getIRI());
        if (values == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(values.stream().anyMatch(v -> ((OWLLiteral)ce.getFiller()).equals(v)) ? 1.0f : 0.0f);
    }

    public Float visit(OWLDataAllValuesFrom ce) {
        List<OWLLiteral> values = this.m_propertyValues.get(ce.getProperty().asOWLDataProperty().getIRI());
        if (values == null) {
            return Float.valueOf(0.0f);
        }
        DataEvaluator dataRangeEvaluator = new DataEvaluator(values, ce.getProperty().asOWLDataProperty().getIRI());
        return (Float)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)dataRangeEvaluator);
    }
}

