/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import java.util.List;
import java.util.function.Function;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLDataVisitorExAdapter;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class DataEvaluator
extends OWLDataVisitorExAdapter<Float> {
    private List<OWLLiteral> m_values = null;
    private IRI m_property = null;

    public DataEvaluator(List<OWLLiteral> values, IRI property) {
        super((Object)Float.valueOf(0.0f));
        this.m_values = values;
        this.m_property = property;
    }

    public Float visit(OWLDatatype node) {
        return Float.valueOf(this.m_values.stream().anyMatch(v -> v.getDatatype().getBuiltInDatatype().equals((Object)node.getBuiltInDatatype()) && node.getBuiltInDatatype().getPattern().matcher(v.getLiteral()).matches()) ? 1.0f : 0.0f);
    }

    public Float visit(OWLDataIntersectionOf node) {
        return node.getOperands().stream().map(p -> (Float)p.accept((OWLDataVisitorEx)this)).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue()));
    }

    public Float visit(OWLDataUnionOf node) {
        return node.getOperands().stream().map(p -> (Float)p.accept((OWLDataVisitorEx)this)).reduce(Float.valueOf(0.0f), (a, b) -> Float.valueOf(a.floatValue() + b.floatValue() > 1.0f ? 1.0f : a.floatValue() + b.floatValue()));
    }

    public Float visit(OWLDatatypeRestriction node) {
        return node.getFacetRestrictions().stream().map(f -> (Float)f.accept((OWLDataVisitorEx)this)).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue()));
    }

    public Float visit(OWLLiteral node) {
        return Float.valueOf(this.m_values.equals(node) ? 1.0f : 0.0f);
    }

    public Float visit(OWLFacetRestriction node) {
        return this.m_values.stream().map(v -> Float.valueOf(this.evaluate(node, (OWLLiteral)v))).reduce(Float.valueOf(0.0f), (a, b) -> Float.valueOf(a.floatValue() + b.floatValue()));
    }

    private float evaluate(OWLFacetRestriction node, OWLLiteral value) {
        OWLLiteral facetValue = node.getFacetValue();
        if (value.getDatatype().getBuiltInDatatype().getPattern().matcher(value.getLiteral()).matches()) {
            if (facetValue.getDatatype().isInteger() && value.getDatatype().isInteger()) {
                return this.evaluate(node, value, OWLLiteral::parseInteger);
            }
            if (facetValue.getDatatype().isDouble() && value.getDatatype().isDouble()) {
                return this.evaluate(node, value, OWLLiteral::parseDouble);
            }
            if (facetValue.getDatatype().isFloat() && value.getDatatype().isFloat()) {
                return this.evaluate(node, value, OWLLiteral::parseFloat);
            }
            if (facetValue.getDatatype().isRDFPlainLiteral()) {
                return this.evaluate(node, value, OWLLiteral::getLiteral);
            }
        }
        return 0.0f;
    }

    private <T> float evaluate(OWLFacetRestriction node, OWLLiteral value, Function<OWLLiteral, Comparable<T>> parseFunc) {
        OWLFacet facet = node.getFacet();
        OWLLiteral facetValue = node.getFacetValue();
        switch (facet) {
            case MIN_INCLUSIVE: {
                return parseFunc.apply(value).compareTo(parseFunc.apply(facetValue)) >= 0 ? 1.0f : 0.0f;
            }
            case MIN_EXCLUSIVE: {
                return parseFunc.apply(value).compareTo(parseFunc.apply(facetValue)) > 0 ? 1.0f : 0.0f;
            }
            case MAX_INCLUSIVE: {
                return parseFunc.apply(value).compareTo(parseFunc.apply(facetValue)) <= 0 ? this.computeCoverage(value, facetValue, parseFunc) : 0.0f;
            }
            case MAX_EXCLUSIVE: {
                return parseFunc.apply(value).compareTo(parseFunc.apply(facetValue)) < 0 ? this.computeCoverage(value, facetValue, parseFunc) : 0.0f;
            }
            case PATTERN: {
                String pattern = facetValue.getLiteral();
                boolean result = value.getLiteral().matches(pattern);
                return result ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    private <T> float computeCoverage(OWLLiteral value, OWLLiteral facetValue, Function<OWLLiteral, Comparable<T>> parseFunc) {
        if (value.getDatatype().isInteger() && this.m_property.equals((Object)AbstractSmartsModuleClassificationStep.DATA_MAX_PROPERTY_IRI)) {
            float v = ((Number)((Object)parseFunc.apply(value))).floatValue();
            v = Float.compare(v, 0.001f) < 0 ? 0.1f : v;
            Float a = Float.valueOf(v / ((Number)((Object)parseFunc.apply(facetValue))).floatValue());
            return Float.compare(((Number)a).floatValue(), 1.0f) >= 0 ? 0.99f : ((Number)a).floatValue();
        }
        return 1.0f;
    }
}

