/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import com.ibm.smarts.internal.ontology.api.InfluencerReasoner;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.exceptions.InvalidOntologyDomainException;
import com.ibm.smarts.ontology.ontologymanager.OntologyResourceManager;
import com.ibm.smarts.ontology.reasoner.ExistentialRestrictionCollector;
import com.ibm.smarts.ontology.reasoner.RelationshipNavigator;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.util.OntologyCommon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class InfluencerReasonerImpl
extends OntologyCommon
implements InfluencerReasoner {
    private OntologyResourceManager resourceManager;
    private static final IRI HAS_INFLUENCER_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasInfluencer");
    private static final IRI HAS_ATTRIBUTE_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasAttribute");

    public InfluencerReasonerImpl(OntologyResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public List<Pair<String, Float>> inferInfluencers(ConceptInfo conceptInfo) {
        return this.inferInfluencers(conceptInfo, this.resolveDomain(conceptInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<String, Float>> inferInfluencers(ConceptInfo conceptInfo, Ontology<OWLOntology> ontology) {
        OWLDataFactory df = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = this.resourceManager.getDomainOntologyManager().getReasoner(ontology);
        OWLClass target = df.getOWLClass(IRI.create((String)conceptInfo.getConceptID()));
        RelationshipNavigator rw = new RelationshipNavigator((OWLOntology)ontology.getValue(), reasoner, HAS_INFLUENCER_PROPERTY_IRI);
        try {
            target.accept((OWLClassExpressionVisitor)rw);
            if (rw.getDistanceMap().isEmpty()) {
                ArrayList<Pair<String, Float>> arrayList = new ArrayList<Pair<String, Float>>(0);
                return arrayList;
            }
            ArrayList candidates = new ArrayList(rw.getDistanceMap().size());
            rw.getDistanceMap().entrySet().forEach(entry -> candidates.add(new ImmutablePair(entry.getKey(), entry.getValue())));
            List<Pair<String, Float>> list = candidates.stream().map(c -> this.pair((Pair<OWLClassExpression, Integer>)c)).filter(pair -> !conceptInfo.getConceptID().equals(pair.getKey())).collect(Collectors.toList());
            return list;
        }
        finally {
            rw.dispose();
        }
    }

    private Pair<String, Float> pair(Pair<OWLClassExpression, Integer> pair) {
        return new ImmutablePair((Object)((OWLClassExpression)pair.getLeft()).asOWLClass().getIRI().toString(), (Object)Float.valueOf((float)(1.0 - 0.05 * (double)((Integer)pair.getRight() - 1))));
    }

    private Ontology<OWLOntology> resolveDomain(ConceptInfo conceptInfo) {
        List domains = this.resourceManager.getDomainOntologyManager().getOntologies();
        Optional<Ontology> onto = domains.stream().filter(o -> o.getOntologyID().equals(ConceptsUtil.getOntologyId((ConceptInfo)conceptInfo))).findFirst();
        return onto.orElseThrow(() -> new InvalidOntologyDomainException(String.format("Invalid ontology domain: [%s]", ConceptsUtil.getOntologyId((ConceptInfo)conceptInfo))));
    }

    private Set<OWLClass> getChildrenLevelsConcepts(OWLClass cClass, OWLOntology ontology) {
        ExistentialRestrictionCollector restrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology), Collections.singletonList(HAS_ATTRIBUTE_PROPERTY_IRI), false);
        cClass.accept((OWLClassExpressionVisitor)restrictionVisitor);
        return restrictionVisitor.getRestrictedProperties().stream().filter(c -> c instanceof OWLClass).map(c -> (OWLClass)c).collect(Collectors.toSet());
    }
}

