/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.service;

import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.ActionRecommender;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.internal.ontology.api.DomainOWLOntologyManager;
import com.ibm.smarts.internal.ontology.api.InfluencerReasoner;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.ontology.classifier.ConceptClassifierFactory;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleConceptClassifier;
import com.ibm.smarts.ontology.classifier.text.TextConceptClassifier;
import com.ibm.smarts.ontology.cluemanager.ClueManagerImpl;
import com.ibm.smarts.ontology.ontologymanager.OntologyResourceManager;
import com.ibm.smarts.ontology.reasoner.InfluencerReasonerImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Properties;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeDiscoveryService
implements IComponentLifecycle,
IManagedLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnowledgeDiscoveryService.class);
    private final LifecycleManager clh;
    private OntologyResourceManager resourceManager;
    private ActionRecommender actionRecommender;
    private final SmartNLP smartNLP;
    private final ClueManager<OWLOntology> clueManager;
    private final InfluencerReasoner influcencerReasoner;
    private final Properties config;

    public KnowledgeDiscoveryService(Properties props, SmartNLP nlp, IStoreProvider storeProvider) {
        this.config = props;
        this.smartNLP = nlp;
        this.clueManager = new ClueManagerImpl(storeProvider, nlp, props);
        this.resourceManager = new OntologyResourceManager(this.config, this.clueManager);
        this.influcencerReasoner = new InfluencerReasonerImpl(this.resourceManager);
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[]{(IComponentLifecycleOperations)nlp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[KnowledgeDiscoveryService @" + Integer.toHexString(this.hashCode()));
        sb.append(" config=" + this.config);
        sb.append(" nlp=" + this.smartNLP);
        sb.append("]");
        return sb.toString();
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        this.resourceManager.initialize(rc);
        LOGGER.info("<TCL> KnowledgeDiscoveryService initialized");
    }

    public void shutDown(RequestContext rc) {
        if (this.resourceManager != null) {
            this.resourceManager.destroy();
            this.resourceManager = null;
        }
        LOGGER.info("<TCL> KnowledgeDiscoveryService destroyed");
    }

    public SmartNLP getSmartNLP() {
        return this.smartNLP;
    }

    public ActionRecommender getActionRecommender() {
        return this.actionRecommender;
    }

    public ClueManager<OWLOntology> getClueManager() {
        return this.clueManager;
    }

    public DomainOWLOntologyManager getDomainOntologyManager() {
        return this.resourceManager.getDomainOntologyManager();
    }

    public OntologyResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public SmartsModuleConceptClassifier getSmartsModuleConceptClassifier() {
        return (SmartsModuleConceptClassifier)((Object)ConceptClassifierFactory.make(this.resourceManager, this.clueManager, SmartsModuleConceptClassifier.class));
    }

    public TextConceptClassifier getTextConceptClassifier() {
        return (TextConceptClassifier)((Object)ConceptClassifierFactory.make(this.resourceManager, this.clueManager, TextConceptClassifier.class));
    }

    public Properties getKnowledgeDiscoveryConfig() {
        return this.config;
    }

    public InfluencerReasoner getInfluencerReasoner() {
        return this.influcencerReasoner;
    }
}

