import re, os

def main():
  # get all the string files
  for file in os.listdir("."):
    if re.search('_[a-zA-Z]{2}\.properties', file):
      with open(file, 'r') as s:
        output = ''
        for line in s:
          # replace leading space with &nbsp;
          line = line.replace('=&nbsp;', '=\ ')
          # replace trailing space with &nbsp;
          line = line.replace('&nbsp;\n', ' \n')
          # replace {1,NAME} with {NAME} 
          found = re.search('\{(\d\,)', line)
          while found:
            line = line[:found.start()+1] + line[found.end():]
            found = re.search('\{(\d\,)', line)
          output = output + line
      with open(file, 'w') as t:
          t.write(output)
  
main()

# IDS_TREND_CATEGORY_LABEL={1,VALUE} by {2,CATEGORY}
# IDS_MATRIX_COLUMN=&nbsp;repeated by {1,MATRIX_COLUMN}
# IDS_MAP_REGION_TITLE=regions of {1,REGION_LOCATION}&nbsp;
