/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.shared;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.shared.UserPreferences;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIResource {
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    protected HttpServletResponse httpServletResponse;
    @Context
    protected UriInfo uriInfo;
    private String prefsCookie = null;
    public static final String INTERNAL_REQUEST_ATTRIBUTE = "Internal";
    protected static Logger logger = LoggerFactory.getLogger(BIResource.class);

    public BIResource() {
    }

    public BIResource(HttpServletRequest httpServletRequest, UriInfo uriInfo) {
        this.httpServletRequest = httpServletRequest;
        this.uriInfo = uriInfo;
    }

    protected UserPreferences getUserPreferences() {
        if (this.prefsCookie == null) {
            this.prefsCookie = this.getPrefCookie();
        }
        return this.prefsCookie == null ? new UserPreferences() : new UserPreferences(this.prefsCookie);
    }

    protected void setUPCookie(UserPreferences userPreferences) throws IOException {
        Cookie up = new Cookie("up", userPreferences.cookieValue());
        up.setHttpOnly(true);
        this.httpServletResponse.addCookie(up);
    }

    protected void updateUPCookie(JsonObject modified) throws IOException {
        UserPreferences userPreferences = this.getUserPreferences();
        for (Map.Entry entry : modified.entrySet()) {
            userPreferences.put((String)entry.getKey(), entry.getValue());
        }
        this.setUPCookie(userPreferences);
    }

    private String getPrefCookie() {
        Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("up")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected void clearPrefCookie() {
        Cookie up = new Cookie("up", "");
        up.setHttpOnly(true);
        up.setMaxAge(0);
        this.httpServletResponse.addCookie(up);
    }

    protected String buildBaseURL() {
        String original = (String)this.getAttribute("X-Original-URI");
        if (original != null) {
            return original;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.httpServletRequest.getContextPath());
        buf.append(this.httpServletRequest.getServletPath());
        return buf.toString();
    }

    protected Object getAttribute(String name) {
        return this.httpServletRequest.getAttribute(name);
    }

    protected String getLocationPath(String path) {
        return this.buildBaseURL() + path;
    }

    protected ExecutorService getExecService() {
        return (ExecutorService)this.httpServletRequest.getServletContext().getAttribute("execSvc");
    }

    protected boolean isInternalRequest() {
        String attr = (String)this.httpServletRequest.getAttribute(INTERNAL_REQUEST_ATTRIBUTE);
        return attr != null && attr.equals("true");
    }

    protected String getProductLanguage() {
        String lang = this.getUserPreferences().getProductLocale();
        if (lang != null) {
            return lang;
        }
        return this.httpServletRequest.getLocale().getLanguage();
    }
}

