/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.config;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.synchromesh.core.logging.LogAdapter;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineConfig;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SynchromeshConfig {
    private static final Set<Integer> DEFAULT_ERROR_RESPONSE_CODES;
    private static final String BASE_URL = "SynchromeshService.baseURL";
    private static final String CONTENT_TRUSTED_REQUESTS = "SynchromeshService.contentTrustedRequests";
    private static final String DEFAULT_SYNC_ENGINE_CONFIG = "SynchromeshService.defaultSyncEngineConfig";
    private static final String ERROR_RESPONSE_CODES = "SynchromeshService.errorResponseCodes";
    private static final String RETRY_WITHOUT_ETAG = "SynchromeshService.retryWithoutETag";
    private static final String SEARCH_TRUSTED_REQUESTS = "SynchromeshService.searchTrustedRequests";

    private SynchromeshConfig() {
    }

    private static boolean getBooleanSetting(String id, boolean defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getBooleanProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LogAdapter.error(SynchromeshConfig.class, "Failed to get boolean value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static double getDoubleSetting(String id, double defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getDoubleProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LogAdapter.error(SynchromeshConfig.class, "Failed to get double value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static int getIntSetting(String id, int defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getIntProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LogAdapter.error(SynchromeshConfig.class, "Failed to get integer value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static long getLongSetting(String id, long defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getLongProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LogAdapter.error(SynchromeshConfig.class, "Failed to get long value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static String getStringSetting(String id, String defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getStringProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LogAdapter.error(SynchromeshConfig.class, "Failed to get String value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static JSONObject getJSONObjectSetting(String id, String defaultValue) {
        String value = SynchromeshConfig.getStringSetting(id, defaultValue);
        if (value != null) {
            try {
                return JSONObject.parse((String)value);
            }
            catch (IOException e) {
                LogAdapter.error(SynchromeshConfig.class, "Failed to parse JSONObject value for config key: " + id, e);
            }
        }
        return new JSONObject();
    }

    private static JSONArray getJSONArraySetting(String id, String defaultValue) {
        String value = SynchromeshConfig.getStringSetting(id, defaultValue);
        if (value != null) {
            try {
                return JSONArray.parse((String)value);
            }
            catch (IOException e) {
                LogAdapter.error(SynchromeshConfig.class, "Failed to parse JSONArray value for config key: " + id, e);
            }
        }
        return new JSONArray();
    }

    public static String getBaseURL() {
        return SynchromeshConfig.getStringSetting(BASE_URL, "/bi/v1");
    }

    public static SyncEngineConfig getDefaultSyncEngineConfig() {
        String config = SynchromeshConfig.getStringSetting(DEFAULT_SYNC_ENGINE_CONFIG, null);
        return StringUtils.isEmpty((CharSequence)config) ? new SyncEngineConfig(SyncEngineConfig.DEFAULT) : new SyncEngineConfig(config);
    }

    public static boolean getContentTrustedRequests() {
        return SynchromeshConfig.getBooleanSetting(CONTENT_TRUSTED_REQUESTS, false);
    }

    public static Set<Integer> getErrorResponseCodes() {
        JSONArray values = SynchromeshConfig.getJSONArraySetting(ERROR_RESPONSE_CODES, null);
        if (values.isEmpty()) {
            return DEFAULT_ERROR_RESPONSE_CODES;
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (Object o : values) {
            Long value = (Long)o;
            result.add(value.intValue());
        }
        return result;
    }

    public static boolean getRetryWithoutEtag() {
        return SynchromeshConfig.getBooleanSetting(RETRY_WITHOUT_ETAG, false);
    }

    public static boolean getSearchTrustedRequests() {
        return SynchromeshConfig.getBooleanSetting(SEARCH_TRUSTED_REQUESTS, false);
    }

    static {
        int[] values;
        DEFAULT_ERROR_RESPONSE_CODES = new HashSet<Integer>();
        for (int v : values = new int[]{300, 301, 302, 303, 305, 306, 307, 400, 401, 402, 403, 405, 406, 407, 408, 410, 411, 412, 413, 414, 415, 416, 417, 441}) {
            DEFAULT_ERROR_RESPONSE_CODES.add(v);
        }
    }
}

