/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAdapter {
    private LogAdapter() {
    }

    private static Logger getLoggerInst(Object obj) {
        if (obj instanceof Class) {
            return LoggerFactory.getLogger((Class)((Class)obj));
        }
        return LoggerFactory.getLogger(obj.getClass());
    }

    private static boolean isErrorEnabled(Object obj) {
        return LogAdapter.getLoggerInst(obj).isErrorEnabled();
    }

    private static boolean isWarnEnabled(Object obj) {
        return LogAdapter.getLoggerInst(obj).isWarnEnabled();
    }

    public static boolean isInfoEnabled(Object obj) {
        return LogAdapter.getLoggerInst(obj).isInfoEnabled();
    }

    public static boolean isDebugEnabled(Object obj) {
        return LogAdapter.getLoggerInst(obj).isDebugEnabled();
    }

    public static boolean isTraceEnabled(Object obj) {
        return LogAdapter.getLoggerInst(obj).isTraceEnabled();
    }

    public static void error(Object obj, String msg) {
        if (LogAdapter.isErrorEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).error(msg);
        }
    }

    public static void error(Object obj, String format, Object ... argArray) {
        if (LogAdapter.isErrorEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).error(format, argArray);
        }
    }

    public static void error(Object obj, String msg, Throwable t) {
        if (LogAdapter.isErrorEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).error(msg, t);
        }
    }

    public static void warn(Object obj, String msg) {
        if (LogAdapter.isWarnEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).warn(msg);
        }
    }

    public static void warn(Object obj, String format, Object ... argArray) {
        if (LogAdapter.isWarnEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).warn(format, argArray);
        }
    }

    public static void warn(Object obj, String msg, Throwable t) {
        if (LogAdapter.isWarnEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).warn(msg, t);
        }
    }

    public static void trace(Object obj, String msg) {
        if (LogAdapter.isTraceEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).trace(msg);
        }
    }

    public static void trace(Object obj, String format, Object ... argArray) {
        if (LogAdapter.isTraceEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).trace(format, argArray);
        }
    }

    public static void trace(Object obj, String msg, Throwable t) {
        if (LogAdapter.isTraceEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).trace(msg, t);
        }
    }

    public static void debug(Object obj, String msg) {
        if (LogAdapter.isDebugEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).debug(msg);
        }
    }

    public static void debug(Object obj, String format, Object ... argArray) {
        if (LogAdapter.isDebugEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).debug(format, argArray);
        }
    }

    public static void errorExceptionStack(Object obj, Throwable t) {
        if (LogAdapter.isErrorEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).error(t.getLocalizedMessage(), t);
        }
    }

    public static void debug(Object obj, String msg, Throwable t) {
        if (LogAdapter.isDebugEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).debug(msg, t);
        }
    }

    public static void info(Object obj, String msg) {
        if (LogAdapter.isInfoEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).info(msg);
        }
    }

    public static void info(Object obj, String format, Object ... argArray) {
        if (LogAdapter.isInfoEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).info(format, argArray);
        }
    }

    public static void info(Object obj, String msg, Throwable t) {
        if (LogAdapter.isInfoEnabled(obj)) {
            LogAdapter.getLoggerInst(obj).info(msg, t);
        }
    }
}

