/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.request;

import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.ibm.bi.platform.synchromesh.core.config.SynchromeshConfig;
import com.ibm.bi.platform.synchromesh.core.rest.service.ContentService;
import com.ibm.bi.platform.synchromesh.core.rest.service.GenericService;
import com.ibm.bi.platform.synchromesh.core.rest.service.SearchService;
import com.ibm.bi.platform.synchromesh.core.rest.service.TrustedContentService;
import com.ibm.bi.platform.synchromesh.core.sync.SyncEngine;
import com.ibm.bi.platform.synchromesh.core.sync.SyncManager;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineConfig;
import com.ibm.bi.rest.RESTClientConfig;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;

public class RequestEnvironment {
    private static final String NO_NAME = "no_name";
    private static final String DEFAULT_LOCALE = "en";
    private final RESTClientConfig config;
    private final ExecutorService executorService;
    private final UserPreferences userPreferences;
    private final String baseURL;
    private final Locale contentLocale;
    private final Locale productLocale;
    private final Map<String, Object> parameters;
    private ContentService contentService;
    private ContentService trustedContentService;
    private GenericService genericService;
    private SearchService searchService;
    private SearchService trustedSearchService;
    private SyncManager syncManager;

    public RequestEnvironment(HttpServletRequest request, ExecutorService executorService, UserPreferences userPreferences, String baseURL) {
        this.config = new RESTClientConfig(request);
        this.executorService = executorService;
        this.userPreferences = userPreferences;
        this.baseURL = baseURL;
        this.contentLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(userPreferences.getContentLocale(), DEFAULT_LOCALE));
        this.productLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(userPreferences.getProductLocale(), DEFAULT_LOCALE));
        this.parameters = new HashMap<String, Object>();
    }

    public RESTClientConfig getRESTClientConfig() {
        return this.config;
    }

    public Object getUserPreference(String name, String defaultValue) {
        return RequestEnvironment.getOrDefault(this.userPreferences.getPreference(name), defaultValue);
    }

    public String getUserName() {
        return RequestEnvironment.getOrDefault(this.userPreferences.getUserName(), NO_NAME);
    }

    public String getUserDisplayName() {
        return RequestEnvironment.getOrDefault(this.userPreferences.getUserDisplayName(), NO_NAME);
    }

    public String getUserId() {
        return this.userPreferences.getPreference("id");
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private static String getOrDefault(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public ContentService getContentService() {
        if (SynchromeshConfig.getContentTrustedRequests()) {
            if (this.trustedContentService == null) {
                this.trustedContentService = this.createContentService(true);
            }
            return this.trustedContentService;
        }
        if (this.contentService == null) {
            this.contentService = this.createContentService(false);
        }
        return this.contentService;
    }

    private ContentService createContentService(boolean trusted) {
        return trusted ? new TrustedContentService(this.getRESTClientConfig()) : new ContentService(this.getRESTClientConfig());
    }

    public GenericService getGenericService() {
        if (this.genericService == null) {
            this.genericService = this.createGenericService();
        }
        return this.genericService;
    }

    private GenericService createGenericService() {
        return new GenericService(this.getRESTClientConfig());
    }

    public SyncEngine createSyncEngine(SyncEngineConfig c) {
        return new SyncEngine(this, c);
    }

    public SearchService getSearchService() {
        if (SynchromeshConfig.getSearchTrustedRequests()) {
            if (this.trustedSearchService == null) {
                this.trustedSearchService = this.createSearchService(true);
            }
            return this.trustedSearchService;
        }
        if (this.searchService == null) {
            this.searchService = this.createSearchService(false);
        }
        return this.searchService;
    }

    private SearchService createSearchService(boolean trusted) {
        return new SearchService(this.getRESTClientConfig());
    }

    public SyncManager getSyncManager() {
        if (this.syncManager == null) {
            this.syncManager = new SyncManager(this);
        }
        return this.syncManager;
    }

    public Object setParam(String key, Object value) {
        if (key == null) {
            return null;
        }
        return this.parameters.put(key, value);
    }

    public Object getParam(String key) {
        if (key == null) {
            return null;
        }
        return this.parameters.get(key);
    }

    public String getStringParam(String key) {
        return (String)this.getParam(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

