/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.request;

import com.ibm.bi.platform.commons.messages.CommonsRuntimeException;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.synchromesh.common.utils.ResponseUtil;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RequestUtil {
    private RequestUtil() {
    }

    public static Response getResponse(Response.Status status, Message message, Locale locale, Throwable e) {
        String msg = message.getLocalizedMessage(locale);
        JSONObject response = RequestUtil.buildExceptionResponse(msg, e, locale);
        return RequestUtil.getResponse(status, (Object)response);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param0 key, Locale locale, Throwable e) {
        String msg = new Message(key).getLocalizedMessage(locale);
        JSONObject response = RequestUtil.buildExceptionResponse(msg, e, locale);
        return RequestUtil.getResponse(status, (Object)response);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param1 key, Locale locale, String param1, Throwable e) {
        String msg = new Message(key, (Object)param1).getLocalizedMessage(locale);
        JSONObject response = RequestUtil.buildExceptionResponse(msg, e, locale);
        return RequestUtil.getResponse(status, (Object)response);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param2 key, Locale locale, String param1, String param2, Throwable e) {
        String msg = new Message(key, (Object)param1, (Object)param2).getLocalizedMessage(locale);
        JSONObject response = RequestUtil.buildExceptionResponse(msg, e, locale);
        return RequestUtil.getResponse(status, (Object)response);
    }

    public static Response getResponse(Response.Status status) {
        return RequestUtil.getResponse(status, null);
    }

    public static Response getResponse(Response.Status status, Object entity) {
        return ResponseUtil.getResponse((Response.Status)status, (Object)entity);
    }

    public static Response getResponse(Response.Status status, Object entity, MediaType type, String eTag, long lastModified) {
        return ResponseUtil.getResponse((Response.Status)status, (Object)entity, (MediaType)type, (String)eTag, (long)lastModified);
    }

    public static Response getResponse(int status, Object entity) {
        if (entity == null) {
            return Response.status((int)status).build();
        }
        return Response.status((int)status).entity(entity).build();
    }

    private static JSONObject buildExceptionResponse(String msg, Throwable e, Locale locale) {
        JSONObject response = new JSONObject();
        response.put((Object)"msg", (Object)msg);
        if (e != null) {
            response.put((Object)"exceptionMsg", (Object)RequestUtil.getLocalizedMessage(e, locale));
            Throwable t = e.getCause();
            if (t != null) {
                response.put((Object)"exceptionCauseMsg", (Object)RequestUtil.getLocalizedMessage(t, locale));
            }
        }
        return response;
    }

    private static String getLocalizedMessage(Throwable e, Locale locale) {
        if (e instanceof CommonsRuntimeException) {
            return ((CommonsRuntimeException)e).getLocalizedMessage(locale);
        }
        return e.getLocalizedMessage();
    }

    public static Response getResponse(Response.Status status, Message message, Locale productLocale) {
        return RequestUtil.getResponse(status, message, productLocale, null);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param2 msgParm2, Locale productLocale, String id, String value) {
        return RequestUtil.getResponse(status, msgParm2, productLocale, id, value, null);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param1 msgParm1, Locale productLocale, String parm1) {
        return RequestUtil.getResponse(status, msgParm1, productLocale, parm1, null);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param0 msgParm0, Locale productLocale) {
        return RequestUtil.getResponse(status, msgParm0, productLocale, null);
    }
}

