/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.rest.service;

import com.ibm.bi.platform.synchromesh.core.rest.RESTClientResponse;
import com.ibm.bi.platform.synchromesh.core.rest.service.BaseService;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import javax.ws.rs.core.Response;

public class SearchService
extends BaseService {
    public static final String SEARCH_SERVICE_URL = "/bi/v1/search/cm";
    private HashMap<String, String[]> fields = new HashMap();
    private long totalResults = 0L;
    private JSONArray results = null;

    public SearchService(RESTClientConfig config) {
        super(config);
    }

    public void execute() {
        this.totalResults = 0L;
        this.results = null;
        RESTClientResponse resp = this.get(this.buildURL());
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            return;
        }
        JSONObject objectJSON = resp.getJSONObjectResponse();
        if (objectJSON == null) {
            return;
        }
        this.totalResults = (Long)objectJSON.get((Object)"totalResults");
        this.results = (JSONArray)objectJSON.get((Object)"results");
    }

    public JSONArray getResults() {
        return this.results;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public void setFilter(String ... value) {
        this.fields.put("filter", value);
    }

    public void setFields(String ... value) {
        this.fields.put("fields", value);
    }

    public void setQuery(String value) {
        this.fields.put("query", new String[]{value});
    }

    private String buildURL() {
        StringBuilder builder = new StringBuilder();
        this.fields.forEach((k, v) -> {
            builder.append(builder.length() == 0 ? "?" : "&");
            builder.append((String)k);
            builder.append("=");
            for (int i = 0; i < ((String[])v).length; ++i) {
                if (i > 0) {
                    if ("filter".equals(k) && i % 2 == 0) {
                        builder.append("&filter=");
                    } else {
                        builder.append("|");
                    }
                }
                builder.append(v[i]);
            }
        });
        this.fields.clear();
        builder.insert(0, SEARCH_SERVICE_URL);
        return builder.toString();
    }

    public String toString() {
        return this.buildURL();
    }
}

