/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.sync;

import com.ibm.bi.platform.synchromesh.common.exception.GenericException;
import com.ibm.bi.platform.synchromesh.common.exception.SynchromeshError;
import com.ibm.bi.platform.synchromesh.common.exception.SynchromeshException;
import com.ibm.bi.platform.synchromesh.core.api.json.JSONApiError;
import com.ibm.bi.platform.synchromesh.core.api.json.JSONApiResponse;
import com.ibm.bi.platform.synchromesh.core.api.json.sync.SyncNotification;
import com.ibm.bi.platform.synchromesh.core.api.json.sync.SyncRequest;
import com.ibm.bi.platform.synchromesh.core.api.json.sync.SyncResponse;
import com.ibm.bi.platform.synchromesh.core.request.RequestEnvironment;
import com.ibm.bi.platform.synchromesh.core.rest.RESTClientResponse;
import com.ibm.bi.platform.synchromesh.core.rest.service.GenericService;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineConfig;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineRequest;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineSequence;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineURL;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;

public class SyncEngine {
    private RequestEnvironment requestEnv;
    private SyncEngineConfig config;

    public SyncEngine(RequestEnvironment requestEnv, SyncEngineConfig config) {
        this.config = config;
        this.requestEnv = requestEnv;
    }

    public boolean skip() {
        SyncEngineSequence sequence = this.config.batch();
        return sequence == null || sequence.isEmpty();
    }

    public void filter(SyncRequest request) {
        JSONArray monitoredAncestors = this.config.ancestors();
        if (monitoredAncestors == null || monitoredAncestors.isEmpty()) {
            return;
        }
        JSONArray data = request.getData();
        if (data == null || data.isEmpty()) {
            return;
        }
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            SyncNotification notification = new SyncNotification((JSONObject)iter.next());
            JSONArray ancestors = (JSONArray)notification.getContentAttribute("ancestors");
            boolean found = false;
            for (Object a : monitoredAncestors) {
                if (!ancestors.contains(a)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iter.remove();
        }
    }

    public SyncResponse batch(SyncRequest request) {
        if (this.skip()) {
            return new SyncResponse();
        }
        SyncEngineSequence sequence = this.config.batch();
        RESTClientResponse resp = this.executeSequence(request, sequence);
        return new SyncResponse(resp);
    }

    private RESTClientResponse executeSequence(JSONObject json, SyncEngineSequence sequence) {
        JSONArray warnings = new JSONArray();
        JSONObject payload = json;
        RESTClientResponse resp = new RESTClientResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        for (int i = 0; i < sequence.size(); ++i) {
            SyncEngineRequest request = sequence.get(i);
            resp = this.executeRequest(payload, request);
            if (i >= sequence.size() - 1) continue;
            payload = resp.getJSONObjectResponse();
            JSONApiResponse response = new JSONApiResponse(payload);
            JSONArray errors = response.getErrors();
            if (errors != null) {
                warnings.addAll((Collection)errors);
            }
            if ((errors = (JSONArray)response.getMeta("errors")) == null) continue;
            warnings.addAll((Collection)errors);
        }
        return warnings.isEmpty() ? resp : SyncEngine.mergeWarnings(resp, warnings);
    }

    private RESTClientResponse executeRequest(JSONObject result, SyncEngineRequest request) {
        RESTClientResponse resp = null;
        List<SyncEngineRequest.OnError> onErrorList = request.onError();
        for (int i = 0; i <= onErrorList.size(); ++i) {
            SyncEngineRequest.OnError onError = i >= onErrorList.size() ? SyncEngineRequest.OnError.FAIL : onErrorList.get(i);
            resp = this.execute(request, result);
            if (request.success(resp.getResponseCode())) {
                return resp;
            }
            if (SyncEngineRequest.OnError.CONTINUE.equals((Object)onError)) {
                return resp;
            }
            if (!SyncEngineRequest.OnError.FAIL.equals((Object)onError)) continue;
            JSONApiResponse jsonResp = new JSONApiResponse(resp.getJSONObjectResponse());
            JSONArray errors = jsonResp.getErrors();
            if (errors == null || errors.isEmpty()) {
                throw new GenericException(resp.getResponseCode(), (JSONObject)jsonResp);
            }
            JSONApiError error = new JSONApiError((JSONObject)errors.get(0));
            JSONObject entity = (JSONObject)error.getMeta("response");
            if (entity == null) {
                entity = error;
            }
            throw new GenericException(resp.getResponseCode(), entity);
        }
        throw resp == null ? new SynchromeshException(SynchromeshError.GEN_INTERNAL_ERROR) : new GenericException(resp.getResponseCode(), resp.getJSONObjectResponse());
    }

    private RESTClientResponse execute(SyncEngineRequest request, JSONObject value) {
        RESTClientResponse resp;
        SyncEngineRequest.SyncEngineMethodType method = request.getMethod();
        switch (method) {
            case POST: {
                resp = this.post(request, value);
                break;
            }
            case PUT: {
                resp = this.put(request, value);
                break;
            }
            case DELETE: {
                resp = this.delete(request);
                break;
            }
            default: {
                resp = this.get(request);
            }
        }
        return resp;
    }

    private static RESTClientResponse mergeWarnings(RESTClientResponse resp, JSONArray warnings) {
        JSONApiResponse payload = new JSONApiResponse(resp.getJSONObjectResponse());
        JSONArray latestWarnings = (JSONArray)payload.getMeta("errors");
        if (latestWarnings == null) {
            latestWarnings = new JSONArray();
            payload.setMeta("errors", latestWarnings);
        }
        latestWarnings.addAll((Collection)warnings);
        ByteArrayInputStream is = new ByteArrayInputStream(payload.toString().getBytes(StandardCharsets.UTF_8));
        return new RESTClientResponse(resp.getResponseCode(), is);
    }

    private RESTClientResponse get(SyncEngineRequest request) {
        GenericService service = this.requestEnv.getGenericService();
        SyncEngineURL url = request.getURL();
        return service.get(url.toURIBuilder(this.requestEnv).toString());
    }

    private RESTClientResponse post(SyncEngineRequest request, JSONObject value) {
        GenericService service = this.requestEnv.getGenericService();
        SyncEngineURL url = request.getURL();
        String body = request.getBody();
        if (body != null) {
            return service.post(url.toURIBuilder(this.requestEnv).toString(), body);
        }
        return service.post(url.toURIBuilder(this.requestEnv).toString(), value);
    }

    private RESTClientResponse put(SyncEngineRequest request, JSONObject value) {
        GenericService service = this.requestEnv.getGenericService();
        SyncEngineURL url = request.getURL();
        String body = request.getBody();
        if (body != null) {
            return service.put(url.toURIBuilder(this.requestEnv).toString(), body);
        }
        return service.put(url.toURIBuilder(this.requestEnv).toString(), value);
    }

    private RESTClientResponse delete(SyncEngineRequest request) {
        GenericService service = this.requestEnv.getGenericService();
        SyncEngineURL url = request.getURL();
        return service.delete(url.toURIBuilder(this.requestEnv).toString());
    }
}

