/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.sync.config;

import com.ibm.bi.platform.synchromesh.core.logging.LogAdapter;
import com.ibm.bi.platform.synchromesh.core.sync.config.SyncEngineURL;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class SyncEngineRequest
extends JSONObject {
    private static final long serialVersionUID = 5932305676355431865L;
    private static final String ASYNC = "async";
    private static final String BODY = "body";
    private static final String METHOD = "method";
    private static final String ON_ERROR = "onError";
    private static final String ON_SUCCESS = "onSuccess";
    private static final String VALUE = "value";
    private static final String URL = "url";

    protected SyncEngineRequest() {
    }

    protected SyncEngineRequest(JSONObject json) {
        if (json != null) {
            this.putAll((Map)json);
        }
    }

    public boolean getAsync() {
        Object value = this.get(ASYNC);
        return value instanceof Boolean && (Boolean)value != false;
    }

    public String getBody() {
        Object value = this.get(BODY);
        return value instanceof JSONObject ? (String)((JSONObject)value).get((Object)VALUE) : null;
    }

    public SyncEngineMethodType getMethod() {
        try {
            String value = (String)this.getOrDefault(METHOD, SyncEngineMethodType.GET.toString());
            return SyncEngineMethodType.valueOf(value.toUpperCase());
        }
        catch (Exception e) {
            LogAdapter.errorExceptionStack((Object)this, e);
            return SyncEngineMethodType.GET;
        }
    }

    public SyncEngineURL getURL() {
        return new SyncEngineURL((JSONObject)this.get(URL));
    }

    public List<OnError> onError() {
        ArrayList<OnError> result = new ArrayList<OnError>();
        JSONArray value = (JSONArray)this.get(ON_ERROR);
        if (value == null || value.isEmpty()) {
            result.add(OnError.FAIL);
        } else {
            for (Object o : value) {
                result.add(this.toOnError((String)o));
            }
        }
        return result;
    }

    private OnError toOnError(String value) {
        try {
            return OnError.valueOf(value.toUpperCase());
        }
        catch (Exception e) {
            LogAdapter.errorExceptionStack((Object)this, e);
            return OnError.FAIL;
        }
    }

    public boolean success(int responseCode) {
        Long value = responseCode;
        JSONArray onSuccess = (JSONArray)this.get(ON_SUCCESS);
        if (onSuccess == null) {
            return Response.Status.OK.getStatusCode() == responseCode;
        }
        for (Object o : onSuccess) {
            if (!value.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static enum OnError {
        FAIL("FAIL"),
        RETRY("RETRY"),
        CONTINUE("CONTINUE");

        private final String value;

        private OnError(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SyncEngineMethodType {
        DELETE("DELETE"),
        GET("GET"),
        POST("POST"),
        PUT("PUT");

        private final String value;

        private SyncEngineMethodType(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }
    }
}

