/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.sync.handler;

import com.ibm.bi.platform.synchromesh.core.api.json.sync.SyncRequest;
import com.ibm.bi.platform.synchromesh.core.api.json.sync.SyncResponse;
import com.ibm.bi.platform.synchromesh.core.logging.LogAdapter;
import com.ibm.bi.platform.synchromesh.core.request.RequestEnvironment;
import com.ibm.bi.platform.synchromesh.core.sync.SyncEngine;
import com.ibm.bi.platform.synchromesh.core.sync.handler.SyncHandler;
import com.ibm.json.java.JSONObject;

public class BatchHandler
extends SyncHandler {
    public BatchHandler(RequestEnvironment requestEnv, SyncEngine engine, JSONObject json) {
        super(requestEnv, engine, json);
    }

    @Override
    public void run() {
        try {
            if (this.engine.skip()) {
                LogAdapter.trace(this, "Sync is not configured to push notifications");
                return;
            }
            SyncRequest request = SyncRequest.fromNotification(this.json);
            this.engine.filter(request);
            if (request.getData() == null || request.getData().isEmpty()) {
                LogAdapter.trace(this, "No notifications due to filtered or bad input");
                return;
            }
            SyncResponse response = this.engine.batch(request);
            if (LogAdapter.isTraceEnabled(this)) {
                LogAdapter.trace(this, "Sync response: " + response.toString());
            }
        }
        catch (Exception e) {
            LogAdapter.errorExceptionStack(this, e);
        }
    }
}

