/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.synchromesh.core.utils;

import com.ibm.bi.platform.synchromesh.core.logging.LogAdapter;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class TimeUtil {
    private static final Pattern XSD_DATE_TIME_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[^.]+([.][0-9]{3}|)(Z|[+-][0-9]{2}:[0-9]{2})");
    private static DatatypeFactory datatypeFactory = null;

    private TimeUtil() {
    }

    public static XMLGregorianCalendar getCurrentTimeGregorian() {
        return TimeUtil.getTimeGregorian(System.currentTimeMillis());
    }

    public static XMLGregorianCalendar getCurrentTimeGregorianUTC() {
        return TimeUtil.getTimeGregorianUTC(System.currentTimeMillis());
    }

    public static XMLGregorianCalendar getTimeGregorian(long ms) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(ms);
        return datatypeFactory.newXMLGregorianCalendar(date);
    }

    public static XMLGregorianCalendar getTimeGregorianUTC(long ms) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeZone(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(ms);
        XMLGregorianCalendar time = datatypeFactory.newXMLGregorianCalendar(date);
        time.setTimezone(0);
        return time;
    }

    public static XMLGregorianCalendar getTimeGregorian(String xsdDateTime) {
        if (xsdDateTime == null || xsdDateTime.isEmpty() || !XSD_DATE_TIME_PATTERN.matcher(xsdDateTime).matches()) {
            return null;
        }
        return datatypeFactory.newXMLGregorianCalendar(xsdDateTime);
    }

    public static String formatDate(XMLGregorianCalendar calendar, Locale locale) {
        return TimeUtil.formatDate(calendar, 3, locale);
    }

    private static String formatDate(XMLGregorianCalendar calendar, int style, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(style, locale);
        df.setTimeZone(calendar.getTimeZone(calendar.getTimezone()));
        return df.format(calendar.toGregorianCalendar().getTime());
    }

    public static String formatDateTime(XMLGregorianCalendar calendar, Locale locale) {
        return TimeUtil.formatDateTime(calendar, 3, locale);
    }

    private static String formatDateTime(XMLGregorianCalendar calendar, int style, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(style, style, locale);
        df.setTimeZone(calendar.getTimeZone(calendar.getTimezone()));
        return df.format(calendar.toGregorianCalendar().getTime());
    }

    public static long getTimeInMillis(String xsdDateTime) {
        XMLGregorianCalendar cal = TimeUtil.getTimeGregorian(xsdDateTime);
        if (cal == null) {
            return 0L;
        }
        return cal.toGregorianCalendar().getTimeInMillis();
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            LogAdapter.error(DatatypeFactory.class, e.getLocalizedMessage(), e);
        }
    }
}

