/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.triangle.FunctionalBackupWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.util.ByteString;
import org.infinispan.util.TriangleFunctionsUtil;

public class MultiEntriesFunctionalBackupWriteCommand
extends FunctionalBackupWriteCommand {
    public static final byte COMMAND_ID = 79;
    private boolean writeOnly;
    private Map<?, ?> entries;

    public MultiEntriesFunctionalBackupWriteCommand() {
        super(null);
    }

    public MultiEntriesFunctionalBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    public void init(InvocationContextFactory factory, AsyncInterceptorChain chain, ComponentRegistry componentRegistry) {
        this.injectDependencies(factory, chain);
        this.componentRegistry = componentRegistry;
    }

    public <K, V, T> void setWriteOnly(WriteOnlyManyEntriesCommand<K, V, T> command, Collection<Object> keys) {
        this.setCommonAttributesFromCommand(command);
        this.setFunctionalCommand(command);
        this.writeOnly = true;
        this.entries = TriangleFunctionsUtil.filterEntries(command.getArguments(), keys);
        this.function = command.getBiConsumer();
    }

    public <K, V, T, R> void setReadWrite(ReadWriteManyEntriesCommand<K, V, T, R> command, Collection<Object> keys) {
        this.setCommonAttributesFromCommand(command);
        this.setFunctionalCommand(command);
        this.writeOnly = false;
        this.entries = TriangleFunctionsUtil.filterEntries(command.getArguments(), keys);
        this.function = command.getBiFunction();
    }

    @Override
    public byte getCommandId() {
        return 79;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        this.writeFunctionAndParams(output);
        output.writeBoolean(this.writeOnly);
        MarshallUtil.marshallMap(this.entries, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.readFunctionAndParams(input);
        this.writeOnly = input.readBoolean();
        this.entries = MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
    }

    @Override
    WriteCommand createWriteCommand() {
        AbstractWriteManyCommand cmd = this.writeOnly ? new WriteOnlyManyEntriesCommand(this.entries, (BiConsumer)this.function, this.params, this.getCommandInvocationId(), this.keyDataConversion, this.valueDataConversion, this.componentRegistry) : new ReadWriteManyEntriesCommand(this.entries, (BiFunction)this.function, this.params, this.getCommandInvocationId(), this.keyDataConversion, this.valueDataConversion, this.componentRegistry);
        cmd.setForwarded(true);
        return cmd;
    }
}

