/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.utils.Constants;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.messages.Message;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CertificatesUtils {
    public static X509Certificate[] buildPkixValidCertChain(X509Certificate targetCert, List<X509Certificate> intermediateCerts, Set<X509Certificate> trustAnchors) throws CAMCryptoException {
        try {
            Objects.requireNonNull(targetCert);
            Objects.requireNonNull(intermediateCerts);
            Objects.requireNonNull(trustAnchors);
            ArrayList<X509Certificate> targetAndIntermediateCerts = new ArrayList<X509Certificate>();
            targetAndIntermediateCerts.add(targetCert);
            targetAndIntermediateCerts.addAll(intermediateCerts);
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(targetAndIntermediateCerts));
            CertPathBuilder certPathBuilder = JcaFactory.getInstance(CertPathBuilder.class, "PKIX");
            X509CertSelector targetConstraints = new X509CertSelector();
            targetConstraints.setCertificate(targetCert);
            Set<TrustAnchor> anchors = CertificatesUtils.buildTrustAnchors(trustAnchors);
            PKIXBuilderParameters params = new PKIXBuilderParameters(anchors, (CertSelector)targetConstraints);
            params.addCertStore(certStore);
            params.setRevocationEnabled(false);
            params.setMaxPathLength(-1);
            params.setDate(Constants.CERTS_VALIDATION_REFERENCE_DATE);
            PKIXCertPathBuilderResult certPath = (PKIXCertPathBuilderResult)certPathBuilder.build(params);
            return (X509Certificate[])Stream.concat(certPath.getCertPath().getCertificates().stream(), Stream.of(certPath.getTrustAnchor().getTrustedCert())).toArray(X509Certificate[]::new);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.no_provider_available.buildMessage((Object)"CertStore", (Object)"Collection"));
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.no_provider_available.buildMessage((Object)"CertPathBuilder", (Object)"PKIX"));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.trust_anchors_empty.buildMessage());
        }
        catch (CertPathBuilderException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_build_cert_chain.buildMessage());
        }
    }

    private static Set<TrustAnchor> buildTrustAnchors(Set<X509Certificate> trustAnchors) {
        return trustAnchors.stream().map(certificate -> new TrustAnchor((X509Certificate)certificate, null)).collect(Collectors.toSet());
    }

    public static boolean isCertChainPkixValid(X509Certificate targetCert, List<X509Certificate> intermediateCerts, Set<X509Certificate> trustAnchors) throws CAMCryptoException {
        try {
            Objects.requireNonNull(targetCert);
            Objects.requireNonNull(intermediateCerts);
            Objects.requireNonNull(trustAnchors);
            CertPathValidator certPathValidator = JcaFactory.getInstance(CertPathValidator.class, "PKIX");
            X509CertSelector targetConstraints = new X509CertSelector();
            targetConstraints.setCertificate(targetCert);
            PKIXParameters params = new PKIXParameters(CertificatesUtils.buildTrustAnchors(trustAnchors));
            params.setRevocationEnabled(false);
            params.setTargetCertConstraints(targetConstraints);
            params.setDate(Constants.CERTS_VALIDATION_REFERENCE_DATE);
            List<X509Certificate> certChain = null;
            certChain = CertificatesUtils.targetMayBeCertChainAnchor(targetCert, intermediateCerts, trustAnchors) ? intermediateCerts : Stream.concat(Stream.of(targetCert), intermediateCerts.stream()).collect(Collectors.toList());
            CamX509CertPath certPath = new CamX509CertPath(certChain);
            certPathValidator.validate(certPath, params);
            return true;
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.no_provider_available, (Object)"CertPathValidator", (Object)"PKIX"));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CAMCryptoException(CamCryptoMessageKeys.trust_anchors_empty.buildMessage());
        }
        catch (CertPathValidatorException certPathValidatorException) {
            return false;
        }
    }

    private static boolean targetMayBeCertChainAnchor(X509Certificate targetCert, List<X509Certificate> intermediateCerts, Set<X509Certificate> trustAnchors) {
        return trustAnchors.contains(targetCert) && intermediateCerts.isEmpty();
    }

    public static boolean isCertSelfSigned(Certificate certificate) {
        try {
            certificate.verify(certificate.getPublicKey());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isCertValid(Certificate certificate) {
        try {
            return Constants.CERTS_VALIDATION_REFERENCE_DATE.compareTo(((X509Certificate)certificate).getNotAfter()) <= 0 && Constants.CERTS_VALIDATION_REFERENCE_DATE.compareTo(((X509Certificate)certificate).getNotBefore()) >= 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String certChainToString(Certificate[] certChain) {
        try {
            if (certChain != null && certChain.length > 0) {
                return Arrays.stream(certChain).map(CertificatesUtils::certToString).collect(Collectors.joining("\n"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "***";
    }

    public static String certToString(Certificate certificate) {
        try {
            return ((X509Certificate)certificate).getSubjectX500Principal().toString();
        }
        catch (Throwable t) {
            return "";
        }
    }

    private static class CamX509CertPath
    extends CertPath {
        private List<? extends Certificate> certificates;

        protected CamX509CertPath(String type) {
            super(type);
        }

        public CamX509CertPath(List<X509Certificate> chain) {
            super("X.509");
            this.certificates = chain;
        }

        @Override
        public Iterator<String> getEncodings() {
            return null;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return new byte[0];
        }

        @Override
        public byte[] getEncoded(String encoding) throws CertificateEncodingException {
            return new byte[0];
        }

        @Override
        public List<? extends Certificate> getCertificates() {
            return this.certificates;
        }
    }
}

