/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcfgapi;

import com.ibm.cognos.ccl4j.message.CCLMessageTemplateFramework;
import com.ibm.cognos.ccl4j.message.CCLMessagesFromResourceBundle;
import com.ibm.cognos.ccl4j.message.ICCLMessageTemplate;
import java.text.MessageFormat;
import java.util.Locale;

public class CCLConfigurationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int m_errorCode = 0;
    private String m_message = null;
    private static CCLMessagesFromResourceBundle m_resources = null;
    private Object m_guard;
    public static final int CCLCFGAPI_Success = 0;
    public static final int CCLCFGAPI_StartupFileNotFound = 1;
    public static final int CCLCFGAPI_StartupFileEmpty = 2;
    public static final int CCLCFGAPI_StartupFileParseError = 3;
    public static final int CCLCFGAPI_StartupFileViolation = 4;
    public static final int CCLCFGAPI_RuntimeDocParseError = 5;
    public static final int CCLCFGAPI_InitAPIWarning = 6;
    public static final int CCLCFGAPI_InitCryptoError = 7;
    public static final int CCLCFGAPI_CryptoDecryptionError = 8;
    public static final int CCLCFGAPI_UnknownException = 9;
    public static final int CCLCFGAPI_InvalidArguments = 10;
    public static final int CCLCFGAPI_LocaleFileNotFound = 11;
    public static final int CCLCFGAPI_LocaleFileParseError = 12;
    public static final int CCLCFGAPI_UnsupportedLocaleError = 13;
    public static final int CCLCFGAPI_CmpLstFileNotFound = 14;
    public static final int CCLCFGAPI_CmpLstFileIOError = 15;
    public static final int CCLCFGAPI_I18NError = 16;

    public CCLConfigurationException() {
        this.m_guard = new Object();
    }

    public CCLConfigurationException(String s) {
        super(s);
        this.m_guard = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCLConfigurationException(int errorCode, Object[] params) {
        Object object = this.m_guard = new Object();
        synchronized (object) {
            if (m_resources == null) {
                try {
                    m_resources = new CCLMessagesFromResourceBundle("cclcfgapimsgs", Locale.getDefault());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        String key = this.getErrorStringKey(errorCode);
        String value = null;
        if (null != m_resources) {
            CCLMessageTemplateFramework theCCLMessageTemplate = new CCLMessageTemplateFramework(key, params);
            value = m_resources.getString((ICCLMessageTemplate)theCCLMessageTemplate);
        }
        if (null == value) {
            value = key;
        }
        this.m_message = value;
        this.m_errorCode = errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCLConfigurationException(int errorCode) {
        Object object = this.m_guard = new Object();
        synchronized (object) {
            if (m_resources == null) {
                try {
                    m_resources = new CCLMessagesFromResourceBundle("cclcfgapimsgs", Locale.getDefault());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        String key = this.getErrorStringKey(errorCode);
        String value = null;
        if (m_resources != null) {
            CCLMessageTemplateFramework theCCLMessageTemplate = new CCLMessageTemplateFramework(key, null);
            value = m_resources.getString((ICCLMessageTemplate)theCCLMessageTemplate);
        }
        if (null == value) {
            value = key;
        }
        this.m_message = value;
        this.m_errorCode = errorCode;
    }

    public String getErrorStringKey(int errorCode) {
        String key = null;
        switch (errorCode) {
            case 1: {
                key = "CCL_CFG_STARTUP_FILE_NOT_FOUND";
                break;
            }
            case 3: {
                key = "CCL_CFG_STARTUP_FILE_PARSE_ERROR";
                break;
            }
            case 4: {
                key = "CCL_CFG_STARTUP_FILE_VIOLATION";
                break;
            }
            case 5: {
                key = "CCL_CFG_RUNTIME_DOC_PARSE_ERROR";
                break;
            }
            case 7: {
                key = "CCL_CFG_INIT_CRYPTO_ERROR";
                break;
            }
            case 8: {
                key = "CCL_CFG_CRYPTO_DECRYPTION_ERROR";
                break;
            }
            case 10: {
                key = "CCL_CFG_INVALID_ARGUMENTS";
                break;
            }
            case 11: {
                key = "CCL_CFG_LOCALE_FILE_NOT_FOUND";
                break;
            }
            case 12: {
                key = "CCL_CFG_LOCALE_FILE_PARSE_ERROR";
                break;
            }
            case 13: {
                key = "CCL_CFG_UNSUPPORTED_LOCALE_ERROR";
                break;
            }
            case 14: {
                key = "CCL_CFG_CMPLST_FILE_NOT_FOUND";
                break;
            }
            case 15: {
                key = "CCL_CFG_CMPLST_FILE_IO_ERROR";
                break;
            }
            case 16: {
                key = "CCL_CFG_I18N_ERROR";
                break;
            }
            default: {
                key = "CCL_CFG_UNKNOWN_EXCEPTION";
            }
        }
        return key;
    }

    public String generateMessage(String sMsg, Object[] parms) {
        String sFormattedMsg = null;
        if (sMsg != null) {
            MessageFormat oMsgFormatter = new MessageFormat(sMsg);
            sFormattedMsg = oMsgFormatter.format(parms);
        }
        return sFormattedMsg;
    }

    @Override
    public String getMessage() {
        if (null != this.m_message) {
            return this.m_message;
        }
        return super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (null != this.m_message) {
            return this.m_message;
        }
        return super.getLocalizedMessage();
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }
}

