/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.TimeZone;
import com.cognos.i18n.ToolkitResources;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import java.util.Date;
import java.util.Locale;

public class Calendar {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int GREGORIAN = 0;
    public static final int JAPANESE = 1;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    protected com.ibm.icu.util.Calendar m_calendar;

    public Calendar() {
        this.m_calendar = new GregorianCalendar();
    }

    public Calendar(Locale locale) {
        this(ToolkitResources.getDefaultLocaleForCurrentLocale(locale), 0);
    }

    public Calendar(Locale locale, int type) {
        Locale theDefaultLocale = ToolkitResources.getDefaultLocaleForCurrentLocale(locale);
        switch (type) {
            case 1: {
                this.m_calendar = new JapaneseCalendar(theDefaultLocale);
                break;
            }
            default: {
                this.m_calendar = new GregorianCalendar(theDefaultLocale);
            }
        }
    }

    public Calendar(TimeZone timezone) {
        this(timezone, 0);
    }

    public Calendar(TimeZone timezone, int type) {
        switch (type) {
            case 1: {
                this.m_calendar = new JapaneseCalendar(com.ibm.icu.util.TimeZone.getTimeZone((String)timezone.getID()));
                break;
            }
            default: {
                this.m_calendar = new GregorianCalendar(com.ibm.icu.util.TimeZone.getTimeZone((String)timezone.getID()));
            }
        }
    }

    public void add(int field, int amount) {
        this.m_calendar.add(field, amount);
    }

    public int get(int field) {
        return this.m_calendar.get(field);
    }

    public Date getTime() {
        return this.m_calendar.getTime();
    }

    public void setTime(Date date) {
        this.m_calendar.setTime(date);
    }

    public boolean before(Calendar cal) {
        return this.m_calendar.before((Object)cal.m_calendar);
    }

    public boolean after(Calendar cal) {
        return this.m_calendar.after((Object)cal.m_calendar);
    }

    public static Calendar getInstance(TimeZone tz) {
        return new Calendar(tz);
    }

    public static Calendar getInstance() {
        return new Calendar();
    }

    public Object clone() {
        Calendar newCal = new Calendar();
        newCal.m_calendar = (com.ibm.icu.util.Calendar)this.m_calendar.clone();
        return newCal;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Calendar)) {
            return false;
        }
        return this.m_calendar.equals((Object)((Calendar)obj).m_calendar);
    }

    public int hashCode() {
        return this.m_calendar.hashCode();
    }

    public String toString() {
        return this.m_calendar.toString();
    }

    public int getActualMaximum(int field) {
        return this.m_calendar.getActualMaximum(field);
    }

    public void clear(int field) {
        this.m_calendar.clear(field);
    }

    public void set(int field, int value) {
        this.m_calendar.set(field, value);
    }

    public final void set(int year, int month, int date, int hour, int minute, int second) {
        this.m_calendar.set(year, month, date, hour, minute, second);
    }

    public TimeZone getTimeZone() {
        TimeZone tz = new TimeZone();
        tz.zone = this.m_calendar.getTimeZone();
        return tz;
    }

    public void setTimeZone(TimeZone tz) {
        this.m_calendar.setTimeZone(tz.zone);
    }
}

