/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.Collator;
import com.ibm.icu.util.TimeZone;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

class TimeZoneDescriptionComparator
implements Comparator<Map.Entry<String, String>> {
    Collator m_collator = null;

    public TimeZoneDescriptionComparator(Locale locale) {
        this.m_collator = new Collator(locale);
    }

    @Override
    public int compare(Map.Entry<String, String> entry1, Map.Entry<String, String> entry2) {
        String tzDescription1 = entry1.getValue();
        String tzDescription2 = entry2.getValue();
        String hourPart = tzDescription1.substring(5, 7);
        int rawOffset1 = 0;
        boolean useICU = false;
        try {
            rawOffset1 = Integer.valueOf(hourPart) * 1000;
        }
        catch (NumberFormatException e) {
            useICU = true;
        }
        if (!useICU) {
            String minutePart = tzDescription1.substring(8, 10);
            try {
                rawOffset1 += Integer.valueOf(minutePart).intValue();
            }
            catch (NumberFormatException e) {
                useICU = true;
            }
            if (!useICU && tzDescription1.charAt(4) == '-') {
                rawOffset1 *= -1;
            }
        }
        int rawOffset2 = 0;
        if (!useICU) {
            hourPart = tzDescription2.substring(5, 7);
            try {
                rawOffset2 = Integer.valueOf(hourPart) * 1000;
            }
            catch (NumberFormatException e) {
                useICU = true;
            }
            if (!useICU) {
                String minutePart = tzDescription2.substring(8, 10);
                try {
                    rawOffset2 += Integer.valueOf(minutePart).intValue();
                }
                catch (NumberFormatException e) {
                    useICU = true;
                }
                if (!useICU && tzDescription2.charAt(4) == '-') {
                    rawOffset2 *= -1;
                }
            }
        }
        if (useICU) {
            TimeZone tz1 = TimeZone.getTimeZone((String)entry1.getKey());
            TimeZone tz2 = TimeZone.getTimeZone((String)entry2.getKey());
            rawOffset1 = tz1.getRawOffset();
            rawOffset2 = tz2.getRawOffset();
        }
        if (rawOffset1 == rawOffset2) {
            int result = this.m_collator.compare(tzDescription1, tzDescription2);
            return result;
        }
        if (rawOffset1 >= 0 && rawOffset2 < 0) {
            return -1;
        }
        if (rawOffset2 >= 0 && rawOffset1 < 0) {
            return 1;
        }
        if (rawOffset1 > rawOffset2) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TimeZoneDescriptionComparator;
    }
}

