/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.i18n;

import com.cognos.i18n.NumericFormat;
import com.cognos.i18n.ToolkitResources;
import com.ibm.cognos.i18n.util.IntervalDHMSM;
import com.ibm.cognos.i18n.util.IntervalYM;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IntervalFormat {
    protected NumericFormat m_NumericFormat;
    public static final int I18N_HIDE = 0;
    public static final int I18N_SHOW = 1;
    public static final int I18N_ONE_DIGIT = 2;
    public static final int I18N_TWO_DIGITS = 3;
    public static final int I18N_SHORT_NAME = 4;
    public static final int I18N_FULL_NAME = 5;
    public static final int I18N_DAY_OF_YEAR = 6;
    public static final int I18N_THREE_DIGITS = 7;
    private static final int MONTH_PER_YEAR = 12;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final String TIME_SEPARATOR = ":";
    private static final String SPACE_SEPARATOR = " ";
    private static final String ONE_ZERO = "0";
    private static final String I18N_TIME_PERIOD_RES_BASE = "./ccli18nrestp_";
    private static final String I18N_TIME_PERIOD_SECTION_NAME = "TP";
    private static Locale m_locale = null;
    private static IntervalFormatStyle m_style = null;
    private static String m_firstSeparator = " ";
    private static String m_secondSeparator = " ";
    private static String m_timeSeparator = ":";
    private static int[] settings = null;
    private static Map<String, String> m_I18NMapOfStringString = null;

    private static synchronized void initI18NMap() {
        if (m_I18NMapOfStringString == null) {
            m_I18NMapOfStringString = new ConcurrentHashMap<String, String>(25);
        }
    }

    public IntervalFormat() {
        m_locale = ToolkitResources.getDefaultLocaleForCurrentLocale(m_locale);
        m_style = IntervalFormatStyle.SHORT_INTERVAL;
        this.reset();
        IntervalFormat.initI18NMap();
    }

    public IntervalFormat(Locale locale, IntervalFormatStyle style) {
        m_locale = locale;
        m_style = style;
        this.reset();
        IntervalFormat.initI18NMap();
        if (m_style == IntervalFormatStyle.LONG_INTERVAL) {
            this.loadResources(locale);
        }
    }

    public void reset() {
        this.m_NumericFormat = new NumericFormat(m_locale);
        this.m_NumericFormat.setMinimumFractionDigits(0);
        this.m_NumericFormat.setGroupingUsed(false);
        settings = new int[I18NIntervalElements.ELEMENT_COUNT.ordinal()];
        for (int i = I18NIntervalElements.YEAR.ordinal(); i < I18NIntervalElements.ELEMENT_COUNT.ordinal(); ++i) {
            IntervalFormat.settings[i] = -1;
        }
        m_timeSeparator = TIME_SEPARATOR;
    }

    public String format(IntervalYM interval) {
        String theFormattedValue = "";
        theFormattedValue = m_style == IntervalFormatStyle.SHORT_INTERVAL ? this.formatShortYM(interval) : this.formatLongYM(interval);
        return theFormattedValue;
    }

    public String format(int years, int months) {
        IntervalYM interval = new IntervalYM(false, 0, 0);
        interval.setYear(Math.abs(years));
        interval.setMonth(Math.abs(months));
        if (years < 0 || months < 0) {
            interval.setIsNegative(true);
        }
        return this.format(interval);
    }

    public String format(IntervalDHMSM interval, IntervalFormatDTType type) {
        String theFormattedValue = "";
        theFormattedValue = m_style == IntervalFormatStyle.SHORT_INTERVAL ? this.formatShortDHMSM(interval, type) : this.formatLongDHMSM(interval, type);
        return theFormattedValue;
    }

    public String format(int days, int hours, int minutes, int seconds, int milliseconds, IntervalFormatDTType type) {
        IntervalDHMSM interval = new IntervalDHMSM(false, 0, 0, 0, 0, 0);
        if (days < 0 || hours < 0 || minutes < 0 || seconds < 0 || milliseconds < 0) {
            interval.setIsNegative(true);
        }
        interval.setDay(Math.abs(days));
        interval.setHour(Math.abs(hours));
        interval.setMinute(Math.abs(minutes));
        interval.setSecond(Math.abs(seconds));
        interval.setMillisecond(Math.abs(milliseconds));
        return this.format(interval, type);
    }

    public String format(long days, long hours, long minutes, long seconds, long milliseconds, IntervalFormatDTType type) {
        IntervalDHMSM interval = new IntervalDHMSM(false, 0, 0, 0, 0, 0);
        if (days < 0L || hours < 0L || minutes < 0L || seconds < 0L || milliseconds < 0L) {
            interval.setIsNegative(true);
        }
        interval.setDay((long)Math.abs((double)days));
        interval.setHour((long)Math.abs((double)hours));
        interval.setMinute((long)Math.abs((double)minutes));
        interval.setSecond((long)Math.abs((double)seconds));
        interval.setMillisecond((long)Math.abs((double)milliseconds));
        return this.format(interval, type);
    }

    public void setNumericFormat(NumericFormat nf) {
        this.m_NumericFormat = nf;
    }

    public NumericFormat getNumericFormat() {
        return this.m_NumericFormat;
    }

    public void setStyle(IntervalFormatStyle style) {
        m_style = style;
        if (m_style == IntervalFormatStyle.LONG_INTERVAL) {
            this.loadResources(m_locale);
        }
    }

    public IntervalFormatStyle getStyle() {
        return m_style;
    }

    public void setTimeSeparatorSymbol(String timeSymbol) {
        m_timeSeparator = timeSymbol;
    }

    public String getTimeSeparatorSymbol() {
        return m_timeSeparator;
    }

    public void showYears(int setting) {
        if (setting >= 0 && setting <= 3) {
            IntervalFormat.settings[I18NIntervalElements.YEAR.ordinal()] = setting;
        }
    }

    public void showMonths(int setting) {
        if (ToolkitResources.isCJK(m_locale) && setting >= 4) {
            return;
        }
        if (setting >= 0 && setting <= 5) {
            IntervalFormat.settings[I18NIntervalElements.MONTH.ordinal()] = setting;
        }
    }

    public void showDays(int setting) {
        if (setting >= 0 && setting <= 3 || setting == 6) {
            IntervalFormat.settings[I18NIntervalElements.DAY.ordinal()] = setting;
        }
    }

    public void showHours(int setting) {
        if (setting >= 0 && setting <= 3) {
            IntervalFormat.settings[I18NIntervalElements.HOUR.ordinal()] = setting;
        }
    }

    public void showMinutes(int setting) {
        if (setting >= 0 && setting <= 3) {
            IntervalFormat.settings[I18NIntervalElements.MINUTE.ordinal()] = setting;
        }
    }

    public void showSeconds(int setting) {
        if (setting >= 0 && setting <= 3) {
            IntervalFormat.settings[I18NIntervalElements.SECOND.ordinal()] = setting;
        }
    }

    public void showMilliseconds(int setting) {
        if (setting >= 0 && setting <= 3 || setting == 7) {
            IntervalFormat.settings[I18NIntervalElements.MILLISECOND.ordinal()] = setting;
        }
    }

    private synchronized void loadResources(Locale locale) {
        String localeId = null;
        try {
            Hashtable<String, Map<String, String>> langToTimeMap = new Hashtable<String, Map<String, String>>();
            localeId = ToolkitResources.normalizeLocaleIdentifier(locale.toString());
            if (!ToolkitResources.loadResources(langToTimeMap, localeId, I18N_TIME_PERIOD_RES_BASE, I18N_TIME_PERIOD_SECTION_NAME)) {
                localeId = "en";
                ToolkitResources.loadResources(langToTimeMap, localeId, I18N_TIME_PERIOD_RES_BASE, I18N_TIME_PERIOD_SECTION_NAME);
            }
            if (!langToTimeMap.isEmpty()) {
                m_I18NMapOfStringString.putAll((Map)langToTimeMap.get(localeId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m_I18NMapOfStringString.isEmpty()) {
            m_I18NMapOfStringString.put("YEAR_COMPLETE_SINGULAR", "year");
            m_I18NMapOfStringString.put("MONTH_COMPLETE_SINGULAR", "month");
            m_I18NMapOfStringString.put("DAY_COMPLETE_SINGULAR", "day");
            m_I18NMapOfStringString.put("HOUR_COMPLETE_SINGULAR", "hour");
            m_I18NMapOfStringString.put("MINUTE_COMPLETE_SINGULAR", "minute");
            m_I18NMapOfStringString.put("SECOND_COMPLETE_SINGULAR", "second");
            m_I18NMapOfStringString.put("MILLISECOND_COMPLETE_SINGULAR", "millisecond");
            m_I18NMapOfStringString.put("YEAR_COMPLETE_PLURAL", "years");
            m_I18NMapOfStringString.put("YEAR_COMPLETE_PLURAL2", "years");
            m_I18NMapOfStringString.put("MONTH_COMPLETE_PLURAL", "months");
            m_I18NMapOfStringString.put("MONTH_COMPLETE_PLURAL2", "months");
            m_I18NMapOfStringString.put("DAY_COMPLETE_PLURAL", "days");
            m_I18NMapOfStringString.put("DAY_COMPLETE_PLURAL2", "days");
            m_I18NMapOfStringString.put("HOUR_COMPLETE_PLURAL", "hours");
            m_I18NMapOfStringString.put("HOUR_COMPLETE_PLURAL2", "hours");
            m_I18NMapOfStringString.put("MINUTE_COMPLETE_PLURAL", "minutes");
            m_I18NMapOfStringString.put("MINUTE_COMPLETE_PLURAL2", "minutes");
            m_I18NMapOfStringString.put("SECOND_COMPLETE_PLURAL", "seconds");
            m_I18NMapOfStringString.put("SECOND_COMPLETE_PLURAL2", "seconds");
            m_I18NMapOfStringString.put("MILLISECOND_COMPLETE_PLURAL", "milliseconds");
            m_I18NMapOfStringString.put("MILLISECOND_COMPLETE_PLURAL2", "milliseconds");
            m_I18NMapOfStringString.put("TIME_PERIOD_SYNTAX_SEPARATOR", "<param index=\"1\"/> <param index=\"2\"/>");
        }
    }

    private String addIntervalSign(boolean isNegative, String theFormattedValue) {
        String theNewFormattedValue = "";
        String suffix = "";
        String prefix = "";
        if (isNegative) {
            prefix = this.m_NumericFormat.getNegativePrefix();
            suffix = this.m_NumericFormat.getNegativeSuffix();
        } else {
            prefix = this.m_NumericFormat.getPositivePrefix();
            suffix = this.m_NumericFormat.getPositiveSuffix();
        }
        theNewFormattedValue = prefix + theFormattedValue + suffix;
        return theNewFormattedValue;
    }

    private String formatShortYM(IntervalYM interval) {
        String tempStr;
        String theFormattedValue = "";
        if (settings[I18NIntervalElements.YEAR.ordinal()] == 0 && settings[I18NIntervalElements.MONTH.ordinal()] == 0) {
            return theFormattedValue;
        }
        double years = interval.getYear();
        double months = interval.getMonth();
        int extra = 0;
        double tmpExtra = 0.0;
        if (months >= 12.0) {
            tmpExtra = months / 12.0;
            extra = (int)tmpExtra;
            years += (double)extra;
            months -= (double)(extra * 12);
        }
        if (settings[I18NIntervalElements.YEAR.ordinal()] == 0) {
            months += years * 12.0;
        }
        if (settings[I18NIntervalElements.YEAR.ordinal()] != 0) {
            tempStr = this.m_NumericFormat.format(years);
            theFormattedValue = theFormattedValue + tempStr;
        }
        if (settings[I18NIntervalElements.MONTH.ordinal()] != 0) {
            if (settings[I18NIntervalElements.YEAR.ordinal()] != 0) {
                tempStr = SPACE_SEPARATOR;
                theFormattedValue = theFormattedValue + tempStr;
            }
            tempStr = this.m_NumericFormat.format(months);
            theFormattedValue = theFormattedValue + tempStr;
        }
        boolean intervalIsZero = true;
        if (years != 0.0 && settings[I18NIntervalElements.YEAR.ordinal()] != 0) {
            intervalIsZero = false;
        } else if (months != 0.0 && settings[I18NIntervalElements.MONTH.ordinal()] != 0) {
            intervalIsZero = false;
        }
        if (!intervalIsZero) {
            theFormattedValue = this.addIntervalSign(interval.getIsNegative(), theFormattedValue);
        }
        return theFormattedValue;
    }

    private String formatLongYM(IntervalYM interval) {
        String theFormattedValue = "";
        if (settings[I18NIntervalElements.YEAR.ordinal()] == 0 && settings[I18NIntervalElements.MONTH.ordinal()] == 0) {
            return theFormattedValue;
        }
        double years = interval.getYear();
        double months = interval.getMonth();
        int extra = 0;
        double tmpExtra = 0.0;
        if (months >= 12.0) {
            tmpExtra = months / 12.0;
            extra = (int)tmpExtra;
            years += (double)extra;
            months -= (double)(extra * 12);
        }
        if (settings[I18NIntervalElements.YEAR.ordinal()] == 0) {
            months += years * 12.0;
        }
        int defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
        double paramToUse = 0.0;
        String mapKeyToUse = "";
        String word = "";
        String number = "";
        for (int i = I18NIntervalElements.YEAR.ordinal(); i <= I18NIntervalElements.MONTH.ordinal(); ++i) {
            switch (i) {
                case 0: {
                    paramToUse = years;
                    mapKeyToUse = "YEAR_COMPLETE_";
                    break;
                }
                case 1: {
                    paramToUse = months;
                    mapKeyToUse = "MONTH_COMPLETE_";
                }
            }
            if (settings[i] == 0) continue;
            if (settings[i] == 2 || settings[i] == 3 || settings[i] == 7) {
                switch (settings[i]) {
                    case 2: {
                        this.m_NumericFormat.setMinimumIntegerDigits(1);
                        break;
                    }
                    case 3: {
                        this.m_NumericFormat.setMinimumIntegerDigits(2);
                        break;
                    }
                    case 7: {
                        this.m_NumericFormat.setMinimumIntegerDigits(3);
                    }
                }
            }
            if (theFormattedValue.length() != 0) {
                theFormattedValue = theFormattedValue + m_secondSeparator;
            }
            number = this.m_NumericFormat.format(paramToUse);
            this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
            mapKeyToUse = paramToUse == 1.0 || paramToUse == -1.0 ? mapKeyToUse + "SINGULAR" : mapKeyToUse + "PLURAL";
            word = m_I18NMapOfStringString.get(mapKeyToUse);
            theFormattedValue = theFormattedValue + number + m_firstSeparator + word;
        }
        boolean intervalIsZero = true;
        if (years != 0.0 && settings[I18NIntervalElements.YEAR.ordinal()] != 0) {
            intervalIsZero = false;
        } else if (months != 0.0 && settings[I18NIntervalElements.MONTH.ordinal()] != 0) {
            intervalIsZero = false;
        }
        if (!intervalIsZero) {
            theFormattedValue = this.addIntervalSign(interval.getIsNegative(), theFormattedValue);
        }
        return theFormattedValue;
    }

    private String formatShortDHMSM(IntervalDHMSM interval, IntervalFormatDTType type) {
        String theFormattedValue = "";
        long days = interval.getDay();
        long hours = interval.getHour();
        long minutes = interval.getMinute();
        long seconds = interval.getSecond();
        long milliseconds = interval.getMillisecond();
        int showDay = settings[I18NIntervalElements.DAY.ordinal()];
        int showHour = settings[I18NIntervalElements.HOUR.ordinal()];
        int showMinute = settings[I18NIntervalElements.MINUTE.ordinal()];
        int showSecond = settings[I18NIntervalElements.SECOND.ordinal()];
        int showMillisecond = settings[I18NIntervalElements.MILLISECOND.ordinal()];
        if (showDay == 0 && showHour == 0 && showMinute == 0 && showSecond == 0 && showMillisecond == 0) {
            return theFormattedValue;
        }
        long extra = 0L;
        if (milliseconds >= 1000L && (showDay != 0 || showHour != 0 || showMinute != 0 || showSecond != 0)) {
            extra = milliseconds / 1000L;
            seconds += extra;
            milliseconds -= extra * 1000L;
        }
        if (seconds >= 60L && (showDay != 0 || showHour != 0 || showMinute != 0)) {
            extra = seconds / 60L;
            minutes += extra;
            seconds -= extra * 60L;
        }
        if (minutes >= 60L && (showDay != 0 || showHour != 0)) {
            extra = minutes / 60L;
            hours += extra;
            minutes -= extra * 60L;
        }
        if (hours >= 24L && showDay != 0) {
            extra = hours / 24L;
            days += extra;
            hours -= extra * 24L;
        }
        if (type != IntervalFormatDTType.FORMAT_DTTYPE_DEFAULT) {
            switch (type.ordinal()) {
                case 1: {
                    showHour = 0;
                    showMinute = 0;
                    showSecond = 0;
                    showMillisecond = 0;
                    if (showDay == 0) break;
                    showDay = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    if (seconds >= 30L) {
                        ++minutes;
                    }
                    if (minutes >= 30L) {
                        ++hours;
                    }
                    if (hours < 12L) break;
                    ++days;
                    break;
                }
                case 2: {
                    showDay = 0;
                    showMillisecond = 0;
                    if (showHour == 0) break;
                    showHour = 1;
                    showMinute = 1;
                    showSecond = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    if (seconds >= 30L) {
                        ++minutes;
                    }
                    if (minutes >= 30L) {
                        ++hours;
                    }
                    hours += days * 24L;
                    minutes = 0L;
                    seconds = 0L;
                    milliseconds = 0L;
                    break;
                }
                case 3: {
                    showDay = 0;
                    showMillisecond = 0;
                    if (showMinute == 0) break;
                    showHour = 1;
                    showMinute = 1;
                    showSecond = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    if (seconds >= 30L) {
                        ++minutes;
                    }
                    minutes += (hours += days * 24L) * 60L;
                    hours = 0L;
                    seconds = 0L;
                    milliseconds = 0L;
                    break;
                }
                case 4: {
                    showDay = 0;
                    showMillisecond = 0;
                    if (showSecond == 0) break;
                    showHour = 1;
                    showMinute = 1;
                    showSecond = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    seconds += (minutes += (hours += days * 24L) * 60L) * 60L;
                    hours = 0L;
                    minutes = 0L;
                    milliseconds = 0L;
                    break;
                }
                case 5: {
                    showDay = 0;
                    if (showMillisecond != 0) {
                        showMillisecond = 1;
                    }
                    if (showSecond != 0) {
                        showHour = 1;
                        showMinute = 1;
                        showSecond = 1;
                    }
                    seconds += (minutes += (hours += days * 24L) * 60L) * 60L;
                    hours = 0L;
                    minutes = 0L;
                    break;
                }
                case 6: {
                    showDay = 0;
                    showHour = 0;
                    showMinute = 0;
                    showSecond = 0;
                    if (showMillisecond == 0) break;
                    showMillisecond = 1;
                    milliseconds += (seconds += (minutes += (hours += days * 24L) * 60L) * 60L) * 1000L;
                    hours = 0L;
                    minutes = 0L;
                    seconds = 0L;
                }
            }
        } else {
            if (showDay == 0) {
                hours += days * 24L;
                days = 0L;
            }
            if (showHour == 0) {
                minutes += hours * 60L;
                hours = 0L;
            }
            if (showMinute == 0) {
                seconds += minutes * 60L;
                minutes = 0L;
            }
            if ((showMinute != 0 || showHour != 0 || showDay != 0) && (showMillisecond >= 1 || showMillisecond < 0 && milliseconds != 0L) && showSecond == 0) {
                showSecond = 1;
            }
            if (showSecond == 0 && showMinute == 0 && showHour == 0 && showDay == 0) {
                milliseconds += seconds * 1000L;
                seconds = 0L;
            }
        }
        int defaultMinNumberOfIntDigits = 0;
        String tempStr = "";
        if (showDay != 0) {
            defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
            if (showDay == 2 || showDay == 3 || showDay == 7) {
                switch (showDay) {
                    case 2: {
                        this.m_NumericFormat.setMinimumIntegerDigits(1);
                        break;
                    }
                    case 3: {
                        this.m_NumericFormat.setMinimumIntegerDigits(2);
                        break;
                    }
                    case 7: {
                        this.m_NumericFormat.setMinimumIntegerDigits(3);
                    }
                }
            }
            tempStr = this.m_NumericFormat.format(days);
            theFormattedValue = theFormattedValue + tempStr;
            this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
        }
        if (showHour != 0 || showMinute != 0 || showSecond != 0 || showMillisecond != 0) {
            if (showDay != 0) {
                theFormattedValue = theFormattedValue + SPACE_SEPARATOR;
            }
            if (showHour != 0) {
                defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
                if (showHour < 0 || showHour == 1) {
                    this.m_NumericFormat.setMinimumIntegerDigits(2);
                } else if (showHour == 2 || showHour == 3) {
                    this.m_NumericFormat.setMinimumIntegerDigits(showHour - 1);
                }
                tempStr = this.m_NumericFormat.format(hours);
                theFormattedValue = theFormattedValue + tempStr;
                this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
            } else if (showDay != 0 && (showMinute != 0 || showSecond != 0 || showMillisecond != 0)) {
                theFormattedValue = theFormattedValue + "00";
            }
            if (showMinute != 0) {
                if (showHour != 0 || showDay != 0) {
                    theFormattedValue = theFormattedValue + m_timeSeparator;
                }
                defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
                if (showMinute < 0 || showMinute == 1) {
                    this.m_NumericFormat.setMinimumIntegerDigits(2);
                } else if (showMinute == 2 || showMinute == 3) {
                    this.m_NumericFormat.setMinimumIntegerDigits(showMinute - 1);
                }
                tempStr = this.m_NumericFormat.format(minutes);
                theFormattedValue = theFormattedValue + tempStr;
                this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
            } else if (!(showDay == 0 && showHour == 0 || showSecond == 0 && showMillisecond == 0)) {
                theFormattedValue = theFormattedValue + m_timeSeparator;
                theFormattedValue = theFormattedValue + "00";
            }
            if (showSecond != 0) {
                if (showMinute != 0 || showHour != 0 || showDay != 0) {
                    theFormattedValue = theFormattedValue + m_timeSeparator;
                }
                defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
                if (showSecond < 0 || showSecond == 1) {
                    this.m_NumericFormat.setMinimumIntegerDigits(2);
                } else if (showSecond == 2 || showSecond == 3) {
                    this.m_NumericFormat.setMinimumIntegerDigits(showSecond - 1);
                }
                tempStr = this.m_NumericFormat.format(seconds);
                theFormattedValue = theFormattedValue + tempStr;
                this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
            } else if ((showDay != 0 || showHour != 0 || showMinute != 0) && showMillisecond != 0) {
                theFormattedValue = theFormattedValue + m_timeSeparator;
                theFormattedValue = theFormattedValue + "00";
            }
            if (showMillisecond >= 1 || showMillisecond < 0 && milliseconds != 0L) {
                if (showSecond != 0 || showMinute != 0 || showHour != 0 || showDay != 0) {
                    char decimSep = this.m_NumericFormat.getDecimalSeparator();
                    theFormattedValue = theFormattedValue + decimSep;
                }
                defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
                if (showMillisecond < 0 || showMillisecond == 1 || showMillisecond == 7) {
                    this.m_NumericFormat.setMinimumIntegerDigits(3);
                } else if (showMillisecond == 2) {
                    this.m_NumericFormat.setMinimumIntegerDigits(showMillisecond - 1);
                    milliseconds /= 100L;
                } else if (showMillisecond == 3) {
                    this.m_NumericFormat.setMinimumIntegerDigits(showMillisecond - 1);
                    milliseconds /= 10L;
                }
                tempStr = this.m_NumericFormat.format(milliseconds);
                theFormattedValue = theFormattedValue + tempStr;
                this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
            }
        }
        boolean intervalIsZero = true;
        if (days != 0L && showDay != 0) {
            intervalIsZero = false;
        } else if (hours != 0L && showHour != 0) {
            intervalIsZero = false;
        } else if (minutes != 0L && showMinute != 0) {
            intervalIsZero = false;
        } else if (seconds != 0L && showSecond != 0) {
            intervalIsZero = false;
        } else if (milliseconds != 0L && showMillisecond != 0) {
            intervalIsZero = false;
        }
        if (!intervalIsZero) {
            theFormattedValue = this.addIntervalSign(interval.getIsNegative(), theFormattedValue);
        }
        return theFormattedValue;
    }

    private String formatLongDHMSM(IntervalDHMSM interval, IntervalFormatDTType type) {
        String theFormattedValue = "";
        long days = interval.getDay();
        long hours = interval.getHour();
        long minutes = interval.getMinute();
        long seconds = interval.getSecond();
        long milliseconds = interval.getMillisecond();
        int showDay = settings[I18NIntervalElements.DAY.ordinal()];
        int showHour = settings[I18NIntervalElements.HOUR.ordinal()];
        int showMinute = settings[I18NIntervalElements.MINUTE.ordinal()];
        int showSecond = settings[I18NIntervalElements.SECOND.ordinal()];
        int showMillisecond = settings[I18NIntervalElements.MILLISECOND.ordinal()];
        if (showDay == 0 && showHour == 0 && showMinute == 0 && showSecond == 0 && showMillisecond == 0) {
            return theFormattedValue;
        }
        long extra = 0L;
        if (milliseconds >= 1000L && (showDay != 0 || showHour != 0 || showMinute != 0 || showSecond != 0)) {
            extra = milliseconds / 1000L;
            seconds += extra;
            milliseconds -= extra * 1000L;
        }
        if (seconds >= 60L && (showDay != 0 || showHour != 0 || showMinute != 0)) {
            extra = seconds / 60L;
            minutes += extra;
            seconds -= extra * 60L;
        }
        if (minutes >= 60L && (showDay != 0 || showHour != 0)) {
            extra = minutes / 60L;
            hours += extra;
            minutes -= extra * 60L;
        }
        if (hours >= 24L && showDay != 0) {
            extra = hours / 24L;
            days += extra;
            hours -= extra * 24L;
        }
        int[] tempSetting = new int[I18NIntervalElements.ELEMENT_COUNT.ordinal()];
        for (int i = I18NIntervalElements.YEAR.ordinal(); i < I18NIntervalElements.ELEMENT_COUNT.ordinal(); ++i) {
            tempSetting[i] = settings[i];
        }
        if (type != IntervalFormatDTType.FORMAT_DTTYPE_DEFAULT) {
            tempSetting[I18NIntervalElements.DAY.ordinal()] = 0;
            tempSetting[I18NIntervalElements.HOUR.ordinal()] = 0;
            tempSetting[I18NIntervalElements.MINUTE.ordinal()] = 0;
            tempSetting[I18NIntervalElements.SECOND.ordinal()] = 0;
            tempSetting[I18NIntervalElements.MILLISECOND.ordinal()] = 0;
            switch (type.ordinal()) {
                case 1: {
                    if (showDay == 0) break;
                    tempSetting[I18NIntervalElements.DAY.ordinal()] = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    if (seconds >= 30L) {
                        ++minutes;
                    }
                    if (minutes >= 30L) {
                        ++hours;
                    }
                    if (hours < 12L) break;
                    ++days;
                    break;
                }
                case 2: {
                    if (showHour == 0) break;
                    tempSetting[I18NIntervalElements.HOUR.ordinal()] = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    if (seconds >= 30L) {
                        ++minutes;
                    }
                    if (minutes >= 30L) {
                        ++hours;
                    }
                    hours += days * 24L;
                    break;
                }
                case 3: {
                    if (showMinute == 0) break;
                    tempSetting[I18NIntervalElements.MINUTE.ordinal()] = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    if (seconds >= 30L) {
                        ++minutes;
                    }
                    minutes += (hours += days * 24L) * 60L;
                    break;
                }
                case 4: {
                    if (showSecond == 0) break;
                    tempSetting[I18NIntervalElements.SECOND.ordinal()] = 1;
                    if (milliseconds >= 500L) {
                        ++seconds;
                    }
                    seconds += (minutes += (hours += days * 24L) * 60L) * 60L;
                    break;
                }
                case 5: {
                    if (showSecond != 0) {
                        tempSetting[I18NIntervalElements.SECOND.ordinal()] = 1;
                    }
                    if (showMillisecond != 0) {
                        tempSetting[I18NIntervalElements.MILLISECOND.ordinal()] = 1;
                    }
                    seconds += (minutes += (hours += days * 24L) * 60L) * 60L;
                    break;
                }
                case 6: {
                    if (showMillisecond == 0) break;
                    tempSetting[I18NIntervalElements.MILLISECOND.ordinal()] = 1;
                    milliseconds += (seconds += (minutes += (hours += days * 24L) * 60L) * 60L) * 1000L;
                }
            }
        } else {
            if (showDay == 0) {
                hours += days * 24L;
            }
            if (showHour == 0) {
                minutes += hours * 60L;
            }
            if (showMinute == 0) {
                seconds += minutes * 60L;
            }
            if ((showMinute != 0 || showHour != 0 || showDay != 0) && (showMillisecond >= 1 || showMillisecond < 0 && milliseconds != 0L) && showSecond == 0) {
                showSecond = 1;
            }
            if (showSecond == 0 && showMinute == 0 && showHour == 0 && showDay == 0) {
                milliseconds += seconds * 1000L;
            }
        }
        int defaultMinNumberOfIntDigits = this.m_NumericFormat.getMinimumIntegerDigits();
        long paramToUse = 0L;
        String mapKeyToUse = "";
        String word = "";
        String number = "";
        for (int i = I18NIntervalElements.DAY.ordinal(); i < I18NIntervalElements.ELEMENT_COUNT.ordinal(); ++i) {
            switch (i) {
                case 2: {
                    paramToUse = days;
                    mapKeyToUse = "DAY_COMPLETE_";
                    break;
                }
                case 3: {
                    paramToUse = hours;
                    mapKeyToUse = "HOUR_COMPLETE_";
                    break;
                }
                case 4: {
                    paramToUse = minutes;
                    mapKeyToUse = "MINUTE_COMPLETE_";
                    break;
                }
                case 5: {
                    paramToUse = seconds;
                    mapKeyToUse = "SECOND_COMPLETE_";
                    break;
                }
                case 6: {
                    paramToUse = milliseconds;
                    mapKeyToUse = "MILLISECOND_COMPLETE_";
                }
            }
            if (tempSetting[i] == 0) continue;
            if (tempSetting[i] == 2 || tempSetting[i] == 3 || tempSetting[i] == 7) {
                switch (tempSetting[i]) {
                    case 2: {
                        this.m_NumericFormat.setMinimumIntegerDigits(1);
                        break;
                    }
                    case 3: {
                        this.m_NumericFormat.setMinimumIntegerDigits(2);
                        break;
                    }
                    case 7: {
                        this.m_NumericFormat.setMinimumIntegerDigits(3);
                    }
                }
            }
            if (theFormattedValue.length() != 0) {
                theFormattedValue = theFormattedValue + m_secondSeparator;
            }
            if (paramToUse < 0L) {
                paramToUse = Math.abs(paramToUse);
            }
            number = this.m_NumericFormat.format(paramToUse);
            mapKeyToUse = paramToUse == 1L ? mapKeyToUse + "SINGULAR" : (paramToUse >= 2L && paramToUse <= 4L ? mapKeyToUse + "PLURAL2" : mapKeyToUse + "PLURAL");
            word = m_I18NMapOfStringString.get(mapKeyToUse);
            theFormattedValue = theFormattedValue + number + m_firstSeparator + word;
            this.m_NumericFormat.setMinimumIntegerDigits(defaultMinNumberOfIntDigits);
        }
        boolean intervalIsZero = true;
        if (days != 0L && tempSetting[I18NIntervalElements.DAY.ordinal()] != 0) {
            intervalIsZero = false;
        } else if (hours != 0L && tempSetting[I18NIntervalElements.HOUR.ordinal()] != 0) {
            intervalIsZero = false;
        } else if (minutes != 0L && tempSetting[I18NIntervalElements.MINUTE.ordinal()] != 0) {
            intervalIsZero = false;
        } else if (seconds != 0L && tempSetting[I18NIntervalElements.SECOND.ordinal()] != 0) {
            intervalIsZero = false;
        } else if (milliseconds != 0L && tempSetting[I18NIntervalElements.MILLISECOND.ordinal()] != 0) {
            intervalIsZero = false;
        }
        if (!intervalIsZero) {
            theFormattedValue = this.addIntervalSign(interval.getIsNegative(), theFormattedValue);
        }
        return theFormattedValue;
    }

    private static enum I18NIntervalElements {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND,
        ELEMENT_COUNT;

    }

    public static enum IntervalFormatDTType {
        FORMAT_DTTYPE_DEFAULT,
        FORMAT_AS_DAYS,
        FORMAT_AS_HOURS,
        FORMAT_AS_MINUTES,
        FORMAT_AS_SECONDS,
        FORMAT_AS_SECONDS_AND_MILLISECONDS,
        FORMAT_AS_MILLISECONDS;

    }

    public static enum IntervalFormatStyle {
        SHORT_INTERVAL,
        LONG_INTERVAL;

    }
}

