/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.i18n.util;

import com.cognos.i18n.ToolkitResources;
import com.ibm.cognos.i18n.util.Bidi;
import com.ibm.cognos.i18n.util.ShapingException;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.util.ULocale;

public class NumericShape {
    private ULocale m_locale;
    private char m_zeroDigit;
    private static final String arLocale = "ar";
    private static final String ltrDirection = "ltr";
    private static final String rtlDirection = "rtl";
    private static final char defaultDigit = '0';

    public NumericShape() {
        this.m_locale = ULocale.getDefault();
        this.m_zeroDigit = ToolkitResources.getZeroDigit(this.m_locale.getName()).charValue();
    }

    public NumericShape(ULocale locale) {
        this.m_locale = locale;
        this.m_zeroDigit = ToolkitResources.getZeroDigit(this.m_locale.getName()).charValue();
    }

    public String shape(String input, DigitShapeType digitSubsType, String btd) throws ShapingException {
        if (this.m_locale.getLanguage().equals(arLocale) && this.m_zeroDigit != '0') {
            boolean isRtl = false;
            isRtl = btd.equals(rtlDirection) ? true : (btd.equals(ltrDirection) ? false : Bidi.isRTLText(input, this.m_locale.getLanguage()));
            if (digitSubsType == DigitShapeType.DIGIT_SHAPE_NONE) {
                return this.shapeArabic(input, digitSubsType, isRtl);
            }
            String output = this.shapeArabic(input, digitSubsType, isRtl);
            return Bidi.handleBidiFraction(output, isRtl);
        }
        return this.shapeNonArabic(input, digitSubsType);
    }

    public String shape(String input, DigitShapeType digitSubsType) throws ShapingException {
        if (this.m_locale.getLanguage().equals(arLocale) && this.m_zeroDigit != '0') {
            if (digitSubsType == DigitShapeType.DIGIT_SHAPE_NONE) {
                return this.shapeArabic(input, digitSubsType, false);
            }
            String output = this.shapeArabic(input, digitSubsType, false);
            return Bidi.handleBidiFraction(output, false);
        }
        return this.shapeNonArabic(input, digitSubsType);
    }

    protected String shapeNonArabic(String input, DigitShapeType digitSubsType) {
        if (digitSubsType == DigitShapeType.DIGIT_SHAPE_NATIONAL && this.m_zeroDigit != '0') {
            char[] output = new char[input.length()];
            for (int i = 0; i < input.length(); ++i) {
                if (Character.isDigit(input.charAt(i))) {
                    char temp = this.m_zeroDigit;
                    output[i] = temp = (char)(temp + Character.getNumericValue(input.charAt(i)));
                    continue;
                }
                output[i] = input.charAt(i);
            }
            return new String(output);
        }
        return input;
    }

    protected String shapeArabic(String input, DigitShapeType digitSubsType, boolean isRtl) throws ShapingException {
        int options;
        char[] inputCharBuf = input.toCharArray();
        int inputLength = inputCharBuf.length;
        char[] outputCharBuf = new char[inputLength];
        if (digitSubsType == DigitShapeType.DIGIT_SHAPE_CONTEXTUAL) {
            options = isRtl ? 128 : 96;
        } else if (digitSubsType == DigitShapeType.DIGIT_SHAPE_NATIONAL) {
            options = 32;
        } else if (digitSubsType == DigitShapeType.DIGIT_SHAPE_NONE) {
            options = 64;
        } else {
            return input;
        }
        ArabicShaping shaper = new ArabicShaping(options);
        try {
            shaper.shape(inputCharBuf, 0, inputLength, outputCharBuf, 0, inputLength);
            return new String(outputCharBuf);
        }
        catch (ArabicShapingException e) {
            String msg = ShapingException.getMethodSignature(this.getClass(), "shapeArabic");
            throw new ShapingException((Exception)((Object)e), msg);
        }
    }

    public static enum DigitShapeType {
        DIGIT_SHAPE_NATIONAL,
        DIGIT_SHAPE_CONTEXTUAL,
        DIGIT_SHAPE_NONE;

    }
}

