/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.testing;

import com.ibm.bi.config.external.PropertiesReader;
import com.ibm.bi.config.setup.CogLocaleConfiguration;
import com.ibm.bi.config.setup.CogstartupConfiguration;
import com.ibm.bi.config.setup.ConfigurationSourceFactoryInt;
import java.io.File;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.configuration.ConfigurationException;

public class TestConfigurationSourceFactory
implements ConfigurationSourceFactoryInt {
    private URL testCogstartupUrl;
    private URL testCogLocaleUrl;
    private URL testPropertiesURL;
    private String testMetadataPath;
    private PropertiesReader propertiesReader;
    private final ScheduledExecutorService executorService;
    private File tempDir;

    public TestConfigurationSourceFactory(File tempDir, ScheduledExecutorService executorService) {
        this.tempDir = tempDir;
        this.executorService = executorService;
    }

    public void setCogstartupUrl(URL url) {
        this.testCogstartupUrl = url;
    }

    public void setCogLocaleUrl(URL cogLocaleUrl) {
        this.testCogLocaleUrl = cogLocaleUrl;
    }

    public void setPropertiesURL(URL propertiesURL) {
        this.testPropertiesURL = propertiesURL;
    }

    public void setMetadataPath(String path) {
        this.testMetadataPath = path;
    }

    @Override
    public CogLocaleConfiguration getCogLocaleConfiguration() throws ConfigurationException {
        return new CogLocaleConfiguration(this.testCogLocaleUrl);
    }

    @Override
    public CogstartupConfiguration getCogstartupConfiguration() throws ConfigurationException {
        return new CogstartupConfiguration(this.testCogstartupUrl);
    }

    @Override
    public URL getDispatcherPropertiesFilename() {
        return this.testPropertiesURL;
    }

    @Override
    public String getMetadataPath() {
        return this.testMetadataPath;
    }

    public PropertiesReader getPropertiesReader() {
        if (this.propertiesReader == null) {
            this.propertiesReader = new PropertiesReader(this.tempDir, this.executorService);
        }
        return this.propertiesReader;
    }
}

