/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DisputedTerritoriesUnit {
    private static final LocationIndexer indexer = LocationIndexer.getInstance();
    private LocationEntry entryChina = indexer.getLocation(indexer.getLocationIds("China").get(0));
    private LocationEntry entryTaiwan = indexer.getLocation(indexer.getLocationIds("Taiwan").get(0));
    private LocationEntry entryHongKong = indexer.getLocation(indexer.getLocationIds("Hong Kong").get(0));
    private LocationEntry entryMacao = indexer.getLocation(indexer.getLocationIds("Macao").get(0));
    private LocationEntry entryIsrael = indexer.getLocation(indexer.getLocationIds("Israel").get(0));
    private LocationEntry entryWestBank = indexer.getLocation(indexer.getLocationIds("West Bank").get(0));
    private LocationEntry entryJammuAndKashmir = indexer.getLocation(indexer.getLocationIds("Jammu and Kashmir").get(0));
    private LocationEntry entryPakistan = indexer.getLocation(indexer.getLocationIds("Pakistan").get(0));
    private LocationEntry entryIndia = indexer.getLocation(indexer.getLocationIds("India").get(0));
    private LocationEntry entryNorthernAreas = indexer.getLocation(indexer.getLocationIds("Northern Areas").get(0));

    void processDisputedTerritories(JSONObject geoJSON, List<LocationIndexer.DisputedTerritories> dTerritories) {
        if (dTerritories.isEmpty()) {
            this.processChina(geoJSON, dTerritories);
            this.processIndiaPakistan(geoJSON, dTerritories);
            return;
        }
        if (!dTerritories.contains((Object)LocationIndexer.DisputedTerritories.TaiwanPrecedence)) {
            this.processChina(geoJSON, dTerritories);
        }
        if (dTerritories.contains((Object)LocationIndexer.DisputedTerritories.IsraelPrecedence)) {
            String[] maps = new String[]{"World", "Asia", "Western Asia"};
            String mapName = (String)geoJSON.get((Object)"mapName");
            if (Arrays.asList(maps).contains(mapName)) {
                this.changeParent(geoJSON, this.entryWestBank, this.entryIsrael);
            }
        }
        this.processIndiaPakistan(geoJSON, dTerritories);
    }

    private void processChina(JSONObject map, List<LocationIndexer.DisputedTerritories> dTerritories) {
        String[] maps = new String[]{"World", "Asia", "Eastern Asia", "China"};
        String mapName = (String)map.get((Object)"mapName");
        if (!Arrays.asList(maps).contains(mapName)) {
            return;
        }
        if (!mapName.equals("China")) {
            JSONObject featureChina = this.getFeatureForName((JSONObject)map.get((Object)"geojson"), this.entryChina);
            if (featureChina != null) {
                this.changeParent(map, this.entryHongKong, this.entryChina);
                this.changeParent(map, this.entryMacao, this.entryChina);
                if (!dTerritories.contains((Object)LocationIndexer.DisputedTerritories.TaiwanPrecedence)) {
                    this.changeParent(map, this.entryTaiwan, this.entryChina);
                }
            }
        } else {
            LocationEntry entryEastAsia = indexer.getLocation(indexer.getLocationIds("Eastern Asia").get(0));
            JSONObject geoJSON = null;
            JSONObject mapGeojson = (JSONObject)map.get((Object)"geojson");
            JSONArray features = (JSONArray)mapGeojson.get((Object)"features");
            JSONObject propObj = null;
            try {
                JSONObject featureTaiwan;
                JSONObject featureMacao;
                geoJSON = JSONObject.parse((String)entryEastAsia.getGeoJSON());
                JSONObject featureHongKong = this.getFeatureForName(geoJSON, this.entryHongKong);
                if (featureHongKong != null) {
                    propObj = (JSONObject)featureHongKong.get((Object)"properties");
                    propObj.remove((Object)"pop");
                    propObj.remove((Object)"SUBREGION");
                    propObj.put((Object)"ADMIN", (Object)"China");
                    features.add((Object)featureHongKong);
                }
                if ((featureMacao = this.getFeatureForName(geoJSON, this.entryMacao)) != null) {
                    propObj = (JSONObject)featureMacao.get((Object)"properties");
                    propObj.remove((Object)"pop");
                    propObj.remove((Object)"SUBREGION");
                    propObj.put((Object)"ADMIN", (Object)"China");
                    features.add((Object)featureMacao);
                }
                if (!dTerritories.contains((Object)LocationIndexer.DisputedTerritories.TaiwanPrecedence) && (featureTaiwan = this.getFeatureForName(geoJSON, this.entryTaiwan)) != null) {
                    propObj = (JSONObject)featureTaiwan.get((Object)"properties");
                    propObj.remove((Object)"pop");
                    propObj.remove((Object)"SUBREGION");
                    propObj.put((Object)"ADMIN", (Object)"China");
                    features.add((Object)featureTaiwan);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void processIndiaPakistan(JSONObject geoJSON, List<LocationIndexer.DisputedTerritories> dTerritories) {
        String[] maps = new String[]{"World", "Asia", "Southern Asia"};
        String mapName = (String)geoJSON.get((Object)"mapName");
        if (!Arrays.asList(maps).contains(mapName)) {
            return;
        }
        if (dTerritories.contains((Object)LocationIndexer.DisputedTerritories.PakistanPrecedence)) {
            try {
                this.addArea(geoJSON, this.entryJammuAndKashmir, this.entryPakistan);
                JSONObject featureIndia = this.getFeatureForName((JSONObject)geoJSON.get((Object)"geojson"), this.entryIndia);
                if (featureIndia == null) {
                    return;
                }
                List<Integer> idsIndia = indexer.getLocationIds("India");
                String stringGeoJSONIndia = indexer.getLocation(idsIndia.get(0)).getGeoJSON();
                JSONObject geoJSONIndia = JSONObject.parse((String)stringGeoJSONIndia);
                JSONObject geometryObjIndia = (JSONObject)featureIndia.get((Object)"geometry");
                JSONArray coordinatesObjArrIndia = (JSONArray)geometryObjIndia.get((Object)"coordinates");
                JSONArray polygonIndiaArr = null;
                JSONArray polygonIndia = null;
                int ind1 = 17;
                int ind2 = 27;
                int size = coordinatesObjArrIndia.size();
                polygonIndiaArr = (JSONArray)coordinatesObjArrIndia.get(size - 1);
                polygonIndia = (JSONArray)polygonIndiaArr.get(0);
                JSONArray newPolygonIndia = new JSONArray();
                int lenP = polygonIndia.size();
                for (int i = ind1; i < lenP - ind2; ++i) {
                    newPolygonIndia.add(polygonIndia.get(i));
                }
                JSONObject featureJammuKashmir = this.getFeatureForName(geoJSONIndia, this.entryJammuAndKashmir);
                JSONObject geometryObjJammuKashmir = (JSONObject)featureJammuKashmir.get((Object)"geometry");
                JSONArray coordinatesObjArrJammuKashmir = (JSONArray)geometryObjJammuKashmir.get((Object)"coordinates");
                JSONArray polygonJammuKashmirArr = (JSONArray)coordinatesObjArrJammuKashmir.get(0);
                int len = polygonJammuKashmirArr.size();
                for (int i = 180; i < len - 117; ++i) {
                    newPolygonIndia.add(polygonJammuKashmirArr.get(len - i - 1));
                }
                JSONArray newPolygonIndiaArr = new JSONArray();
                newPolygonIndiaArr.add((Object)newPolygonIndia);
                JSONArray newCoordinatesObjArr = new JSONArray();
                newCoordinatesObjArr.add(coordinatesObjArrIndia.get(0));
                newCoordinatesObjArr.add((Object)newPolygonIndiaArr);
                geometryObjIndia.put((Object)"coordinates", (Object)newCoordinatesObjArr);
                featureIndia.put((Object)"geometry", (Object)geometryObjIndia);
                JSONObject featurePakistan = this.getFeatureForName((JSONObject)geoJSON.get((Object)"geojson"), this.entryPakistan);
                if (featurePakistan == null) {
                    return;
                }
                JSONObject geometryObjPakistan = (JSONObject)featurePakistan.get((Object)"geometry");
                JSONArray coordinatesObjArrPakistan = (JSONArray)geometryObjPakistan.get((Object)"coordinates");
                coordinatesObjArrPakistan.add((Object)coordinatesObjArrJammuKashmir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.addArea(geoJSON, this.entryNorthernAreas, this.entryIndia);
                JSONObject featurePakistan = this.getFeatureForName((JSONObject)geoJSON.get((Object)"geojson"), this.entryPakistan);
                if (featurePakistan == null) {
                    return;
                }
                List<Integer> idsPakistan = indexer.getLocationIds("Pakistan");
                String stringGeoJSONPakistan = indexer.getLocation(idsPakistan.get(0)).getGeoJSON();
                JSONObject geoJSONPakistan = JSONObject.parse((String)stringGeoJSONPakistan);
                JSONObject geometryObjPakistan = (JSONObject)featurePakistan.get((Object)"geometry");
                JSONArray coordinatesObjArrPakistan = (JSONArray)geometryObjPakistan.get((Object)"coordinates");
                JSONArray polygonPakistanArr = null;
                JSONArray polygonPakistan = null;
                int ind1 = 20;
                int ind2 = 2;
                polygonPakistanArr = (JSONArray)coordinatesObjArrPakistan.get(0);
                polygonPakistan = (JSONArray)polygonPakistanArr.get(0);
                JSONArray newPolygonPakistan = new JSONArray();
                int lenP = polygonPakistan.size();
                for (int i = ind1; i < lenP - ind2; ++i) {
                    newPolygonPakistan.add(polygonPakistan.get(i));
                }
                JSONObject featureNorthernAreas = this.getFeatureForName(geoJSONPakistan, this.entryNorthernAreas);
                JSONObject geometryObjNorthernAreas = (JSONObject)featureNorthernAreas.get((Object)"geometry");
                JSONArray coordinatesObjArrNorthernAreas = (JSONArray)geometryObjNorthernAreas.get((Object)"coordinates");
                JSONArray polygonNorthernAreasArr = (JSONArray)coordinatesObjArrNorthernAreas.get(0);
                int lenN = polygonNorthernAreasArr.size();
                for (int i = 30; i < 236; ++i) {
                    newPolygonPakistan.add(polygonNorthernAreasArr.get(lenN - i - 1));
                }
                JSONArray newPolygonPakistanArr = new JSONArray();
                newPolygonPakistanArr.add((Object)newPolygonPakistan);
                JSONArray newCoordinatesObjArr = new JSONArray();
                newCoordinatesObjArr.add(coordinatesObjArrPakistan.get(0));
                newCoordinatesObjArr.add((Object)newPolygonPakistanArr);
                geometryObjPakistan.put((Object)"coordinates", (Object)newCoordinatesObjArr);
                featurePakistan.put((Object)"geometry", (Object)geometryObjPakistan);
                JSONObject featureIndia = this.getFeatureForName((JSONObject)geoJSON.get((Object)"geojson"), this.entryIndia);
                if (featureIndia == null) {
                    return;
                }
                JSONObject geometryObjIndia = (JSONObject)featureIndia.get((Object)"geometry");
                JSONArray coordinatesObjArrIndia = (JSONArray)geometryObjIndia.get((Object)"coordinates");
                coordinatesObjArrIndia.add((Object)coordinatesObjArrNorthernAreas);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addArea(JSONObject map, LocationEntry entryToAdd, LocationEntry entryNewParent) {
        JSONObject geoJSON = null;
        LocationEntry oldParentEntry = null;
        if (map.get((Object)"mapName").equals(this.entryIndia.getName()) && entryToAdd.equals(this.entryNorthernAreas)) {
            oldParentEntry = this.entryPakistan;
        } else if (map.get((Object)"mapName").equals(this.entryPakistan.getName()) && entryToAdd.equals(this.entryJammuAndKashmir)) {
            oldParentEntry = this.entryIndia;
        } else {
            return;
        }
        try {
            geoJSON = JSONObject.parse((String)oldParentEntry.getGeoJSON());
            JSONObject movedFeature = this.getFeatureForName(geoJSON, entryToAdd);
            if (movedFeature == null) {
                return;
            }
            JSONObject prop = (JSONObject)movedFeature.get((Object)"properties");
            prop.put((Object)"ADMIN", (Object)entryNewParent.getName());
            JSONObject mapGeojson = (JSONObject)map.get((Object)"geojson");
            JSONArray features = (JSONArray)mapGeojson.get((Object)"features");
            features.add((Object)movedFeature);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void changeParent(JSONObject map, LocationEntry movedEntry, LocationEntry newParentEntry) {
        JSONObject geoJSON = (JSONObject)map.get((Object)"geojson");
        JSONObject movedFeature = this.getFeatureForName(geoJSON, movedEntry);
        if (movedFeature == null) {
            return;
        }
        JSONObject geom1 = (JSONObject)movedFeature.get((Object)"geometry");
        JSONArray coord1 = (JSONArray)geom1.get((Object)"coordinates");
        JSONArray newFeaturesObjArr = new JSONArray();
        JSONArray featuresObjArr = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name = propObj.get((Object)"name").toString();
            if (indexer.equalsNameOrAlias(name, movedEntry)) continue;
            if (indexer.equalsNameOrAlias(name, newParentEntry)) {
                JSONObject geom2 = (JSONObject)featureObj.get((Object)"geometry");
                JSONArray coord2 = (JSONArray)geom2.get((Object)"coordinates");
                if (geom2.get((Object)"type").equals("Polygon")) {
                    geom2.put((Object)"type", (Object)"MultiPolygon");
                    JSONArray coord2arr = new JSONArray();
                    coord2arr.add((Object)coord2);
                    coord2 = coord2arr;
                    geom2.put((Object)"coordinates", (Object)coord2arr);
                }
                int nbLevels = 2;
                JSONArray levels = (JSONArray)coord1.get(0);
                while (levels.get(0) instanceof JSONArray) {
                    levels = (JSONArray)levels.get(0);
                    ++nbLevels;
                }
                if (nbLevels == 4) {
                    coord2.addAll((Collection)coord1);
                } else {
                    coord2.add((Object)coord1);
                }
            }
            newFeaturesObjArr.add((Object)featureObj);
        }
        geoJSON.put((Object)"features", (Object)newFeaturesObjArr);
    }

    public JSONObject getFeatureForName(JSONObject geoJSON, LocationEntry movedEntry) {
        return indexer.getFeatureForName(geoJSON, movedEntry);
    }
}

