/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.model.AmbiguityHandlerPB;
import com.ibm.athena.smartermaps.model.LocationIndexerPB;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GroupsAndAliasesPB {
    private static final LocationIndexerPB indexer = LocationIndexerPB.getInstance();
    private Map<String, List<Integer>> groups = new HashMap<String, List<Integer>>();

    public JSONObject addAliases(String path) {
        JSONObject errorsObject = new JSONObject();
        File file = new File(path);
        try {
            FileInputStream fis = new FileInputStream(file);
            return this.addAliases(fis);
        }
        catch (FileNotFoundException e) {
            errorsObject.put((Object)"errors", (Object)("file not found " + file.getAbsolutePath()));
            return errorsObject;
        }
    }

    public JSONObject addAliases(InputStream inputStream) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(InputStream inputStream) {
        String fileContent = "";
        StringBuffer fileContentB = new StringBuffer();
        int MAX_SIZE = 200000;
        char[] buffer = new char[200000];
        BufferedReader reader = null;
        try {
            int nb;
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            do {
                if ((nb = reader.read(buffer, 0, 200000)) < 200000) {
                    fileContentB.append(String.valueOf(buffer).substring(0, nb));
                    continue;
                }
                fileContentB.append(buffer);
            } while (nb == 200000);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        fileContent = fileContentB.toString().trim();
        return fileContent;
    }

    public JSONObject addGroups(String path) {
        JSONObject errorsObject = new JSONObject();
        File file = new File(path);
        try {
            FileInputStream is = new FileInputStream(file);
            return this.addGroups(is);
        }
        catch (FileNotFoundException e) {
            errorsObject.put((Object)"errors", (Object)("file not found " + file.getAbsolutePath()));
            return errorsObject;
        }
    }

    public JSONObject addGroups(InputStream inputStream) {
        JSONObject errorsObject = new JSONObject();
        JSONArray errors = new JSONArray();
        String fileContent = this.readFile(inputStream);
        if (fileContent == null) {
            errors.add((Object)" Input Stream not found");
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        StringTokenizer fileTokenizer = new StringTokenizer(fileContent, "\n");
        String line = null;
        while (fileTokenizer.hasMoreElements()) {
            line = (String)fileTokenizer.nextElement();
            StringTokenizer st = new StringTokenizer(line, ",");
            String groupName = (String)st.nextElement();
            groupName = groupName.trim();
            ArrayList<String> groupElements = new ArrayList<String>();
            while (st.hasMoreElements()) {
                String element = st.nextToken().trim();
                groupElements.add(element.trim());
            }
            this.addGroup(groupName, groupElements);
        }
        if (!errors.isEmpty()) {
            errorsObject.put((Object)"errors", (Object)errors);
        }
        return errorsObject;
    }

    public Map<String, List<Integer>> getGroups() {
        return this.groups;
    }

    public JSONObject addGroup(String groupName, List<String> groupElements) {
        JSONObject errorsObject = new JSONObject();
        JSONArray errors = new JSONArray();
        if (groupElements.isEmpty()) {
            errors.add((Object)("No content for the group: " + groupName));
        }
        if (!errors.isEmpty()) {
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        StringBuffer err = new StringBuffer();
        HashSet<ISMLocation> newGroupElements = new HashSet<ISMLocation>();
        for (int i = 0; i < groupElements.size(); ++i) {
            String name = groupElements.get(i);
            if (indexer.getLocationIdsForName(name) == null) continue;
            newGroupElements.add(new SMLocation(name));
        }
        if (newGroupElements.isEmpty()) {
            err.append("Group:" + groupName + " contains no valid name");
        }
        if (err.length() != 0) {
            errors.add((Object)err.toString());
        }
        if (!errors.isEmpty()) {
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        AmbiguityHandlerPB ambiguityHandler = new AmbiguityHandlerPB();
        ambiguityHandler.setIndexer(indexer);
        Integer ancestorId = indexer.getNearestCommonAncestorIdForLocations(newGroupElements);
        JSONObject ambiguityResult = ambiguityHandler.processAmbiguousList(newGroupElements, ancestorId);
        String errors2 = (String)ambiguityResult.get((Object)"errors");
        if (errors2 != null && errors2.length() > 0) {
            errors.add(ambiguityResult.get((Object)"errors"));
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        JSONObject resolvedIds = (JSONObject)ambiguityResult.get((Object)"resolvedIds");
        ArrayList<Integer> locIds = new ArrayList<Integer>();
        for (ISMLocation iLocation : newGroupElements) {
            List<Integer> ids = indexer.getLocationIds(iLocation);
            if (!ambiguityHandler.isAmbiguous(iLocation.getName())) {
                locIds.add(ids.get(0));
                continue;
            }
            Integer id = (Integer)resolvedIds.get((Object)iLocation.getName());
            locIds.add(id);
        }
        this.groups.put(groupName, locIds);
        return errorsObject;
    }
}

