/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.SmarterMaps;
import com.ibm.athena.smartermaps.SmarterMapsResult;
import java.util.Properties;

public class LogUtil {
    public static void logException(Exception e, String msg, SmarterMapsResult result) {
        result.setStatus(SmarterMaps.Status.FAILURE);
        if (e.getMessage() != null) {
            result.setFailureMessage(msg + e.getMessage());
        }
        LogUtil.logMsg(msg);
        e.printStackTrace();
    }

    public static void logMsg(String msg) {
        LogUtil.logIsMappableMsg(msg, null, null);
    }

    public static void logIsMappableMsg(String msg, String dataItemName) {
        LogUtil.logIsMappableMsg(msg, dataItemName, null);
    }

    public static void logIsMappableMsg(String msg, String dataItemName, Properties properties) {
        if (msg == null) {
            return;
        }
        if (dataItemName != null) {
            msg = msg + "data item : " + dataItemName;
        }
        if (properties != null) {
            if (properties.getProperty("datasetName") != null) {
                msg = msg + " dataset : " + properties.getProperty("datasetName");
            }
            if (properties.getProperty("userId") != null) {
                msg = msg + " userId : " + properties.getProperty("userId");
            }
        }
    }
}

