/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.ISMLocation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class SMLocation
implements ISMLocation {
    private String name = null;
    private List<ISMLocation> ancestryLocations = null;
    private boolean useAsAncestor = true;

    public SMLocation(String name) {
        this.name = name;
    }

    public SMLocation(String name, List<ISMLocation> ancestryList) {
        this.name = name;
        this.ancestryLocations = new ArrayList<ISMLocation>(ancestryList.size());
        for (ISMLocation sMLocation : ancestryList) {
            this.ancestryLocations.add(sMLocation);
        }
    }

    public SMLocation(String name, boolean useAsAncestor) {
        this.name = name;
        this.useAsAncestor = useAsAncestor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentName() {
        if (this.ancestryLocations == null || this.ancestryLocations.isEmpty()) {
            return null;
        }
        ISMLocation ancestor = this.ancestryLocations.get(0);
        return ancestor.getName();
    }

    @Override
    public List<ISMLocation> getAncestryLocations() {
        return this.ancestryLocations;
    }

    @Override
    public void setName(String location) {
        this.name = location;
    }

    public boolean equals(Object _other) {
        if (this == _other) {
            return true;
        }
        if (!(_other instanceof SMLocation)) {
            return false;
        }
        SMLocation other = (SMLocation)_other;
        return new EqualsBuilder().append((Object)this.name, (Object)other.name).append(this.ancestryLocations, other.ancestryLocations).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.ancestryLocations).toHashCode();
    }

    public String toString() {
        List<ISMLocation> ancestryLocs = this.getAncestryLocations();
        StringBuffer ancestorNames = new StringBuffer();
        if (ancestryLocs != null) {
            for (int i = ancestryLocs.size() - 1; i >= 0; --i) {
                ISMLocation ancestor = ancestryLocs.get(i);
                ancestorNames.append(ancestor.getName());
                if (!ancestor.isUsedAsAncestor()) {
                    ancestorNames.append("*");
                }
                ancestorNames.append("|");
            }
        }
        return ancestorNames.toString() + this.name;
    }

    @Override
    public boolean isUsedAsAncestor() {
        return this.useAsAncestor;
    }
}

