/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.BoundingRegion;
import com.ibm.athena.smartermaps.DisputedTerritoriesUnit;
import com.ibm.athena.smartermaps.GroupsAndAliases;
import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.ISmarterMaps;
import com.ibm.athena.smartermaps.LogUtil;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.SmarterMapsResult;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.athena.smartermaps.model.MapIndexer;
import com.ibm.athena.smartermaps.util.MapsUtilities;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SmarterMaps
implements ISmarterMaps {
    public static final String CHINA_TAIWAN_PROPERTY = "ChinaTaiwanPrecedence";
    public static final String CHINA = "China";
    public static final String TAIWAN = "Taiwan";
    public static final String INDIA_PAKISTAN_PROPERTY = "IndiaPakistanPrecedence";
    public static final String INDIA = "India";
    public static final String PAKISTAN = "Pakistan";
    public static final String JAMMU_AND_KASHMIR = "Jammu and Kashmir";
    public static final String NORTHERN_AREAS = "Northern Areas";
    public static final String ISRAEL_WEST_BANK_PROPERTY = "IsraelWestBankPrecedence";
    public static final String ISRAEL = "Israel";
    public static final String WESTBANK = "West Bank";
    public static final String WEST_BANK = "West Bank";
    public static final String EASTERN_ASIA = "Eastern Asia";
    private static final String DOMAIN_NAME = "DOMAIN_NAME";
    private static final LocationIndexer indexer = LocationIndexer.getInstance();
    private int confidenceLevel = 80;
    private boolean useMapbox = false;
    private List<LocationIndexer.DisputedTerritories> dTerritories = new ArrayList<LocationIndexer.DisputedTerritories>();
    private String m_domainName;
    private Properties m_properties = new Properties();
    private BoundingRegion boundingRegionUnit = new BoundingRegion();
    private DisputedTerritoriesUnit disputedUnit = new DisputedTerritoriesUnit();
    private GroupsAndAliases groupsAndAliases = new GroupsAndAliases();

    public SmarterMaps() {
    }

    public SmarterMaps(Properties _properties) {
        this();
        this.m_properties = _properties;
        this.setDisputedTerritoriesList();
        this.boundingRegionUnit.setProperties(this.m_properties);
    }

    @Override
    public JSONObject generateSmallestRegion(List<ISMLocation> sMLocations) {
        return this.generateSmallestRegion(sMLocations, null);
    }

    @Override
    public JSONObject generateSmallestRegion(List<ISMLocation> iLocations, String title) {
        if (!this.boundingRegionUnit.isBoundingRegion()) {
            JSONObject map = this.generateSmallestRegion(iLocations, title, false);
            JSONObject geojson = (JSONObject)map.get((Object)"geojson");
            if (geojson == null || geojson.get((Object)Status.FAILURE) != null) {
                return map;
            }
            geojson.remove((Object)"ids");
            return map;
        }
        return this.generateBoundingRegion(iLocations, title);
    }

    public JSONObject generateSmallestRegion(List<ISMLocation> iLocations, String title, boolean boundingRegionFlag) {
        try {
            if (iLocations == null) {
                SmarterMapsResult result = new SmarterMapsResult();
                result.setStatus(Status.FAILURE);
                result.setFailureMessage("Null location list");
                return result.convertToJSON();
            }
            SmarterMapsResult resultingMap = this.getResultingMap(iLocations = this.removeDuplicates(iLocations), title, boundingRegionFlag);
            if (resultingMap.getStatus() == Status.FAILURE) {
                return resultingMap.convertToJSON();
            }
            JSONObject geoJSON = null;
            if (!boundingRegionFlag && (resultingMap.getMapName().equals("Eastern Europe") || resultingMap.getMapName().equals("Europe"))) {
                geoJSON = resultingMap.getGeoJSON();
                if (iLocations.size() == 1 && iLocations.get(0).getName().equals("Russia")) {
                    List<Integer> locIds = indexer.getLocationIds("Russia");
                    LocationEntry entryRussia = indexer.getLocation(locIds.get(0));
                    JSONObject featureRussiaEurope = indexer.getFeatureForName(geoJSON, entryRussia);
                    String jsonWorldString = indexer.getLocation(1).getGeoJSON();
                    JSONObject jsonWorld = null;
                    try {
                        jsonWorld = JSONObject.parse((String)jsonWorldString);
                    }
                    catch (IOException e) {
                        return resultingMap.convertToJSON();
                    }
                    JSONObject featureRussiaWorld = indexer.getFeatureForName(jsonWorld, entryRussia);
                    featureRussiaEurope.put((Object)"geometry", featureRussiaWorld.get((Object)"geometry"));
                    return resultingMap.convertToJSON();
                }
                List<Integer> ids = indexer.getLocationIds("Russia");
                LocationEntry entry = indexer.getLocation(ids.get(0));
                boolean withRussia = false;
                for (ISMLocation sMLocation : iLocations) {
                    if (!indexer.equalsNameOrAlias(sMLocation.getName(), entry)) continue;
                    withRussia = true;
                    break;
                }
                if (!withRussia) {
                    return this.performGenerateBoundingRegion(iLocations, resultingMap.convertToJSON());
                }
            }
            if ((geoJSON = resultingMap.convertToJSON()) != null) {
                this.disputedUnit.processDisputedTerritories(geoJSON, this.dTerritories);
            }
            return geoJSON;
        }
        catch (Exception e) {
            SmarterMapsResult result = new SmarterMapsResult();
            LogUtil.logException(e, "SmarterMaps::SmarterMaps::generateSmallestRegion(): ", result);
            return result.convertToJSON();
        }
    }

    public List<ISMLocation> removeDuplicates(List<ISMLocation> iLocations) {
        ArrayList<ISMLocation> resultList = new ArrayList<ISMLocation>();
        HashSet<ISMLocation> resultSet = new HashSet<ISMLocation>();
        resultSet.addAll(iLocations);
        resultList.addAll(resultSet);
        return resultList;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations) {
        return this.generateBoundingRegion(sMLocations, null);
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, String title) {
        try {
            boolean boundingFlag = true;
            JSONObject smallestRegion = this.generateSmallestRegion(sMLocations, title, boundingFlag);
            String status = (String)smallestRegion.get((Object)"status");
            if (status != null && !status.equals(Status.FAILURE.getName())) {
                JSONObject geojson = (JSONObject)smallestRegion.get((Object)"geojson");
                if (geojson == null || geojson.get((Object)Status.FAILURE) != null) {
                    return smallestRegion;
                }
                geojson.remove((Object)"ids");
                geojson.remove((Object)"locIds");
                smallestRegion = this.performGenerateBoundingRegion(sMLocations, smallestRegion);
            }
            return smallestRegion;
        }
        catch (Exception e) {
            SmarterMapsResult result = new SmarterMapsResult();
            LogUtil.logException(e, "SmarterMaps::generateBoundingRegion(): ", result);
            return result.convertToJSON();
        }
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        return this.generateBoundingRegion(sMLocations, null, topPercent, bottomPercent, leftPercent, rightPercent);
    }

    private JSONObject performGenerateBoundingRegion(List<ISMLocation> sMLocations, JSONObject smallestRegion, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        try {
            smallestRegion = this.boundingRegionUnit.generateBoundingRegion(sMLocations, smallestRegion, topPercent, bottomPercent, leftPercent, rightPercent);
        }
        catch (Exception e) {
            smallestRegion.put((Object)"status", (Object)Status.FAILURE.getName());
            smallestRegion.put((Object)"failureMessage", (Object)e.getMessage());
        }
        return smallestRegion;
    }

    private JSONObject performGenerateBoundingRegion(List<ISMLocation> iLocations, JSONObject smallestRegion) {
        try {
            smallestRegion = this.boundingRegionUnit.generateBoundingRegion(iLocations, smallestRegion);
        }
        catch (Exception e) {
            smallestRegion.put((Object)"status", (Object)Status.FAILURE.getName());
            smallestRegion.put((Object)"failureMessage", (Object)e.getMessage());
        }
        return smallestRegion;
    }

    private boolean isKnownAncestry(ISMLocation iLocation) {
        List<ISMLocation> ancestryList = iLocation.getAncestryLocations();
        for (ISMLocation location : ancestryList) {
            List<Integer> ids = indexer.getLocationIds(location.getName());
            if (ids != null && !ids.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<Integer> getValidAncestryIds(ISMLocation iLocation, List<LocationIndexer.DisputedTerritories> dTerritories) {
        List<ISMLocation> ancestryList = iLocation.getAncestryLocations();
        List<Integer> ids = indexer.getLocationIds(iLocation.getName());
        for (Integer id : ids) {
            List<Integer> ancestryIds = indexer.getPathToRoot(id, dTerritories);
            int nbMatches = ancestryList.size();
            for (int i = 0; i < ancestryIds.size() - 1; ++i) {
                Integer ancestryId = ancestryIds.get(i);
                String ancestryName = ancestryList.get(nbMatches - 1).getName();
                List<Integer> curLocationIds = indexer.getLocationIds(ancestryName);
                if (!curLocationIds.contains(ancestryId) || --nbMatches != 0) continue;
                return ancestryIds;
            }
        }
        return null;
    }

    private boolean isIdenticalPath(List<Integer> ancestryIds, List<Integer> curIds) {
        if (ancestryIds.size() != curIds.size()) {
            return false;
        }
        for (int i = 0; i < curIds.size(); ++i) {
            if (ancestryIds.get(i) == curIds.get(i)) continue;
            return false;
        }
        return true;
    }

    private SmarterMapsResult getResultingMap(List<ISMLocation> iLocationsInit, String title, boolean boundingRegion) {
        SmarterMapsResult result = new SmarterMapsResult();
        ArrayList<ISMLocation> allLocations = new ArrayList<ISMLocation>();
        ArrayList<String> matchedLocationNames = new ArrayList<String>();
        Map<String, List<Integer>> groups = this.getGroups();
        for (ISMLocation sMLocation : iLocationsInit) {
            String name = sMLocation.getName();
            List<Integer> elements = groups.get(name);
            if (elements != null && !elements.isEmpty()) {
                for (int i = 0; i < elements.size(); ++i) {
                    LocationEntry entry = indexer.getLocation(elements.get(i));
                    String elementName = entry.getName();
                    Integer parentId = entry.getFirstParentId();
                    String parentName = indexer.getLocation(parentId).getName();
                    ArrayList<ISMLocation> ancestryList = new ArrayList<ISMLocation>();
                    ancestryList.add(new SMLocation(parentName));
                    SMLocation iLocation = new SMLocation(elementName, ancestryList);
                    allLocations.add(iLocation);
                }
                continue;
            }
            allLocations.add(sMLocation);
        }
        int unmatchedCount = 0;
        for (ISMLocation sMLocation : allLocations) {
            String name = sMLocation.getName();
            List<Integer> ids = this.getLocationIds(sMLocation, result);
            if (ids == null || ids.size() == 0) {
                result.addUnmatchedName(sMLocation.getName());
                ++unmatchedCount;
                continue;
            }
            matchedLocationNames.add(name);
            Integer id = null;
            if (ids.size() == 1) {
                id = ids.get(0);
                result.addUniqueLocation(id, name);
            } else {
                result.addAmbiguousNames(name);
            }
            result.addToMap(sMLocation, id);
        }
        boolean stop = this.processUnmatchedLocations(result, allLocations, unmatchedCount);
        if (stop) {
            return result;
        }
        result.resolveGeoJSON(this.dTerritories, boundingRegion);
        JSONObject gj = result.getGeoJSON();
        if (gj != null && gj.get((Object)"errors") == null) {
            gj = this.resolveGroups(gj);
            result.setGeoJSON(gj);
            result.setAmbiguityMessage(this.createAmbiguityMessage(result));
        }
        result.updateStatus();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processUnmatchedLocations(SmarterMapsResult result, List<ISMLocation> iLocations, int unmatchedCount) {
        Iterator<MapIndexer> i$;
        int nbUnmatched;
        int nbLocations;
        block7: {
            nbLocations = iLocations.size();
            if (unmatchedCount == nbLocations) {
                if (this.m_domainName != null && this.m_domainName.equalsIgnoreCase("WhiteSox")) {
                    List<MapIndexer> indexes = MapIndexer.getNonMapIndexers();
                    nbUnmatched = 0;
                    i$ = indexes.iterator();
                    break block7;
                } else {
                    result.setStatus(Status.FAILURE);
                    result.setFailureMessage("None of the locations match");
                    return true;
                }
            }
            int level = 100 * (nbLocations - unmatchedCount) / nbLocations;
            if (level >= this.confidenceLevel) return false;
            result.setStatus(Status.FAILURE);
            result.setFailureMessage("Less than " + this.confidenceLevel + "% of the locations match. \nUnmatched Locations:" + result.getUnmatchedNames());
            return true;
        }
        while (i$.hasNext()) {
            MapIndexer index = i$.next();
            Map<Integer, String> locations = index.getLocations();
            for (ISMLocation location : iLocations) {
                String name = location.getName();
                if (locations.containsValue(name = MapsUtilities.removeExtraWS(name))) continue;
                ++nbUnmatched;
            }
            int level = 100 * (nbLocations - nbUnmatched) / nbLocations;
            this.confidenceLevel = 20;
            if (level > this.confidenceLevel) {
                result.setGeoJSON(index.getGeoJSON());
                result.setStatus(Status.SUCCESS);
                result.setMapName("WhiteSox");
                return true;
            }
            nbUnmatched = 0;
        }
        return false;
    }

    public List<Integer> getLocationIds(ISMLocation sMLocation, SmarterMapsResult result) {
        LocationEntry entry;
        String locationName = sMLocation.getName();
        List<Integer> locIds = null;
        List<ISMLocation> ancestryLocs = sMLocation.getAncestryLocations();
        if (ancestryLocs != null) {
            String name = locationName;
            for (int i = 0; i < ancestryLocs.size(); ++i) {
                String ancestorName;
                ISMLocation ancestor = ancestryLocs.get(i);
                if (ancestor == null || !ancestor.isUsedAsAncestor() || (ancestorName = ancestor.getName()).equals("all") || indexer.getLocationIds(ancestorName) == null) continue;
                List<Integer> locIds1 = indexer.getLocationIdsWithAncestor(name, ancestorName);
                if (locIds1 == null || locIds1.isEmpty()) {
                    return null;
                }
                locIds = new ArrayList<Integer>();
                locIds.addAll(locIds1);
                name = ancestorName;
                return locIds;
            }
        }
        if ((locIds = indexer.getLocationIds(locationName)) == null || locIds.isEmpty()) {
            return locIds;
        }
        if (locIds.size() == 1 && (entry = indexer.getLocation(locIds.get(0))).getType() == LocationEntry.Type.CITY) {
            return null;
        }
        List<ISMLocation> ancestryLocations = sMLocation.getAncestryLocations();
        if (ancestryLocations != null && !ancestryLocations.isEmpty()) {
            if (!this.isKnownAncestry(sMLocation)) {
                return locIds;
            }
            boolean res = false;
            List<Integer> ancestryToRoot = this.getValidAncestryIds(sMLocation, this.dTerritories);
            if (ancestryToRoot != null) {
                for (Integer id : locIds) {
                    List<Integer> idRoot = indexer.getPathToRoot(id, this.dTerritories);
                    res = this.isIdenticalPath(ancestryToRoot, idRoot);
                    if (!res || indexer.getLocation(id).getType() == LocationEntry.Type.CITY) continue;
                    ArrayList<Integer> resultIds = new ArrayList<Integer>();
                    resultIds.add(id);
                    return resultIds;
                }
            } else {
                if (result.getStatus() == Status.UNKNOWN || result.getStatus() == Status.SUCCESS) {
                    result.setStatus(Status.WARNING);
                }
                String message = result.getAmbiguityMessage();
                ArrayList<String> ancestorNames = new ArrayList<String>();
                for (ISMLocation loc : ancestryLocations) {
                    ancestorNames.add(loc.getName());
                }
                message = message + " " + sMLocation.getName() + " has incorrect ancestors: " + ancestorNames;
                result.setWarningMessage(message);
                return locIds;
            }
        }
        return locIds;
    }

    private JSONObject resolveGroups(JSONObject gj) {
        Map<String, List<Integer>> groups = this.getGroups();
        if (groups != null) {
            Set<String> groupNames = groups.keySet();
            for (String groupName : groupNames) {
                List<Integer> ids = groups.get(groupName);
                gj = indexer.mergePolygons(gj, groupName, ids, this.dTerritories);
            }
        }
        return gj;
    }

    @Override
    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    @Override
    public void setConfidenceLevel(int confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public JSONObject addAliases(String path) {
        return this.groupsAndAliases.addAliases(path);
    }

    @Override
    public JSONObject addAliases(InputStream is) {
        return this.groupsAndAliases.addAliases(is);
    }

    @Override
    public JSONObject addGroups(String path) {
        return this.groupsAndAliases.addGroups(path, this.dTerritories);
    }

    @Override
    public JSONObject addGroups(InputStream is) {
        return this.groupsAndAliases.addGroups(is, this.dTerritories);
    }

    @Override
    public boolean isMappable(List<ISMLocation> sMLocations) {
        if (this.isGenericRegion(sMLocations)) {
            LogUtil.logMsg("SmarterMaps::isMappable is false.");
            return false;
        }
        JSONObject map = this.generateSmallestRegion(sMLocations);
        if (map.get((Object)"status").equals(Status.FAILURE.getName())) {
            LogUtil.logMsg("SmarterMaps::isMappable is false.");
            return false;
        }
        LogUtil.logMsg("SmarterMaps::isMappable is true.");
        return true;
    }

    @Override
    public boolean isMappable(List<ISMLocation> sMLocations, String columnHeader) {
        if (this.isGenericRegion(sMLocations)) {
            LogUtil.logIsMappableMsg("SmarterMaps::isMappable is false for ", columnHeader);
            return false;
        }
        JSONObject map = this.generateSmallestRegion(sMLocations);
        if (map.get((Object)"status").equals(Status.FAILURE.getName())) {
            LogUtil.logIsMappableMsg("SmarterMaps::isMappable is false for ", columnHeader);
            return false;
        }
        LogUtil.logIsMappableMsg("SmarterMaps::isMappable is true for ", columnHeader);
        return true;
    }

    public boolean isMappable(List<ISMLocation> sMLocations, String columnHeader, boolean useAncestor) {
        return false;
    }

    @Override
    public JSONObject addGroup(String groupName, List<String> groupElements) {
        return this.groupsAndAliases.addGroup(groupName, groupElements, this.dTerritories);
    }

    @Override
    public Map<String, List<Integer>> getGroups() {
        return this.groupsAndAliases.getGroups();
    }

    private void setDisputedTerritoriesList() {
        if (this.m_properties != null && !this.m_properties.isEmpty()) {
            String string = (String)this.m_properties.get(CHINA_TAIWAN_PROPERTY);
            if (string != null) {
                if (string.equalsIgnoreCase(CHINA)) {
                    this.dTerritories.add(LocationIndexer.DisputedTerritories.ChinaPrecedence);
                } else if (string.equalsIgnoreCase(TAIWAN)) {
                    this.dTerritories.add(LocationIndexer.DisputedTerritories.TaiwanPrecedence);
                }
            }
            if ((string = (String)this.m_properties.get(INDIA_PAKISTAN_PROPERTY)) != null) {
                if (string.equalsIgnoreCase(INDIA)) {
                    this.dTerritories.add(LocationIndexer.DisputedTerritories.IndiaPrecedence);
                } else if (string.equalsIgnoreCase(PAKISTAN)) {
                    this.dTerritories.add(LocationIndexer.DisputedTerritories.PakistanPrecedence);
                }
            }
            if ((string = (String)this.m_properties.get(ISRAEL_WEST_BANK_PROPERTY)) != null) {
                if (string.equalsIgnoreCase(ISRAEL)) {
                    this.dTerritories.add(LocationIndexer.DisputedTerritories.IsraelPrecedence);
                } else if (string.equalsIgnoreCase("West Bank")) {
                    this.dTerritories.add(LocationIndexer.DisputedTerritories.WestBankPrecedence);
                }
            }
            if ((string = (String)this.m_properties.get(DOMAIN_NAME)) != null) {
                this.m_domainName = string;
            }
        }
    }

    public boolean isGenericRegion(List<ISMLocation> locations) {
        return indexer.isGenericRegion(locations);
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, String columnHeader, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        try {
            boolean boundingFlag = true;
            JSONObject smallestRegion = this.generateSmallestRegion(sMLocations, columnHeader, boundingFlag);
            String status = (String)smallestRegion.get((Object)"status");
            if (status != null && !status.equals(Status.FAILURE.getName())) {
                JSONObject geojson = (JSONObject)smallestRegion.get((Object)"geojson");
                if (geojson == null || geojson.get((Object)Status.FAILURE) != null) {
                    return smallestRegion;
                }
                geojson.remove((Object)"ids");
                smallestRegion = this.performGenerateBoundingRegion(sMLocations, smallestRegion, topPercent, bottomPercent, leftPercent, rightPercent);
            }
            return smallestRegion;
        }
        catch (Exception e) {
            SmarterMapsResult result = new SmarterMapsResult();
            LogUtil.logException(e, "SmarterMaps::generateBoundingRegion(): ", result);
            result.setStatus(Status.FAILURE);
            result.setFailureMessage("Exception in generateBoundingRegion(): " + e.getMessage());
            return result.convertToJSON();
        }
    }

    @Override
    public ISmarterMaps.LocationType getType(List<ISMLocation> locationNames) {
        if (locationNames == null || locationNames.size() == 0) {
            return null;
        }
        LocationEntry.Type[] typeList = LocationEntry.Type.values();
        int listLength = locationNames.size();
        int len = typeList.length;
        int[] typeCount = new int[len];
        for (int i = 0; i < len; ++i) {
            typeCount[i] = 0;
        }
        int maxIndex = -1;
        int maxCount = 0;
        for (ISMLocation locationName : locationNames) {
            for (int i = 0; i < len; ++i) {
                if (!this.nameCanBe(typeList[i], locationName.getName())) continue;
                int n = i;
                typeCount[n] = typeCount[n] + 1;
                if (maxCount >= typeCount[i]) continue;
                maxCount = typeCount[i];
                maxIndex = i;
            }
        }
        if (maxCount <= listLength / 2) {
            return null;
        }
        int moreThan50Percent = 0;
        for (int i = 0; i < len; ++i) {
            if (typeCount[i] <= listLength / 2) continue;
            ++moreThan50Percent;
        }
        if (moreThan50Percent > 1) {
            return null;
        }
        LocationEntry.Type let = typeList[maxIndex];
        return this.getLocationType(let);
    }

    private ISmarterMaps.LocationType getLocationType(LocationEntry.Type let) {
        ISmarterMaps.LocationType lt = null;
        if (let == LocationEntry.Type.CONTINENT) {
            lt = ISmarterMaps.LocationType.CONTINENT;
        } else if (let == LocationEntry.Type.SUBREGION) {
            lt = ISmarterMaps.LocationType.SUBCONTINENT;
        } else if (let == LocationEntry.Type.COUNTRY) {
            lt = ISmarterMaps.LocationType.COUNTRY;
        } else if (let == LocationEntry.Type.REGION) {
            lt = ISmarterMaps.LocationType.COUNTRYREGION;
        } else if (let == LocationEntry.Type.PROVINCE) {
            lt = ISmarterMaps.LocationType.PROVINCE;
        } else if (let == LocationEntry.Type.COUNTY) {
            lt = ISmarterMaps.LocationType.COUNTY;
        } else if (let == LocationEntry.Type.CITY) {
            lt = ISmarterMaps.LocationType.CITY;
        }
        return lt;
    }

    @Override
    public List<ISmarterMaps.LocationType> getTypes(List<ISMLocation> iLocations) {
        ArrayList<ISmarterMaps.LocationType> result = new ArrayList<ISmarterMaps.LocationType>();
        JSONObject map = this.generateSmallestRegion(iLocations, "", false);
        JSONObject geojson = (JSONObject)map.get((Object)"geojson");
        if (geojson == null || geojson.get((Object)Status.FAILURE) != null) {
            for (ISMLocation iLocation : iLocations) {
                List<Integer> locIds;
                String name = iLocation.getName();
                List<ISMLocation> ancestorLocations = iLocation.getAncestryLocations();
                if (ancestorLocations != null || (locIds = indexer.getLocationIds(name)) == null) continue;
                for (Integer locId : locIds) {
                    LocationEntry.Type type;
                    ISmarterMaps.LocationType lType;
                    LocationEntry entry = indexer.getLocation(locId);
                    if (entry == null || result.contains((Object)(lType = this.getLocationType(type = entry.getType())))) continue;
                    result.add(lType);
                }
            }
            return result;
        }
        JSONArray ids = (JSONArray)geojson.get((Object)"ids");
        geojson.remove((Object)"ids");
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                Integer id = (Integer)ids.get(i);
                LocationEntry.Type type = indexer.getLocation(id).getType();
                ISmarterMaps.LocationType lType = this.getLocationType(type);
                if (result.contains((Object)lType)) continue;
                result.add(lType);
            }
        }
        return result;
    }

    private boolean nameCanBe(LocationEntry.Type nameType, String locationName) {
        List<Integer> locIds = indexer.getLocationIds(locationName);
        if (locIds == null || locIds.isEmpty()) {
            return false;
        }
        for (Integer locId : locIds) {
            LocationEntry.Type type = indexer.getLocation(locId).getType();
            if (type.ordinal() != nameType.ordinal()) continue;
            return true;
        }
        return false;
    }

    private String createAmbiguityMessage(SmarterMapsResult result) {
        StringBuffer ambiguityMessage = new StringBuffer();
        Set<String> ambiguousNames = result.getAmbiguousNames();
        for (String ambiguousName : ambiguousNames) {
            List<Integer> locIds = indexer.getLocationIds(ambiguousName);
            ambiguityMessage.append(ambiguousName + " is:");
            for (Integer locId : locIds) {
                LocationEntry entry = indexer.getLocation(locId);
                Integer parentId = entry.getFirstParentId();
                LocationEntry parent = indexer.getLocation(parentId);
                ambiguityMessage.append("\n" + (Object)((Object)entry.getType()) + " in " + parent.getName());
                if (parent.getType() == LocationEntry.Type.COUNTRY) continue;
                parentId = parent.getFirstParentId();
                ambiguityMessage.append(", " + indexer.getLocation(parentId).getName());
            }
            ambiguityMessage.append("\n");
        }
        return ambiguityMessage.toString();
    }

    @Override
    public JSONObject getShapes(List<ISMLocation> iLocations, boolean boundingRegion) {
        JSONArray ambiguous;
        JSONArray rotation;
        int i;
        JSONObject mapping = new JSONObject();
        JSONObject shapes = new JSONObject();
        JSONObject result = new JSONObject();
        JSONArray shapeFeatures = new JSONArray();
        JSONArray shapeFeaturesWithInputName = new JSONArray();
        shapes.put((Object)"type", (Object)"FeatureCollection");
        shapes.put((Object)"features", (Object)shapeFeatures);
        JSONObject map = this.generateSmallestRegion(iLocations, "", boundingRegion);
        JSONObject geojson = (JSONObject)map.get((Object)"geojson");
        result.put((Object)"status", map.get((Object)"status"));
        JSONArray unmatched = (JSONArray)map.get((Object)"unmatched");
        if (unmatched != null) {
            result.put((Object)"unmatched", (Object)unmatched);
        }
        if (geojson == null || geojson.get((Object)Status.FAILURE) != null || geojson.get((Object)"features") == null) {
            String failureMessage = (String)map.get((Object)"failureMessage");
            if (failureMessage != null) {
                result.put((Object)"failureMessage", (Object)failureMessage);
            }
            return result;
        }
        JSONArray returnedIds = (JSONArray)geojson.get((Object)"ids");
        JSONArray features = (JSONArray)geojson.get((Object)"features");
        JSONObject countiesobj = (JSONObject)geojson.get((Object)"counties");
        if (countiesobj != null) {
            JSONArray features2 = (JSONArray)countiesobj.get((Object)"features");
            features.addAll((Collection)features2);
        }
        Map<String, List<Integer>> groups = this.getGroups();
        for (i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject geomObj = (JSONObject)feature.get((Object)"geometry");
            JSONObject newFeature = new JSONObject();
            newFeature.put((Object)"type", (Object)"Feature");
            newFeature.put((Object)"geometry", (Object)geomObj);
            JSONObject propObj = (JSONObject)feature.get((Object)"properties");
            String name = (String)propObj.get((Object)"name");
            JSONObject newPropObj = new JSONObject();
            List<Integer> group = groups.get(name);
            if (group != null) {
                newPropObj.put((Object)"inputName", (Object)name);
                newPropObj.put((Object)"fid", (Object)name);
                newPropObj.put((Object)"key", (Object)name);
            } else {
                List<Object> locIds = null;
                String state = (String)propObj.get((Object)"state");
                if (state != null) {
                    locIds = new ArrayList();
                    locIds.add(indexer.getLocationId(name, state));
                } else {
                    locIds = indexer.getLocationIds(name);
                }
                if (locIds == null) continue;
                String officialName = name;
                locIds.retainAll((Collection<?>)returnedIds);
                if (!locIds.isEmpty()) {
                    block1: for (Integer n : locIds) {
                        LocationEntry entry = indexer.getLocation(n);
                        officialName = entry.getName();
                        if (entry.getType() == LocationEntry.Type.COUNTY && state == null || iLocations.size() <= 1 && !iLocations.get(0).getName().equals(name)) continue;
                        newPropObj.put((Object)"inputName", (Object)name);
                        for (ISMLocation iLocation : iLocations) {
                            String iLocationName = iLocation.getName();
                            if (!name.equals(iLocationName)) continue;
                            List<ISMLocation> ancestorLocationList = iLocation.getAncestryLocations();
                            if (ancestorLocationList == null || ancestorLocationList.isEmpty()) {
                                newPropObj.put((Object)"inputName", (Object)iLocationName);
                                newPropObj.put((Object)"key", (Object)iLocationName);
                                continue block1;
                            }
                            ISMLocation ancestorLocation = ancestorLocationList.get(0);
                            String ancestorName = ancestorLocation.getName();
                            if (ancestorName.equals("all")) {
                                newPropObj.put((Object)"inputName", (Object)iLocationName);
                                newPropObj.put((Object)"key", (Object)iLocationName);
                                continue block1;
                            }
                            List<Integer> ancestorOfficialIds = indexer.getLocationIds(ancestorName);
                            if (ancestorOfficialIds == null) {
                                newPropObj.put((Object)"key", (Object)(ancestorName + " - " + iLocationName));
                                continue;
                            }
                            for (Integer id : ancestorOfficialIds) {
                                if (!indexer.isAncestor(id, n, null)) continue;
                                newPropObj.put((Object)"key", (Object)(ancestorName + " - " + iLocationName));
                                break;
                            }
                            if (newPropObj.get((Object)"key") != null) continue;
                            newPropObj.put((Object)"key", (Object)(ancestorName + " - " + iLocationName));
                        }
                    }
                }
                String fid = (String)this.createFid(propObj, officialName);
                newPropObj.put((Object)"name", (Object)officialName);
                newPropObj.put((Object)"fid", (Object)fid);
                if (fid.endsWith("COUNTY")) {
                    newPropObj.put((Object)"level", (Object)2);
                }
            }
            newFeature.put((Object)"properties", (Object)newPropObj);
            if (newPropObj.get((Object)"inputName") == null) {
                shapeFeatures.add((Object)newFeature);
                continue;
            }
            shapeFeaturesWithInputName.add((Object)newFeature);
        }
        shapeFeatures.addAll((Collection)shapeFeaturesWithInputName);
        for (i = 0; i < iLocations.size(); ++i) {
            ISMLocation iLocation = iLocations.get(i);
            String name = iLocation.getName();
            String fid = "";
            for (int j = 0; j < shapeFeaturesWithInputName.size(); ++j) {
                JSONObject feature = (JSONObject)shapeFeaturesWithInputName.get(j);
                JSONObject propObj = (JSONObject)feature.get((Object)"properties");
                if (!propObj.get((Object)"inputName").equals(name)) continue;
                fid = (String)propObj.get((Object)"fid");
                break;
            }
            JSONArray aMapping = new JSONArray();
            if (!fid.isEmpty()) {
                JSONObject aFid = new JSONObject();
                aFid.put((Object)"fid", (Object)fid);
                aMapping.add((Object)aFid);
            }
            mapping.put((Object)name, (Object)aMapping);
        }
        result.put((Object)"mapping", (Object)mapping);
        result.put((Object)"shapes", (Object)shapes);
        String projection = (String)map.get((Object)"projection");
        if (projection != null) {
            result.put((Object)"projection", (Object)projection);
        }
        if ((rotation = (JSONArray)map.get((Object)"rotation")) != null) {
            result.put((Object)"rotation", (Object)rotation);
        }
        if ((ambiguous = (JSONArray)map.get((Object)"ambiguous")) != null) {
            result.put((Object)"ambiguous", (Object)ambiguous);
        }
        return result;
    }

    private Object createFid(JSONObject propObj, String name) {
        String region;
        String result = "";
        String countryName = (String)propObj.get((Object)"ADMIN");
        if (countryName != null) {
            List<Integer> locIds = indexer.getLocationIds(new SMLocation(countryName), LocationEntry.Type.COUNTRY);
            LocationEntry entry = indexer.getLocation(locIds.get(0));
            String iso2Name = entry.getIso2Name();
            if (iso2Name.isEmpty()) {
                iso2Name = countryName;
            }
            result = result + iso2Name + "/";
        }
        if ((region = (String)propObj.get((Object)"region")) != null) {
            result = result + region + "/";
            return result + name;
        }
        String subRegion = (String)propObj.get((Object)"SUBREGION");
        if (subRegion != null) {
            return name;
        }
        String stateName = (String)propObj.get((Object)"state");
        if (stateName != null) {
            List<Integer> locIds = indexer.getLocationIds(new SMLocation(name), LocationEntry.Type.COUNTY);
            for (Integer id : locIds) {
                LocationEntry countyEntry = indexer.getLocation(id);
                LocationEntry stateEntry = indexer.getLocation(countyEntry.getFirstParentId());
                if (!stateName.equals(stateEntry.getName())) continue;
                LocationEntry usRegion = indexer.getParentOfType(stateEntry, LocationEntry.Type.REGION);
                return "US/" + usRegion.getName() + "/" + stateName + "/" + name + "-COUNTY";
            }
        }
        return name;
    }

    @Override
    public void setUseMapbox(boolean value) {
        this.useMapbox = value;
        indexer.setUseMapbox(value);
    }

    @Override
    public boolean getUseMapbox() {
        return this.useMapbox;
    }

    public static enum Status {
        SUCCESS("OK"),
        FAILURE("Fail"),
        WARNING("Warning"),
        UNKNOWN("Unknown");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

