/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.BoundingRegion;
import com.ibm.athena.smartermaps.GroupsAndAliasesPB;
import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.ISmarterMaps;
import com.ibm.athena.smartermaps.LogUtilPB;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.SmarterMapsResultPB;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexerPB;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SmarterMapsPB
implements ISmarterMaps {
    private static final LocationIndexerPB indexer = LocationIndexerPB.getInstance();
    private int confidenceLevel = 80;
    private boolean useMapbox = false;
    private Properties m_properties = new Properties();
    private BoundingRegion boundingRegionUnit = new BoundingRegion();
    private GroupsAndAliasesPB groupsAndAliases = new GroupsAndAliasesPB();

    public SmarterMapsPB() {
    }

    public SmarterMapsPB(Properties _properties) {
        this();
        this.m_properties = _properties;
        this.boundingRegionUnit.setProperties(this.m_properties);
    }

    @Override
    public JSONObject generateSmallestRegion(List<ISMLocation> sMLocations) {
        return this.generateSmallestRegion(sMLocations, null);
    }

    @Override
    public JSONObject generateSmallestRegion(List<ISMLocation> iLocations, String title) {
        if (!this.boundingRegionUnit.isBoundingRegion()) {
            JSONObject map = this.generateSmallestRegion(iLocations, title, false);
            return map;
        }
        return this.generateBoundingRegion(iLocations, title);
    }

    public JSONObject generateSmallestRegion(List<ISMLocation> iLocations, String title, boolean boundingRegionFlag) {
        try {
            if (iLocations == null) {
                SmarterMapsResultPB result = new SmarterMapsResultPB();
                result.setStatus(Status.FAILURE);
                result.setFailureMessage("Null location list");
                return result.convertToJSON();
            }
            SmarterMapsResultPB resultingMap = this.getResultingMap(iLocations = this.removeDuplicates(iLocations), title, boundingRegionFlag);
            if (resultingMap.getStatus() == Status.FAILURE) {
                return resultingMap.convertToJSON();
            }
            JSONObject json = resultingMap.convertToJSON();
            return json;
        }
        catch (Exception e) {
            SmarterMapsResultPB result = new SmarterMapsResultPB();
            LogUtilPB.logException(e, "SmarterMaps::SmarterMaps::generateSmallestRegion(): ", result);
            return result.convertToJSON();
        }
    }

    public List<ISMLocation> removeDuplicates(List<ISMLocation> iLocations) {
        ArrayList<ISMLocation> resultList = new ArrayList<ISMLocation>();
        HashSet<ISMLocation> resultSet = new HashSet<ISMLocation>();
        resultSet.addAll(iLocations);
        resultList.addAll(resultSet);
        return resultList;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations) {
        return null;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, String title) {
        return null;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        return null;
    }

    private boolean isKnownAncestry(ISMLocation iLocation) {
        List<ISMLocation> ancestryList = iLocation.getAncestryLocations();
        for (ISMLocation location : ancestryList) {
            List<Integer> ids = indexer.getLocationIdsForName(location.getName());
            if (ids != null && !ids.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<Integer> getValidAncestryIds(ISMLocation iLocation) {
        List<ISMLocation> ancestryList = iLocation.getAncestryLocations();
        List<Integer> ids = indexer.getLocationIdsForName(iLocation.getName());
        for (Integer id : ids) {
            List<Integer> ancestryIds = indexer.getPathToRoot(id);
            int nbMatches = ancestryList.size();
            for (int i = 0; i < ancestryIds.size() - 1; ++i) {
                Integer ancestryId = ancestryIds.get(i);
                String ancestryName = ancestryList.get(nbMatches - 1).getName();
                List<Integer> curLocationIds = indexer.getLocationIdsForName(ancestryName);
                if (!curLocationIds.contains(ancestryId) || --nbMatches != 0) continue;
                return ancestryIds;
            }
        }
        return null;
    }

    private boolean isIdenticalPath(List<Integer> ancestryIds, List<Integer> curIds) {
        if (ancestryIds.size() != curIds.size()) {
            return false;
        }
        for (int i = 0; i < curIds.size(); ++i) {
            if (ancestryIds.get(i) == curIds.get(i)) continue;
            return false;
        }
        return true;
    }

    private SmarterMapsResultPB getResultingMap(List<ISMLocation> iLocationsInit, String title, boolean boundingRegion) {
        SmarterMapsResultPB result = new SmarterMapsResultPB();
        ArrayList<ISMLocation> allLocations = new ArrayList<ISMLocation>();
        ArrayList<String> matchedLocationNames = new ArrayList<String>();
        Map<String, List<Integer>> groups = this.getGroups();
        for (ISMLocation sMLocation : iLocationsInit) {
            String name = sMLocation.getName();
            List<Integer> elements = groups.get(name);
            if (elements != null && !elements.isEmpty()) {
                for (int i = 0; i < elements.size(); ++i) {
                    LocationEntry entry = indexer.getLocation(elements.get(i));
                    String elementName = entry.getName();
                    Integer parentId = entry.getFirstParentId();
                    String parentName = indexer.getLocation(parentId).getName();
                    ArrayList<ISMLocation> ancestryList = new ArrayList<ISMLocation>();
                    ancestryList.add(new SMLocation(parentName));
                    SMLocation iLocation = new SMLocation(elementName, ancestryList);
                    allLocations.add(iLocation);
                }
                continue;
            }
            allLocations.add(sMLocation);
        }
        int unmatchedCount = 0;
        boolean containsPostalCodes = false;
        for (ISMLocation sMLocation : allLocations) {
            String name = sMLocation.getName();
            List<Integer> ids = null;
            if (this.isPostal(sMLocation)) {
                containsPostalCodes = true;
                List<ISMLocation> ancestorList = sMLocation.getAncestryLocations();
                if (ancestorList == null || ancestorList.isEmpty()) {
                    result.addUnmatchedName(name);
                    ++unmatchedCount;
                    continue;
                }
                ISMLocation ancestor = ancestorList.get(0);
                String countryName = ancestor.getName();
                ids = indexer.getLocationIdsForName(countryName);
                if (ids == null) {
                    result.addUnmatchedName(ancestor + "@" + name);
                    ++unmatchedCount;
                    continue;
                }
                LocationEntry entry = null;
                String countryCode = null;
                for (Integer id : ids) {
                    entry = indexer.getLocation(id);
                    if (!entry.getMapId().equals("n")) continue;
                    countryCode = entry.getCountryCode();
                    break;
                }
                if (countryCode == null) {
                    result.addUnmatchedName(ancestor + "@" + name);
                    ++unmatchedCount;
                    continue;
                }
                ids = indexer.getLocationIdsForName(name);
                if (ids == null || ids.isEmpty()) {
                    result.addUnmatchedName(ancestor + "@" + name);
                    ++unmatchedCount;
                    continue;
                }
                boolean found = false;
                for (Integer id : ids) {
                    entry = indexer.getLocation(id);
                    if (!entry.getPath().equals(countryCode)) continue;
                    result.addUniqueLocation(id, name);
                    result.addToMap(sMLocation, id);
                    found = true;
                    break;
                }
                if (found) continue;
                result.addUnmatchedName(ancestor + "@" + name);
                ++unmatchedCount;
                continue;
            }
            name = sMLocation.getName();
            ids = indexer.getLocationIds(sMLocation);
            if (ids == null || ids.size() == 0) {
                result.addUnmatchedName(sMLocation.getName());
                ++unmatchedCount;
                continue;
            }
            matchedLocationNames.add(name);
            Integer id = null;
            if (ids.size() == 1) {
                id = ids.get(0);
                result.addUniqueLocation(id, name);
            } else {
                result.addAmbiguousNames(name);
            }
            result.addToMap(sMLocation, id);
        }
        if (!containsPostalCodes) {
            result.resolveResult();
            JSONObject gj = result.getJSON();
            if (gj != null && gj.get((Object)"errors") == null) {
                result.setResultJSON(gj);
            }
            result.updateStatus();
        } else {
            if (unmatchedCount > 0) {
                result.setStatus(Status.WARNING);
            } else {
                result.setStatus(Status.SUCCESS);
            }
            JSONObject gj1 = new JSONObject();
            gj1.put((Object)"a", (Object)1);
            result.setResultJSON(gj1);
        }
        return result;
    }

    private boolean isPostal(ISMLocation sMLocation) {
        String ancestor;
        String name = sMLocation.getName();
        int digitCount = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isDigit(name.charAt(i))) continue;
            ++digitCount;
        }
        if (digitCount == name.length()) {
            return true;
        }
        List<ISMLocation> ancestorList = sMLocation.getAncestryLocations();
        return ancestorList != null && this.isPostalCode(ancestor = ancestorList.get(0).getName(), sMLocation.getName());
    }

    private boolean isPostalCode(String countryName, String pc) {
        List<Integer> locIds = indexer.getLocationIdsForName(countryName);
        if (locIds == null || locIds.isEmpty()) {
            return false;
        }
        boolean found = false;
        String countryCode = "";
        for (int i = 0; i < locIds.size(); ++i) {
            Integer locId = locIds.get(i);
            LocationEntry entry = indexer.getLocation(locId);
            if (!entry.getMapId().equals("n")) continue;
            found = true;
            countryCode = entry.getCountryCode();
            break;
        }
        if (!found) {
            return false;
        }
        if (countryCode.equals("FR") && pc.equals("Y")) {
            return false;
        }
        int digitCount = 0;
        if (pc.length() == 1) {
            return true;
        }
        for (int i = 0; i < pc.length(); ++i) {
            if (!Character.isDigit(pc.charAt(i))) continue;
            ++digitCount;
        }
        if (digitCount >= pc.length() / 2) {
            return true;
        }
        if (countryCode.equals("GB")) {
            switch (pc.length()) {
                case 1: {
                    if (!Character.isUpperCase(pc.charAt(0))) break;
                    return true;
                }
                case 2: {
                    if (!Character.isUpperCase(pc.charAt(0)) || !Character.isUpperCase(pc.charAt(1))) break;
                    return true;
                }
                case 3: {
                    if (!Character.isUpperCase(pc.charAt(0)) || !Character.isUpperCase(pc.charAt(1)) || !Character.isDigit(pc.charAt(2))) break;
                    return true;
                }
            }
            if (pc.startsWith("SW") || pc.startsWith("EC") || pc.startsWith("WC")) {
                return true;
            }
        }
        if (countryCode.equals("BM") && (pc.length() == 2 ? Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)) : pc.length() == 4 && Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)) && Character.isDigit(pc.charAt(2)) && Character.isDigit(pc.charAt(3)))) {
            return true;
        }
        if (countryCode.equals("BN") && (pc.length() == 1 ? Character.isUpperCase(pc.charAt(0)) : pc.length() == 2 && Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)))) {
            return true;
        }
        if ((countryCode.equals("GG") || countryCode.equals("IM") || countryCode.equals("JE")) && (pc.length() == 2 ? Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)) : pc.length() == 3 && Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)) && Character.isDigit(pc.charAt(2)))) {
            return true;
        }
        return countryCode.equals("MT") && (pc.length() == 2 ? Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)) : pc.length() == 3 && Character.isUpperCase(pc.charAt(0)) && Character.isUpperCase(pc.charAt(1)) && Character.isUpperCase(pc.charAt(2)));
    }

    public List<Integer> getLocationIds(ISMLocation sMLocation, SmarterMapsResultPB result) {
        LocationEntry entry;
        String locationName = sMLocation.getName();
        List<Integer> locIds = null;
        List<ISMLocation> ancestryLocs = sMLocation.getAncestryLocations();
        if (ancestryLocs != null) {
            for (int i = 0; i < ancestryLocs.size(); ++i) {
                String ancestorName;
                ISMLocation ancestor = ancestryLocs.get(i);
                if (ancestor == null || !ancestor.isUsedAsAncestor() || (ancestorName = ancestor.getName()).equals("all") || indexer.getLocationIdsForName(ancestorName) == null) continue;
                List<Integer> locIds1 = indexer.getLocationIds(sMLocation);
                if (locIds1 == null || locIds1.isEmpty()) {
                    return null;
                }
                locIds = new ArrayList<Integer>();
                locIds.addAll(locIds1);
                return locIds;
            }
        }
        if ((locIds = indexer.getLocationIdsForName(locationName)) == null || locIds.isEmpty()) {
            return locIds;
        }
        if (locIds.size() == 1 && (entry = indexer.getLocation(locIds.get(0))).getType() == LocationEntry.Type.CITY) {
            return null;
        }
        List<ISMLocation> ancestryLocations = sMLocation.getAncestryLocations();
        if (ancestryLocations != null && !ancestryLocations.isEmpty()) {
            if (!this.isKnownAncestry(sMLocation)) {
                return locIds;
            }
            boolean res = false;
            List<Integer> ancestryToRoot = this.getValidAncestryIds(sMLocation);
            if (ancestryToRoot != null) {
                for (Integer id : locIds) {
                    List<Integer> idRoot = indexer.getPathToRoot(id);
                    res = this.isIdenticalPath(ancestryToRoot, idRoot);
                    if (!res || indexer.getLocation(id).getType() == LocationEntry.Type.CITY) continue;
                    ArrayList<Integer> resultIds = new ArrayList<Integer>();
                    resultIds.add(id);
                    return resultIds;
                }
            } else {
                if (result.getStatus() == Status.UNKNOWN || result.getStatus() == Status.SUCCESS) {
                    result.setStatus(Status.WARNING);
                }
                String message = result.getAmbiguityMessage();
                ArrayList<String> ancestorNames = new ArrayList<String>();
                for (ISMLocation loc : ancestryLocations) {
                    ancestorNames.add(loc.getName());
                }
                message = message + " " + sMLocation.getName() + " has incorrect ancestors: " + ancestorNames;
                result.setWarningMessage(message);
                return locIds;
            }
        }
        return locIds;
    }

    @Override
    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    @Override
    public void setConfidenceLevel(int confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public JSONObject addAliases(String path) {
        return this.groupsAndAliases.addAliases(path);
    }

    @Override
    public JSONObject addAliases(InputStream is) {
        return this.groupsAndAliases.addAliases(is);
    }

    @Override
    public JSONObject addGroups(String path) {
        return this.groupsAndAliases.addGroups(path);
    }

    @Override
    public JSONObject addGroups(InputStream is) {
        return this.groupsAndAliases.addGroups(is);
    }

    @Override
    public boolean isMappable(List<ISMLocation> sMLocations) {
        if (this.isGenericRegion(sMLocations)) {
            LogUtilPB.logMsg("SmarterMaps::isMappable is false.");
            return false;
        }
        JSONObject map = this.generateSmallestRegion(sMLocations);
        if (map.get((Object)"status").equals(Status.FAILURE.getName())) {
            LogUtilPB.logMsg("SmarterMaps::isMappable is false.");
            return false;
        }
        LogUtilPB.logMsg("SmarterMaps::isMappable is true.");
        return true;
    }

    @Override
    public boolean isMappable(List<ISMLocation> sMLocations, String columnHeader) {
        if (this.isGenericRegion(sMLocations)) {
            LogUtilPB.logIsMappableMsg("SmarterMaps::isMappable is false for ", columnHeader);
            return false;
        }
        JSONObject map = this.generateSmallestRegion(sMLocations);
        if (map.get((Object)"status").equals(Status.FAILURE.getName())) {
            LogUtilPB.logIsMappableMsg("SmarterMaps::isMappable is false for ", columnHeader);
            return false;
        }
        LogUtilPB.logIsMappableMsg("SmarterMaps::isMappable is true for ", columnHeader);
        return true;
    }

    public boolean isMappable(List<ISMLocation> sMLocations, String columnHeader, boolean useAncestor) {
        return false;
    }

    @Override
    public JSONObject addGroup(String groupName, List<String> groupElements) {
        return this.groupsAndAliases.addGroup(groupName, groupElements);
    }

    @Override
    public Map<String, List<Integer>> getGroups() {
        return this.groupsAndAliases.getGroups();
    }

    public boolean isGenericRegion(List<ISMLocation> locations) {
        return indexer.isGenericRegion(locations);
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, String columnHeader, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        return null;
    }

    @Override
    public ISmarterMaps.LocationType getType(List<ISMLocation> locationNames) {
        if (locationNames == null || locationNames.size() == 0) {
            return null;
        }
        LocationEntry.Type[] typeList = LocationEntry.Type.values();
        int listLength = locationNames.size();
        int len = typeList.length;
        int[] typeCount = new int[len];
        for (int i = 0; i < len; ++i) {
            typeCount[i] = 0;
        }
        int maxIndex = -1;
        int maxCount = 0;
        for (ISMLocation locationName : locationNames) {
            for (int i = 0; i < len; ++i) {
                if (!this.nameCanBe(typeList[i], locationName.getName())) continue;
                int n = i;
                typeCount[n] = typeCount[n] + 1;
                if (maxCount >= typeCount[i]) continue;
                maxCount = typeCount[i];
                maxIndex = i;
            }
        }
        if (maxCount <= listLength / 2) {
            return null;
        }
        int moreThan50Percent = 0;
        for (int i = 0; i < len; ++i) {
            if (typeCount[i] <= listLength / 2) continue;
            ++moreThan50Percent;
        }
        if (moreThan50Percent > 1) {
            return null;
        }
        LocationEntry.Type let = typeList[maxIndex];
        return this.getLocationType(let);
    }

    private ISmarterMaps.LocationType getLocationType(LocationEntry.Type let) {
        ISmarterMaps.LocationType lt = null;
        if (let == LocationEntry.Type.CONTINENT) {
            lt = ISmarterMaps.LocationType.CONTINENT;
        } else if (let == LocationEntry.Type.SUBREGION) {
            lt = ISmarterMaps.LocationType.SUBCONTINENT;
        } else if (let == LocationEntry.Type.COUNTRY) {
            lt = ISmarterMaps.LocationType.COUNTRY;
        } else if (let == LocationEntry.Type.REGION) {
            lt = ISmarterMaps.LocationType.COUNTRYREGION;
        } else if (let == LocationEntry.Type.PROVINCE) {
            lt = ISmarterMaps.LocationType.PROVINCE;
        } else if (let == LocationEntry.Type.COUNTY) {
            lt = ISmarterMaps.LocationType.COUNTY;
        } else if (let == LocationEntry.Type.CITY) {
            lt = ISmarterMaps.LocationType.CITY;
        }
        return lt;
    }

    @Override
    public List<ISmarterMaps.LocationType> getTypes(List<ISMLocation> iLocations) {
        ArrayList<ISmarterMaps.LocationType> result = new ArrayList<ISmarterMaps.LocationType>();
        JSONObject map = this.generateSmallestRegion(iLocations, "", false);
        JSONObject geojson = (JSONObject)map.get((Object)"geojson");
        if (geojson == null || geojson.get((Object)Status.FAILURE) != null) {
            for (ISMLocation iLocation : iLocations) {
                List<Integer> locIds;
                String name = iLocation.getName();
                List<ISMLocation> ancestorLocations = iLocation.getAncestryLocations();
                if (ancestorLocations != null || (locIds = indexer.getLocationIdsForName(name)) == null) continue;
                for (Integer locId : locIds) {
                    LocationEntry.Type type;
                    ISmarterMaps.LocationType lType;
                    LocationEntry entry = indexer.getLocation(locId);
                    if (entry == null || result.contains((Object)(lType = this.getLocationType(type = entry.getType())))) continue;
                    result.add(lType);
                }
            }
            return result;
        }
        JSONArray ids = (JSONArray)geojson.get((Object)"ids");
        geojson.remove((Object)"ids");
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                Integer id = (Integer)ids.get(i);
                LocationEntry.Type type = indexer.getLocation(id).getType();
                ISmarterMaps.LocationType lType = this.getLocationType(type);
                if (result.contains((Object)lType)) continue;
                result.add(lType);
            }
        }
        return result;
    }

    private boolean nameCanBe(LocationEntry.Type nameType, String locationName) {
        List<Integer> locIds = indexer.getLocationIdsForName(locationName);
        if (locIds == null || locIds.isEmpty()) {
            return false;
        }
        for (Integer locId : locIds) {
            LocationEntry.Type type = indexer.getLocation(locId).getType();
            if (type.ordinal() != nameType.ordinal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject getShapes(List<ISMLocation> iLocations, boolean boundingRegion) {
        return null;
    }

    @Override
    public void setUseMapbox(boolean value) {
    }

    @Override
    public boolean getUseMapbox() {
        return this.useMapbox;
    }

    public static enum Status {
        SUCCESS("OK"),
        FAILURE("Fail"),
        WARNING("Warning"),
        UNKNOWN("Unknown");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

