/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.SmarterMaps;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SmarterMapsResult {
    private static final String PROJECTION_MERCATOR = "mercator";
    private static final String PROJECTION_STEREOGRAPHIC = "stereographic";
    private static final String PROJECTION_SIMPLE = "simple";
    private Set<String> unmatchedNames = new HashSet<String>();
    private Set<String> ambiguousNames = new HashSet<String>();
    private Map<Integer, String> uniqueLocations = new HashMap<Integer, String>();
    private Map<ISMLocation, Integer> locationMap = new HashMap<ISMLocation, Integer>();
    private SmarterMaps.Status status = SmarterMaps.Status.UNKNOWN;
    private String failureMessage = "";
    private String ambiguityMessage = "";
    private String warningMessage = "";
    private JSONObject geoJSON = new JSONObject();
    private String mapName = "";
    private String projection = "";
    private LocationIndexer indexer = LocationIndexer.getInstance();

    public JSONObject convertToJSON() {
        JSONObject output = new JSONObject();
        output.put((Object)"status", (Object)this.status.getName());
        if (this.failureMessage.length() > 0) {
            output.put((Object)"failureMessage", (Object)this.failureMessage);
            return output;
        }
        JSONArray unmatchedNameArray = new JSONArray();
        unmatchedNameArray.addAll(this.getUnmatchedNames());
        if (unmatchedNameArray.size() > 0) {
            output.put((Object)"unmatched", (Object)unmatchedNameArray);
        }
        JSONArray ambiguousNameArray = new JSONArray();
        ambiguousNameArray.addAll(this.getAmbiguousNames());
        if (ambiguousNameArray.size() > 0) {
            output.put((Object)"ambiguous", (Object)ambiguousNameArray);
            if (!this.ambiguityMessage.isEmpty()) {
                output.put((Object)"ambiguityMessage", (Object)this.ambiguityMessage);
            }
        }
        if (!this.warningMessage.isEmpty()) {
            output.put((Object)"warningMessage", (Object)this.warningMessage);
        }
        output.put((Object)"geojson", (Object)this.getGeoJSON());
        output.put((Object)"mapName", (Object)this.getMapName());
        output.put((Object)"projection", (Object)this.getProjection());
        JSONArray rotation = this.getRotation();
        if (rotation != null) {
            output.put((Object)"rotation", (Object)rotation);
        }
        return output;
    }

    public void addUnmatchedName(String unMatchedName) {
        this.unmatchedNames.add(unMatchedName);
    }

    public void addUniqueLocation(Integer id, String name) {
        this.uniqueLocations.put(id, name);
    }

    public void addUniqueLocationID(Integer id) {
        if (id < 1) {
            return;
        }
        String name = this.indexer.getLocation(id).getName();
        this.addUniqueLocation(id, name);
    }

    public void addAmbiguousNames(String ambigousName) {
        this.ambiguousNames.add(ambigousName);
    }

    public void setStatus(SmarterMaps.Status status) {
        this.status = status;
    }

    public void setGeoJSON(JSONObject geoJSON) {
        this.geoJSON = geoJSON;
    }

    public void updateStatus() {
        if (this.geoJSON == null || this.geoJSON.isEmpty()) {
            this.setStatus(SmarterMaps.Status.FAILURE);
            this.setFailureMessage("The map cannot be generated");
        } else if (this.geoJSON.get((Object)"errors") != null) {
            this.setStatus(SmarterMaps.Status.FAILURE);
            this.setFailureMessage((String)this.geoJSON.get((Object)"errors"));
        } else {
            if (this.status == SmarterMaps.Status.WARNING) {
                return;
            }
            if (!this.getUnmatchedNames().isEmpty() || !this.getAmbiguousNames().isEmpty()) {
                this.setStatus(SmarterMaps.Status.WARNING);
            } else {
                this.setStatus(SmarterMaps.Status.SUCCESS);
            }
        }
    }

    public void resolveGeoJSON(List<LocationIndexer.DisputedTerritories> dTerritories, boolean boundingRegion) {
        List<Integer> locIds = this.getUniqueLocationIds();
        List<String> locationNames = this.getUniqueNames();
        locationNames.addAll(this.getAmbiguousNames());
        ArrayList<SMLocation> iLocations = new ArrayList<SMLocation>();
        if (this.locationMap.size() == 1) {
            if (locIds.isEmpty()) {
                this.geoJSON.put((Object)"status", (Object)SmarterMaps.Status.FAILURE.getName());
                this.geoJSON.put((Object)"errors", (Object)(locationNames.get(0) + " is ambiguous"));
                return;
            }
            int locId = (Integer)locIds.toArray()[0];
            if (locId == 1) {
                this.geoJSON = this.indexer.getSmallestGeoJSON(this.locationMap, dTerritories, boundingRegion);
            } else {
                LocationEntry entry = this.indexer.getLocation(locId);
                int parentId = entry.getFirstParentId();
                LocationEntry parentEntry = this.indexer.getLocation(parentId);
                List<Integer> childrenIds = parentEntry.getChildren();
                if (childrenIds.size() > 1) {
                    int siblingId = childrenIds.get(0);
                    if (siblingId == locId) {
                        siblingId = childrenIds.get(1);
                    }
                    locIds.add(siblingId);
                    String siblingName = this.indexer.getLocation(siblingId).getName();
                    locationNames.add(siblingName);
                    iLocations.add(new SMLocation(siblingName));
                    this.locationMap.put(new SMLocation(siblingName), siblingId);
                    this.geoJSON = this.indexer.getSmallestGeoJSON(this.locationMap, dTerritories, boundingRegion);
                } else if (parentEntry.getGeoJSON().equals("children")) {
                    this.geoJSON = this.indexer.getSmallestGeoJSON(this.locationMap, dTerritories, boundingRegion);
                } else if (parentEntry.getGeoJSON().equals("parent")) {
                    this.geoJSON = this.indexer.getSmallestGeoJSON(this.locationMap, dTerritories, boundingRegion);
                } else {
                    try {
                        this.geoJSON = (JSONObject)JSON.parse((String)parentEntry.getGeoJSON());
                        this.geoJSON.put((Object)"mapName", (Object)parentEntry.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mapName = (String)this.geoJSON.get((Object)"mapName");
            }
        } else {
            this.geoJSON = this.indexer.getSmallestGeoJSON(this.locationMap, dTerritories, boundingRegion);
            if (this.geoJSON == null || this.geoJSON.isEmpty() || this.geoJSON.get((Object)"errors") != null) {
                return;
            }
            Integer mapId = (Integer)this.geoJSON.get((Object)"mapId");
            this.mapName = (String)this.geoJSON.get((Object)"mapName");
            JSONArray locIdsUpdated = (JSONArray)this.geoJSON.get((Object)"ids");
            ArrayList<Integer> locIds1 = new ArrayList<Integer>();
            for (int i = 0; i < locIdsUpdated.size(); ++i) {
                Integer locId = (Integer)locIdsUpdated.get(i);
                locIds1.add(locId);
            }
            if (this.indexer.getLocation(mapId).getType() == LocationEntry.Type.COUNTRY) {
                this.geoJSON = this.replaceRegions(locIds1, locationNames, mapId);
            }
            JSONArray resultingIds = new JSONArray();
            for (Integer id : this.locationMap.values()) {
                resultingIds.add((Object)id);
            }
            this.geoJSON.put((Object)"ids", (Object)resultingIds);
        }
        this.geoJSON.remove((Object)"mapName");
        this.geoJSON.remove((Object)"mapId");
        if (boundingRegion) {
            this.setProjection(PROJECTION_MERCATOR);
        }
    }

    private JSONObject replaceRegions(List<Integer> locIds, List<String> locationNames, Integer mapId) {
        JSONObject newGeoJson = new JSONObject();
        newGeoJson.put((Object)"type", (Object)"FeatureCollection");
        JSONArray newFeatures = new JSONArray();
        newGeoJson.put((Object)"features", (Object)newFeatures);
        HashMap<String, JSONObject> mapOfRegionFeatures = new HashMap<String, JSONObject>();
        for (Integer locId : locIds) {
            LocationEntry entry = this.indexer.getLocation(locId);
            if (entry.getType() != LocationEntry.Type.REGION) continue;
            String name = null;
            for (Map.Entry<ISMLocation, Integer> locMapEntry : this.locationMap.entrySet()) {
                if (!locMapEntry.getValue().equals(locId)) continue;
                name = locMapEntry.getKey().getName();
                break;
            }
            JSONObject regionFeature = new JSONObject();
            JSONObject regionProperties = new JSONObject();
            JSONObject regionGeometry = new JSONObject();
            regionProperties.put((Object)"name", (Object)name);
            regionGeometry.put((Object)"type", (Object)"MultiPolygon");
            regionGeometry.put((Object)"coordinates", (Object)new JSONArray());
            regionFeature.put((Object)"type", (Object)"Feature");
            regionFeature.put((Object)"properties", (Object)regionProperties);
            regionFeature.put((Object)"geometry", (Object)regionGeometry);
            mapOfRegionFeatures.put(name, regionFeature);
        }
        JSONArray featuresObjArr = (JSONArray)this.geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String region1 = (String)propObj.get((Object)"region");
            if (!locationNames.contains(region1)) {
                newFeatures.add((Object)featureObj);
                continue;
            }
            JSONObject regionFeature1 = (JSONObject)mapOfRegionFeatures.get(region1);
            if (regionFeature1 == null) {
                newFeatures.add((Object)featureObj);
                continue;
            }
            JSONObject geom = (JSONObject)regionFeature1.get((Object)"geometry");
            JSONArray regionCoordinates = (JSONArray)geom.get((Object)"coordinates");
            JSONObject geometryObj = (JSONObject)featureObj.get((Object)"geometry");
            String type = (String)geometryObj.get((Object)"type");
            if (type.equals("Polygon")) {
                regionCoordinates.add(geometryObj.get((Object)"coordinates"));
                continue;
            }
            if (!type.equals("MultiPolygon")) continue;
            JSONArray multiPolygon = (JSONArray)geometryObj.get((Object)"coordinates");
            for (int j = 0; j < multiPolygon.size(); ++j) {
                JSONArray multiPoly = (JSONArray)multiPolygon.get(j);
                regionCoordinates.add((Object)multiPoly);
            }
        }
        Collection values = mapOfRegionFeatures.values();
        for (JSONObject regionFeature : values) {
            newFeatures.add((Object)regionFeature);
        }
        JSONObject counties = (JSONObject)this.geoJSON.get((Object)"counties");
        if (counties != null) {
            newGeoJson.put((Object)"counties", (Object)counties);
        }
        return newGeoJson;
    }

    public Set<String> getUnmatchedNames() {
        return this.unmatchedNames;
    }

    public Set<String> getAmbiguousNames() {
        return this.ambiguousNames;
    }

    public SmarterMaps.Status getStatus() {
        return this.status;
    }

    public JSONObject getGeoJSON() {
        return this.geoJSON;
    }

    public String getMapName() {
        return this.mapName;
    }

    public Map<ISMLocation, Integer> getLocationMap() {
        return this.locationMap;
    }

    public String getAmbiguityMessage() {
        return this.ambiguityMessage;
    }

    public void setAmbiguityMessage(String ambiguityMessage) {
        this.ambiguityMessage = ambiguityMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public void setMapName(String name) {
        this.mapName = name;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public String getProjection() {
        if (this.projection.length() > 0) {
            return this.projection;
        }
        this.projection = this.mapName.compareToIgnoreCase("North America") == 0 || this.mapName.compareToIgnoreCase("Northern America") == 0 || this.mapName.compareToIgnoreCase("Canada") == 0 ? PROJECTION_STEREOGRAPHIC : (this.mapName.compareToIgnoreCase("WhiteSox") == 0 ? PROJECTION_SIMPLE : PROJECTION_MERCATOR);
        return this.projection;
    }

    private JSONArray getRotation() {
        JSONArray result = new JSONArray();
        String projection1 = this.getProjection();
        if (projection1.equals(PROJECTION_MERCATOR)) {
            this.mapName = this.getMapName();
            if (this.mapName.equals("Russia")) {
                result.add((Object)-12);
                result.add((Object)0);
                return result;
            }
        } else if (projection1.equals(PROJECTION_STEREOGRAPHIC)) {
            result.add((Object)100);
            result.add((Object)-20);
            return result;
        }
        return null;
    }

    public void setProjection(String _projection) {
        this.projection = _projection;
    }

    public List<Integer> getUniqueLocationIds() {
        Set<Integer> keys = this.uniqueLocations.keySet();
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(keys);
        return result;
    }

    public List<String> getUniqueNames() {
        Collection<String> values = this.uniqueLocations.values();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(values);
        return result;
    }

    public void addToMap(ISMLocation sMLocation, Integer id) {
        this.locationMap.put(sMLocation, id);
    }
}

