/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.SmarterMapsPB;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexerPB;
import com.ibm.athena.smartermaps.model.LocationTableHandlerPB;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SmarterMapsResultPB {
    private Set<String> unmatchedNames = new HashSet<String>();
    private Set<String> ambiguousNames = new HashSet<String>();
    private Map<Integer, String> uniqueLocations = new HashMap<Integer, String>();
    private Map<ISMLocation, Integer> locationMap = new HashMap<ISMLocation, Integer>();
    private SmarterMapsPB.Status status = SmarterMapsPB.Status.UNKNOWN;
    private String failureMessage = "";
    private String ambiguityMessage = "";
    private String warningMessage = "";
    private JSONObject result = new JSONObject();
    private LocationIndexerPB indexer = LocationIndexerPB.getInstance();

    public JSONObject convertToJSON() {
        JSONObject output = new JSONObject();
        output.put((Object)"status", (Object)this.status.getName());
        if (this.failureMessage.length() > 0) {
            output.put((Object)"failureMessage", (Object)this.failureMessage);
        }
        JSONArray unmatchedNameArray = new JSONArray();
        unmatchedNameArray.addAll(this.getUnmatchedNames());
        if (unmatchedNameArray.size() > 0) {
            output.put((Object)"unmatched", (Object)unmatchedNameArray);
        }
        JSONArray ambiguousNameArray = new JSONArray();
        ambiguousNameArray.addAll(this.getAmbiguousNames());
        if (ambiguousNameArray.size() > 0) {
            output.put((Object)"ambiguous", (Object)ambiguousNameArray);
        }
        if (!this.warningMessage.isEmpty()) {
            output.put((Object)"warningMessage", (Object)this.warningMessage);
        }
        JSONArray res1 = new JSONArray();
        LocationEntry entry = null;
        String name = "";
        for (ISMLocation key : this.locationMap.keySet()) {
            JSONObject item = new JSONObject();
            Integer locId = this.locationMap.get(key);
            if (locId == null) continue;
            entry = this.indexer.getLocation(locId);
            name = key.getName();
            item.put((Object)"name", (Object)name);
            List<ISMLocation> ancestryList = key.getAncestryLocations();
            if (ancestryList != null && !ancestryList.isEmpty()) {
                JSONArray refineArr = new JSONArray();
                for (int i = 0; i < ancestryList.size(); ++i) {
                    refineArr.add((Object)ancestryList.get(i).getName());
                }
                item.put((Object)"refine", (Object)refineArr);
            }
            item.put((Object)"pk", (Object)entry.getPk());
            item.put((Object)"mapid", (Object)this.getLongName(entry.getTileLevelMapId()));
            item.put((Object)"pointLayer", (Object)this.getLongName(entry.getPointLayer()));
            item.put((Object)"polyLayer", (Object)this.getLongName(entry.getPolyLayer()));
            item.put((Object)"country_code", (Object)entry.getCountryCode());
            String path = entry.getPath();
            if (path != null) {
                item.put((Object)"path", (Object)entry.getPath());
            }
            res1.add((Object)item);
        }
        output.put((Object)"mapboxData", (Object)res1);
        return output;
    }

    private String getLongName(String shortName) {
        return LocationTableHandlerPB.getLongName(shortName);
    }

    public void addUnmatchedName(String unMatchedName) {
        this.unmatchedNames.add(unMatchedName);
    }

    public void addUniqueLocation(Integer id, String name) {
        this.uniqueLocations.put(id, name);
    }

    public void addAmbiguousNames(String ambigousName) {
        this.ambiguousNames.add(ambigousName);
    }

    public void setStatus(SmarterMapsPB.Status status) {
        this.status = status;
    }

    public void setResultJSON(JSONObject resultJSON) {
        this.result = resultJSON;
    }

    public void updateStatus() {
        if (this.result == null || this.result.isEmpty()) {
            this.setStatus(SmarterMapsPB.Status.FAILURE);
            this.setFailureMessage("The map cannot be generated");
        } else if (this.result.get((Object)"errors") != null) {
            this.setStatus(SmarterMapsPB.Status.FAILURE);
            this.setFailureMessage((String)this.result.get((Object)"errors"));
        } else {
            if (this.status == SmarterMapsPB.Status.WARNING) {
                return;
            }
            if (!this.getUnmatchedNames().isEmpty() || !this.getAmbiguousNames().isEmpty()) {
                this.setStatus(SmarterMapsPB.Status.WARNING);
            } else {
                this.setStatus(SmarterMapsPB.Status.SUCCESS);
            }
        }
    }

    public void resolveResult() {
        List<Integer> locIds = this.getUniqueLocationIds();
        List<String> locationNames = this.getUniqueNames();
        locationNames.addAll(this.getAmbiguousNames());
        ArrayList<String> ambigNames = new ArrayList<String>();
        ambigNames.addAll(this.getAmbiguousNames());
        if (this.locationMap.size() == 1) {
            if (locIds.isEmpty()) {
                if (ambigNames.isEmpty()) {
                    this.result.put((Object)"status", (Object)SmarterMapsPB.Status.FAILURE.getName());
                    JSONArray unmatchedNameArray = new JSONArray();
                    unmatchedNameArray.addAll(this.getUnmatchedNames());
                    if (unmatchedNameArray.size() > 0) {
                        this.result.put((Object)"unmatched", (Object)unmatchedNameArray);
                    }
                    return;
                }
                ISMLocation location = (ISMLocation)this.locationMap.keySet().toArray()[0];
                List<Integer> ids = this.indexer.getLocationIds(location);
                this.result.put((Object)"status", (Object)SmarterMapsPB.Status.WARNING.getName());
                this.result.put(ambigNames.get(0), (Object)ids.get(0));
                ISMLocation key = (ISMLocation)this.locationMap.keySet().toArray()[0];
                this.locationMap.put(key, ids.get(0));
                JSONArray ambiguousNameArray = new JSONArray();
                ambiguousNameArray.addAll(this.getAmbiguousNames());
                if (ambiguousNameArray.size() > 0) {
                    this.result.put((Object)"ambiguous", (Object)ambiguousNameArray);
                }
                return;
            }
            this.result.put((Object)"status", (Object)SmarterMapsPB.Status.SUCCESS.getName());
        } else {
            this.result = this.indexer.getMap(this.locationMap);
            if (this.result == null || this.result.isEmpty() || this.result.get((Object)"errors") != null) {
                if (this.result.get((Object)"errors") == null) {
                    this.result.put((Object)"errors", (Object)"None of the locations match");
                }
                return;
            }
            JSONArray ambiguous = (JSONArray)this.result.get((Object)"ambiguous");
            this.ambiguousNames.clear();
            if (ambiguous != null) {
                for (int i = 0; i < ambiguous.size(); ++i) {
                    this.ambiguousNames.add((String)ambiguous.get(i));
                }
            }
        }
    }

    public Set<String> getUnmatchedNames() {
        return this.unmatchedNames;
    }

    public Set<String> getAmbiguousNames() {
        return this.ambiguousNames;
    }

    public SmarterMapsPB.Status getStatus() {
        return this.status;
    }

    public JSONObject getJSON() {
        return this.result;
    }

    public Map<ISMLocation, Integer> getLocationMap() {
        return this.locationMap;
    }

    public String getAmbiguityMessage() {
        return this.ambiguityMessage;
    }

    public void setAmbiguityMessage(String ambiguityMessage) {
        this.ambiguityMessage = ambiguityMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public List<Integer> getUniqueLocationIds() {
        Set<Integer> keys = this.uniqueLocations.keySet();
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(keys);
        return result;
    }

    public List<String> getUniqueNames() {
        Collection<String> values = this.uniqueLocations.values();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(values);
        return result;
    }

    public void addToMap(ISMLocation sMLocation, Integer id) {
        this.locationMap.put(sMLocation, id);
    }
}

