/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AmbiguityHandler {
    private LocationIndexer indexer = null;

    public void setIndexer(LocationIndexer indexer) {
        this.indexer = indexer;
    }

    private int[] countTypes(Set<ISMLocation> iLocations) {
        if (iLocations == null || iLocations.size() == 0) {
            return null;
        }
        LocationEntry.Type[] typeList = LocationEntry.Type.values();
        int len = typeList.length;
        int[] typeCount = new int[len];
        for (int i = 0; i < len; ++i) {
            typeCount[i] = 0;
        }
        for (ISMLocation location : iLocations) {
            for (int i = 0; i < len; ++i) {
                ArrayList<ISMLocation> list = new ArrayList<ISMLocation>();
                list.add(location);
                if (typeList[i] == LocationEntry.Type.CITY || this.indexer.isGenericRegion(list) || !this.locationCanBe(typeList[i], location)) continue;
                int n = i;
                typeCount[n] = typeCount[n] + 1;
            }
        }
        return typeCount;
    }

    private boolean isAncestor(Integer ancestorId, Integer locId, List<LocationIndexer.DisputedTerritories> dTerritories) {
        List<Integer> path = this.indexer.getPathToRoot(locId, dTerritories);
        return path.contains(ancestorId);
    }

    private boolean locationCanBe(LocationEntry.Type nameType, ISMLocation location) {
        List<Integer> locIds = this.indexer.getLocationIds(location);
        if (locIds == null) {
            return false;
        }
        for (Integer locId : locIds) {
            LocationEntry.Type type = this.indexer.getLocation(locId).getType();
            if (type != nameType) continue;
            return true;
        }
        return false;
    }

    private boolean nameHasVerticalAmbiguity(ISMLocation iLocation, List<LocationIndexer.DisputedTerritories> dTerritories) {
        List<Integer> locIds = this.indexer.getLocationIds(iLocation);
        if (locIds.size() < 2) {
            return false;
        }
        for (int i = 0; i < locIds.size() - 1; ++i) {
            for (int j = i + 1; j < locIds.size(); ++j) {
                Integer locIdj = locIds.get(j);
                LocationEntry entry = this.indexer.getLocation(locIdj);
                if (entry.getType() == LocationEntry.Type.CITY || !this.isAncestor(locIds.get(i), locIds.get(j), dTerritories)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allNamesHaveVerticalAmbiguity(Set<ISMLocation> iLocations, List<LocationIndexer.DisputedTerritories> dTerritories) {
        for (ISMLocation iLocation : iLocations) {
            if (this.nameHasVerticalAmbiguity(iLocation, dTerritories)) continue;
            return false;
        }
        return true;
    }

    public JSONObject processAmbiguousList(Set<ISMLocation> iLocations, List<LocationIndexer.DisputedTerritories> dTerritories, Integer ancestorId) {
        LocationEntry.Type type;
        StringBuffer errors = new StringBuffer();
        JSONObject geoJSON = new JSONObject();
        JSONObject resolvedIds = new JSONObject();
        int[] types = this.countTypes(iLocations);
        int locationCount = iLocations.size();
        ArrayList<LocationEntry.Type> sameTypes = new ArrayList<LocationEntry.Type>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != locationCount) continue;
            type = LocationEntry.Type.values()[i];
            sameTypes.add(type);
        }
        if (sameTypes.size() > 0) {
            if (sameTypes.size() == 1) {
                String errors1 = this.moreThanOneLocation(iLocations, (LocationEntry.Type)((Object)sameTypes.get(0)), ancestorId, dTerritories);
                if (errors1.length() > 0) {
                    geoJSON.put((Object)"errors", (Object)errors1);
                } else {
                    type = (LocationEntry.Type)((Object)sameTypes.get(0));
                    block1: for (ISMLocation iLocation : iLocations) {
                        String name = iLocation.getName();
                        List<Integer> locIds = this.indexer.getLocationIds(name);
                        if (locIds == null) continue;
                        for (Integer locId : locIds) {
                            if (this.indexer.getLocation(locId).getType() != type || (type == LocationEntry.Type.REGION || type == LocationEntry.Type.PROVINCE || type == LocationEntry.Type.COUNTY || type == LocationEntry.Type.CITY || type == LocationEntry.Type.GROUP) && !this.isAncestor(ancestorId, locId, dTerritories)) continue;
                            resolvedIds.put((Object)iLocation.getName(), (Object)locId);
                            continue block1;
                        }
                    }
                    geoJSON.put((Object)"resolvedIds", (Object)resolvedIds);
                }
            } else if (this.allNamesHaveVerticalAmbiguity(iLocations, dTerritories)) {
                for (ISMLocation iLocation : iLocations) {
                    List<Integer> locIds = this.indexer.getLocationIds(iLocation);
                    resolvedIds.put((Object)iLocation.getName(), (Object)locIds.get(0));
                }
                geoJSON.put((Object)"resolvedIds", (Object)resolvedIds);
            } else {
                String errNames = "";
                for (ISMLocation iLocation : iLocations) {
                    errNames = errNames + iLocation.getName() + ",";
                }
                geoJSON.put((Object)"errors", (Object)("Cannot disambiguate: the following locations could be either " + ((LocationEntry.Type)((Object)sameTypes.get(0))).name() + " or " + ((LocationEntry.Type)((Object)sameTypes.get(1))).name() + " : " + errNames));
            }
        } else {
            for (ISMLocation iLocation : iLocations) {
                String name;
                List<Integer> locIds = this.indexer.getLocationIds(iLocation);
                if (locIds == null || !this.isAmbiguous(name = iLocation.getName())) continue;
                if (this.nameHasVerticalAmbiguity(iLocation, dTerritories)) {
                    if (this.hasSiblings(locIds.get(1), iLocations)) {
                        resolvedIds.put((Object)name, (Object)locIds.get(1));
                        continue;
                    }
                    resolvedIds.put((Object)name, (Object)locIds.get(0));
                    continue;
                }
                ArrayList<LocationEntry.Type> typesForLocation = new ArrayList<LocationEntry.Type>();
                LocationEntry entry = null;
                LocationEntry.Type type2 = null;
                for (Integer id : locIds) {
                    entry = this.indexer.getLocation(id);
                    type2 = entry.getType();
                    if (type2 == LocationEntry.Type.CITY || typesForLocation.contains((Object)type2)) continue;
                    typesForLocation.add(type2);
                }
                if (typesForLocation.size() == 1) {
                    resolvedIds.put((Object)name, (Object)locIds.get(0));
                    continue;
                }
                int[] counts = new int[typesForLocation.size()];
                for (int i = 0; i < counts.length; ++i) {
                    type2 = (LocationEntry.Type)((Object)typesForLocation.get(i));
                    for (ISMLocation iLocation1 : iLocations) {
                        if (!this.locationCanBe(type2, iLocation1)) continue;
                        int n = i;
                        counts[n] = counts[n] + 1;
                    }
                }
                int maxCount = -1;
                int maxIndex = -1;
                for (int i = 0; i < counts.length; ++i) {
                    if (counts[i] <= maxCount) continue;
                    maxCount = counts[i];
                    maxIndex = i;
                }
                LocationEntry.Type maxType = (LocationEntry.Type)((Object)typesForLocation.get(maxIndex));
                counts[maxIndex] = 0;
                int maxCount2 = -1;
                int maxIndex2 = -1;
                for (int i = 0; i < counts.length; ++i) {
                    if (counts[i] <= maxCount2) continue;
                    maxCount2 = counts[i];
                    maxIndex2 = i;
                }
                LocationEntry.Type maxType2 = (LocationEntry.Type)((Object)typesForLocation.get(maxIndex2));
                if (maxCount >= 2 * maxCount2) {
                    List<Integer> ids = this.indexer.getLocationIds(iLocation, maxType);
                    if (ids.size() == 1) {
                        resolvedIds.put((Object)name, (Object)ids.get(0));
                        continue;
                    }
                    int countUnderAncestor = 0;
                    int locId = -1;
                    for (int i = 0; i < ids.size(); ++i) {
                        if (!this.isAncestor(ancestorId, ids.get(i), dTerritories)) continue;
                        ++countUnderAncestor;
                        locId = ids.get(i);
                    }
                    if (countUnderAncestor == 1) {
                        resolvedIds.put((Object)name, (Object)locId);
                        continue;
                    }
                    geoJSON.put((Object)"errors", (Object)("Cannot generate map :" + name + " appears multiple times as " + (Object)((Object)maxType) + " in " + this.indexer.getLocation(ancestorId).getName() + "; "));
                    return geoJSON;
                }
                errors.append(name + " is " + (Object)((Object)maxType) + " or " + (Object)((Object)maxType2) + "; ");
            }
            if (errors.length() > 0) {
                geoJSON.put((Object)"errors", (Object)errors.toString());
            } else {
                String errors1 = this.locationsThatContainOtherLocation(iLocations, resolvedIds, dTerritories);
                if (!errors1.isEmpty()) {
                    geoJSON.put((Object)"errors", (Object)errors1);
                } else {
                    String errors2 = this.moreThanOneLocation(iLocations, LocationEntry.Type.PROVINCE, ancestorId, dTerritories);
                    if (!errors2.isEmpty()) {
                        geoJSON.put((Object)"errors", (Object)errors2);
                    } else {
                        geoJSON.put((Object)"resolvedIds", (Object)resolvedIds);
                    }
                }
            }
        }
        return geoJSON;
    }

    public String locationsThatContainOtherLocation(Set<ISMLocation> iLocations, JSONObject resolvedIds, List<LocationIndexer.DisputedTerritories> dTerritories) {
        StringBuffer errors = new StringBuffer();
        block0: for (ISMLocation iLocation : iLocations) {
            List<Integer> allIds = this.indexer.getLocationIds(iLocation);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Integer id : allIds) {
                ids.add(id);
            }
            Integer id = -1;
            id = ids.size() == 1 ? (Integer)ids.get(0) : (Integer)resolvedIds.get((Object)iLocation.getName());
            for (ISMLocation iLocationChild : iLocations) {
                if (iLocation.getName().equals(iLocationChild.getName())) continue;
                List<Integer> childIds = this.indexer.getLocationIds(iLocationChild);
                Integer childId = -1;
                childId = ids.size() == 1 ? childIds.get(0) : (Integer)resolvedIds.get((Object)iLocation.getName());
                if (!this.indexer.isParent(id, childId) && !this.indexer.isGrandParent(id, childId)) continue;
                errors.append(iLocation.getName() + " contains " + iLocationChild.getName() + "; ");
                continue block0;
            }
        }
        if (errors.length() > 0) {
            errors.insert(0, "Cannot generate map: ");
        }
        return errors.toString();
    }

    public String locationsThatContainOtherLocation(List<Integer> locIds, List<LocationIndexer.DisputedTerritories> dTerritories) {
        StringBuffer errors = new StringBuffer();
        for (int i = 0; i < locIds.size() - 1; ++i) {
            Integer id = locIds.get(i);
            String name = this.indexer.getLocation(id).getName();
            for (int j = i + 1; j < locIds.size(); ++j) {
                Integer childId = locIds.get(j);
                String childName = this.indexer.getLocation(childId).getName();
                if (!this.indexer.isParent(id, childId) && !this.indexer.isGrandParent(id, childId)) continue;
                errors.append(name + " contains " + childName + "; ");
            }
        }
        if (errors.length() > 0) {
            errors.insert(0, "Cannot generate map: ");
        }
        return errors.toString();
    }

    public boolean isAmbiguous(String name) {
        List<Integer> locIds = this.indexer.getLocationIds(name);
        if (locIds == null) {
            return false;
        }
        if (locIds.size() < 2) {
            return false;
        }
        int count = 0;
        LocationEntry entry = null;
        for (Integer locId : locIds) {
            entry = this.indexer.getLocation(locId);
            LocationEntry.Type type = entry.getType();
            if (type == LocationEntry.Type.CITY) continue;
            ++count;
        }
        return count > 1;
    }

    private boolean hasSiblings(Integer locationId, Set<ISMLocation> iLocations) {
        LocationEntry entry2 = null;
        LocationEntry entry = this.indexer.getLocation(locationId);
        Integer parentId = entry.getFirstParentId();
        LocationEntry.Type type = entry.getType();
        for (ISMLocation iLocation : iLocations) {
            List<Integer> locIds = this.indexer.getLocationIds(iLocation);
            if (locIds == null) {
                return false;
            }
            for (Integer locId : locIds) {
                if (locationId.equals(locId) || (entry2 = this.indexer.getLocation(locId)).getType() != type || !entry2.getFirstParentId().equals(parentId)) continue;
                return true;
            }
        }
        return false;
    }

    private String moreThanOneLocation(Set<ISMLocation> iLocations, LocationEntry.Type locationType, Integer ancestorId, List<LocationIndexer.DisputedTerritories> dTerritories) {
        StringBuffer errors = new StringBuffer();
        for (ISMLocation iLocation : iLocations) {
            List<Integer> locIds = this.indexer.getLocationIds(iLocation);
            boolean found = false;
            String name = iLocation.getName();
            if (locIds.size() <= 1) continue;
            for (Integer locId : locIds) {
                LocationEntry entry = this.indexer.getLocation(locId);
                if (name.length() == 2 && !entry.getAliases().contains(name) || entry.getType() != locationType || !this.isAncestor(ancestorId, locId, dTerritories)) continue;
                if (found) {
                    errors.append(name + ", ");
                    continue;
                }
                found = true;
            }
        }
        if (errors.length() > 0) {
            return "Cannot generate map because there are multiple locations: " + errors.toString();
        }
        return "";
    }
}

